+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-11-20T21:57:00-05:00"
lastmod = "2015-11-23T10:14:00-05:00"
preamble = "[Jeunesses Musicales du Canada](/scene/companies/jeunesses-musicales-canada/) is about getting more people, young people in particular, listening to classical music, and getting emerging artists to present it. Part of JMC's annual calendar of around 1600 concerts and workshops is a touring operatic production, and this year's pick is Gounod's [*Roméo et Juliette*](http://www.jmcanada.ca/en/concerts/38/romeo-and-juliet---opera-by-charles-gounod). A cast of six singers and one pianist bring the production, directed by [Oriol Tomas](http://www.orioltomas.com/), around Québec, New Brunswick, and Nova Scotia. [Myriam Leblanc](/scene/people/myriam-leblanc/) is Juliette, opposite both [Tonatiuh Abrego](/scene/people/tonatiuh-abrego/) and [Marcel d'Entremont](/scene/people/marcel-dentremont/), alternating performances of Roméo; when they're not singing the title role, they sing Tybalt. Baritone [Geoffroy Salvas](/scene/people/geoffroy-salvas/) sings Mercutio, bass [Dylan Wright](/scene/people/dylan-wright/) is Capulet and Frère Laurent, and mezzo-soprano [Katrina Westin](/scene/people/katrina-westin/) sings Gertrude and Stephano. I asked the cast of singers, as well as pianist/orchestra [Carol-Anne Fraser](/scene/people/carol-anne-fraser/), about the demands and rewards of singing in a JMC tour."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1448289971387/2015-11-22---JMCSquare.jpg.jpg"
primary_image_credit = "Marcel d'Entremont, Dylan Wright, Myriam Leblanc, Tonatiuh Abrego, Katrina Westin, and Geoffroy Salvas. Photo by Antoine Saito."
publishDate = "2015-11-23T09:33:00-05:00"
related_articles = ["articles/on-the-road-the-bicycle-opera-project.md"]
related_companies = ["scene/companies/jeunesses-musicales-canada.md"]
related_people = ["scene/people/myriam-leblanc.md","scene/people/marcel-dentremont.md","scene/people/tonatiuh-abrego.md","scene/people/katrina-westin.md","scene/people/dylan-wright.md","scene/people/geoffroy-salvas.md","scene/people/carolanne-fraser.md"]
short_description = "Jeunesses Musicales du Canada is about getting more people, young people in particular, listening to classical music, and getting emerging artists to present it. Part of JMC&#039;s annual calendar of around 1600 concerts and workshops is a touring operatic production, and this year&#039;s pick is Gounod&#039;s Roméo et Juliette. A cast of six singers and one pianist bring the production, directed by Oriol Thomas, around Québec, New Brunswick, and Nova Scotia."
slug = "on-the-road-jmc-romeo-juliette"
title = "On the road with JMC&#039;s Roméo et Juliette"
+++

## The demands of a tour

The cast of *Roméo et Juliette* knows that a touring production comes with specific demands. It's harder to maintain the same level of energy while on the road, and singers have to work hard to pace themselves over several weeks.
 
Tonatiuh Abrego finds the difference lies in being an adaptable performer. "On tour you don't know what will happen in each performance with regards to the size to the size of the venue and the schedule you have leading up to it." The *Roméo et Juliette* team may have an evening performance, followed by an early morning drive for a matinée in a new city. With a new city, comes a new venue and new variables for the performers. "All of this keeps you mentally alert and flexible," says Abrego. "It certainly keeps the show fresh for the performers and challenges us to solidify our roles technically and artistically so that we can have consistent quality in our performances."

Flexibility can be a plus, too. Pianist Carol-Anne Fraser finds freedom in playing orchestra for a portable show. "I don't have to have my eyes glued to a conductor, so I can respond to what each of the singers is doing and I feel more connected to them musically and emotionally." Since she's the orchestra, Fraser also gets to enjoy that pianist's rarity, the curtain call. "I've always loved watching the big group take a bow holding hands at the end of an opera, and it's really nice to finally be a part of that and feel the group energy!"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1448291266460/2015-11-21---JMC150830web-418.jpg.jpg)<figcaption>Marcel d'Entremont (Tybalt) and Goeffroy Salvas (Mercutio). Photo by Antoine Saito.</figcaption>
</figure>

## Keeping healthy on the road

A singer is a vault of information on staying healthy, and tours are notoriously counter-productive for staying in top vocal shape. Armed proactively with vitamins, Ricola cough drops, Cold FX, and EmergenC, the *Roméo et Juliette* team focus on the basics: healthy food, lots of water, and plenty of sleep. "I always carry protein bars and try to get in my fruits and veggies each day," says Fraser. "And of course the best prevention is staying hydrated and getting lots of sleep!" Abrego works hard to eat healthy, "which is very hard on the road," and he creates a routine for himself on the road by making time to work out. "A lot of hotels have gyms so I can do weight training and running. If there isn't a gym at the hotel and then I'll try and find a local gym in the town to go for the day."

A good night's sleep, too, can be hard to come by on tour; new beds, weird hours, it can mess with a lot when it comes to singers. Abrego is one for getting to bed early "Sleep is crucial for consistent performances."

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/QbBM_UaU6Ac" frameborder="0" allowfullscreen></iframe>
</figure>

## The case for *Roméo et Juliette*

"It's in French, and many of the JMC concert locations are in small Francophone communities," says Fraser of Jeunesses Musicales Canada's choosing Gounod's opera for this year's tour. She notes that there are English subtitles included in Anglophone-area venues, and that despite the language barrier, the story is well-known enough for the opera to engage audiences ("everyone knows the story of *Romeo and Juliet.*"). Abrego puts it well: "The Francophone community has loved hearing their language sung with such beautiful music and the Anglophone community, who already knows the story, enjoys hearing a classic tale told a very romantic language spoken in Canada."

Gounod's score is objectively gorgeous, and its beauty is something that even the greenest of listeners can experience. A show like his *Roméo* is a great introductory piece for opera newcomers, since the story is already familiar, and it's easy to hear how the music complements the emotional heights. Says Fraser, "The idea of loving someone so much that you would sacrifice anything just to be with them resonates with a lot of people, and is what makes this opera so special."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1448244860697/2015-11-21---JMC150830web-415.jpg.jpg)<figcaption>l-r: Marcel d'Entremont (Tybalt), Tonatiuh Abrego (Roméo), Geoffroy Salvas (Mercutio). Photo by Antoine Saito.</figcaption>
</figure>

Abrego vouches for this production by stage director [Oriol Tomas](http://www.orioltomas.com/), and its ability to engage an audiences in a tangible way. "In our production every character is distinct, memorable and has an important contribution to the story; there are no superfluous characters and we all have something important to say and beautiful music to go along with it."

Jeunesse Musicales Canada's production of *Roméo et Juliette* tours until December 9th in Québec, Nova Scotia, and New Brunswick. For details and ticket information, follow our box office links below. "The story has love, hate, betrayal, friendship, as well as dancing and a thrilling fight scene," says Abrego. "It's a really entertaining show with high quality art!"
