+++
author = ["authors/isaiah-bell.md"]
categories = "Op-ed"
date = "2014-03-01T22:25:00+01:00"
lastmod = "2017-03-06T17:12:00+01:00"
preamble = "This is a guest post by [Isaiah Bell](/authors/isaiah-bell/), Canadian tenor and co-host of [*Overthought: A Podcast*](http://www.overthoughtpodcast.com/)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1468291614804/2016-07-11---Bubble.jpg.jpg"
publishDate = "2014-03-01T22:25:00+01:00"
related_articles = ["articles/schmopera-is-one.md","articles/the-business-of-passion.md","articles/and-i-know-things-now.md","articles/morbid-musings-art-death.md","articles/the-time-i-spilled-some-secrets-into-a-microphone.md","articles/schmopera-is-three.md","articles/conundrums-singing-on-command.md","articles/selfdoubt-the-accidental-manual.md","articles/4-unwritten-skills-professional-singers-need.md"]
related_people = ["scene/people/isaiah-bell.md"]
short_description = "I want people to like me.  I got into singing because I want people to like me. Yup. Of course, I didn’t think of it like that at the time; wanting people to like you is not necessarily an attractive quality.  Later, when I really thought about what it means to be a performer, I decided that I didn’t actually want it to be about me."
slug = "on-the-ego"
title = "On the ego"
+++

I want people to like me.  I got into singing because I want people to like me.

Yup.

Of course, I didn’t think of it like that at the time; wanting people to like you is not necessarily an attractive quality.  Later, when I really thought about what it means to be a performer, I decided that I didn’t actually want it to be about me.  I’m a conduit; the creators of the piece speak to the audience through me, and as the message passes through me my own watermark is imprinted on it, etc.  Which is all well and good, but I still want people to like me.

If things are going well, these two objectives can cohabit fairly amicably.  The trouble comes when I feel like I’m not doing well at my job – which is to sing awesome high notes and to sing in tune and to sing fast notes really fast, and to be "musical," and to pretend to be someone who is not me, who is doing something that is not what I'm doing ("acting").  At these times all I can think is, wow, you are doing a really bad job.  All that space in my head that should be filled up with – where does Ernesto/Tamino/"The First Jew" ("me") want to go next, how can I participate more actively in this music that I’m absent-mindedly reciting, for God's sake what am I _saying_ – is taken up entirely with, you're a bad singer.  Worse: you're a bad person.  All these people know you're a fraud.  They're bored, uncomfortable and/or actively angry at you for being a waste of their time and money.  You have failed them and yourself.

Seriously.  Now, imagine how inspiring and transporting the performance is going to be when the tenor is having _that_ conversation in his brain.

Let’s be clear.  Classical singing is hard.  I'm a hard worker, and totally dedicated, but sometimes things just don’t work out.  It takes a long time to get good at it, and it’s the finickiest of disciplines, and even the greats have crashed and burned at some point or other.  But seriously.  This goes on in my head _all the time_.

So the whole time that this has been happening (a period of time that coincides exactly with the amount of time I've been performing), I've enabled the onslaught of self-loathing that occurs when the reality of my performance isn’t up to standard with _this_ logic ("logic"):

a) _When I'm good_, this won’t happen any more.

b) It's important for me to know when I’m doing badly, so that I can fix it later.

c) It's my responsibility to the audience/my mentor/my friends/the engager to do well. When I do poorly, I have failed them and must take responsibility for that failure.

d) It's important that I know I’ve done badly, _so that no one can surprise me with this information later_.  If I'm aware before anyone else is, at least I retain some measure of control and dignity in the situation.

It's not that I actually think this a healthy thought pattern; I'm acutely aware of how debilitating it can be, and I‘ve developed some strategies to reduce its impact by keeping other focuses.  But it hasn’t been until recently that I've realized how much the responsibility for it actually rests on my **ego**.

That may sound stupid, because a bruised ego is obviously the thing that's smarting after a singing snafu.  But it’s less obvious, to me at least, that this act of self-deprecation is an actual _function_ of my ego.  I always thought that the bad feeling was my poor tender ego being victimized by external standards.  But the truth seems to be that it is my ego itself that is doing the attacking.

My brain registers the information: this is not going very well.  Leaving aside whether or not my brain _should_ be analyzing instead of doing (another topic for another day), and whether or not I have set an impossible standard (yet another topic – many _fascinating_ pages of navel-gazing to come), this information, at times, comes to be registered.  Now, a logical mind that was not entirely dominated by a megalomaniacal ego would probably go: - That sucks.  Let's try to finish what we’re doing in the best way we can, and figure out later what went wrong. -  A logical mind, that is, recognizes that when the plane’s engines are failing, even _more_ energy and mental faculties need to be devoted to landing the plane safely, and approximately 0% of available resources should be spent yelling in the pilot's ear that this is his fault and he will never fly again.

But when my **crazy** ego catches wind of this information, all hell breaks loose (since less-than-perfect singing obviously equals universal rejection).  So immediate is its need to feel constant approval that it begins to override all other functions.  My ego,  like a hungry child, has no concept of the bigger picture or of anything outside the immediate: feed me; like me. When it reacts so violently to a performance gone awry, it's as if it is trying to punish the rest of me, the "parent", for not doing well enough. You got me into this situation; I am being hurt by your failure.  When something goes wrong, we always look for someone to blame: it's in our nature.  With me, it's me.

And, of course, these ego tantrums aren’t limited to the actual performance, but continue long afterwards, when the spoiled child/fussy ego has to be pampered and bribed into not making such a stink.

None of this is particularly shocking information, and when it's all laid out I wonder why I didn’t make these connections sooner.  But after distilling countless hours' worth of abject misery into this tidy observation, I have come up with a "well, when you put it like that…" moment.

I really want to be liked.  I want to be liked so bad that it routinely derails me.  The more important something is to my success as a singer, the easier it is for my ego to take over.  My full self is more complicated than that, though.  Sure, everybody wants to be liked.  It's a basic instinct.  But the part of me that has bigger ideas – the part that wants to use my hard work and my gifts to spread beauty, to say through music what can’t be said in words, to connect people to each other by sharing different understandings of the human experience – needs to be the parent.  It’s not really about me.  If I'm in this career to get approval and feel validated, I’m going to have a life full of disappointment, and any joy I bring to people is going to be a **by-product** of my own quest to feed my ever-expanding, ever-demanding ego.

Since putting this all together, I've been afforded, ahem, a *number* of opportunities to test out this outlook, on Real Life Performance Difficulties.  Cutting the ego tantrum short doesn’t always work, but when it does the difference is tangible.  Not only can I actually _feel_ that my energy is freed up to address the problem at hand – the energy that has historically, in these situations, been caught in a whirlpool of judgement – but when I get offstage I'm often able to dodge that crushing wave of post-performance self-loathing.  I know that I didn't waste resources beating myself up for doing a bad job when I should have been focusing on doing that job.  I did the best I could.  It's liberating – so liberating that I've actually caught myself feeling bad for not feeling bad.  I'm so used to raking myself over the coals for every bungled bar that I felt like I was letting myself off the hook.  **_How crazy is that_**?
