+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2014-10-14T09:54:00-04:00"
lastmod = "2015-04-25T22:21:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1430014883109/Piano-Technology.jpg.jpg"
publishDate = "2014-10-14T09:54:00-04:00"
related_articles = ["articles/how-to-lead-your-pianist.md","articles/how-to-play-for-singers.md","articles/4-secrets-for-better-high-notes.md"]
short_description = "I remember working with a class of first year voice students a few years ago; I saw them all individually (totally a bad idea, switched to masterclass format the next year), and I got the sense that for a majority of these students, they were working with a vocal coach for the first time. One particularly outspoken singer asked an unexpected question during our first coaching session together: &quot;But, you&#039;re a pianist. Why are you telling me what to do?&quot;"
slug = "on-pianists-those-vicarious-opera-singers"
title = "On Pianists, Those Vicarious Opera Singers"
+++

I remember working with a class of first year voice students a few years ago; I saw them all individually (totally a bad idea, switched to masterclass format the next year), and I got the sense that for a majority of these students, they were working with a vocal coach for the first time. One particularly outspoken singer asked an unexpected question during our first coaching session together: "But, you're a pianist. Why are you telling me what to do?"

The question was phrased like you'd expect from an 18-year old, but it's unfair to say that the question was unreasonable. So, why was I telling her what to do? The short answer: because I know how to help her sing better. But the student's question was about how I, a pianist with no useful singing skills, knew how to talk about the voice. I'll give you one more short answer before I elaborate: I know how to talk about the voice because I've heard tons of them.

It's a common story with a few variables: a young pianist heads off to some form of post-secondary education or internship, and realizes quickly that beyond the realm of Nocturnes and Sonatas, there's an endless amount of music written for Piano and Something Else. The young pianist is forced/invited/bribed to join some sort of chamber ensemble to get a credit in school, and she realizes that playing with other people is super fun and it makes her a better musician.

Pianists who decide to work with singers do so largely by playing regular voice lessons, and here's where I get to answer that student's question from years ago. It's in these countless hours of playing voice lessons that pianists become coaches (if they're paying attention). They learn to identify what it sounds like when a singer is pressing on the voice, or under-supporting, or clenching their jaw, or holding their breath, or when they're out of tune and why. And as pianists work for more and more technically developed singers, they get the real treat of hearing what it sounds like when a voice is supported well and free from tension; I'll spoil it for all you and tell you that it sounds thrilling.

But wait, don't singers also go through countless hours of voice lessons? How come a coach is considered the authority? Simply put, we went to more lessons than singers did. To be fair, we often aren't there for the first 30 minutes, which is when the real technical nitty-gritty goes down between teacher and student. But once the pianist arrives, the lesson is about putting the last half hour's technical improvements into the aria you're trying to sing. The pianist gets to sit in on this process over and over, learning the semantics used by voice teachers and hearing the results in real time from the singer. Even in between these weekly lessons, young coaches are forced into a sort of accelerated Opera 101 course in order to stay afloat with all the new music in front of them. We learn about _da capo_ arias and voice types and the point of _bel canto_ and German and whether it's the high or the low key.

Simply put, pianists have quantity on their side. Quantity of voice lessons to watch, arias to learn (and learn about), and even quantity of vocal "case studies". Let me explain that last one: many specific technical or musical hurdles that come up in coaching sessions fall under broad categories, like "breath" or "rhythm". A coach learns what these are by hearing lots of so-called "case studies"; once you've heard a few singers learn the difference between singing legato and not, you start to hear the mechanics of the voice, like listening beyond someone's timbre and into their technique. It really is all about listening. A coach is a really educated set of ears for a singer, not a replacement for a voice teacher. In fact, with a good singer, a coach can do their job simply by telling that singer what they hear, with no need for a follow-up suggestion; the singer takes what they've learned with their teacher and applies it to the issues that the coach hears.

And in the meantime, the coach is still a pianist, and he'll hopefully notice how working with singers has helped his idea of rhythm, of legato, and even musical imagination. The formidable Martin Katz said in an [interview](http://www.examiner.com/article/interview-with-pianist-martin-katz), "You must really sing something when you’re playing, differently from when you’re playing Sonata No. 2 or Etude No. 3\. The minute there is a word involved, one’s imagination is electrified in some way, and for me, the whole joy is not just playing the notes, but what the words are saying, what they mean, what they suggest. Somebody who’s not interested in telling stories in their playing should be advised to not do it. If your partner’s telling a story and you’re not, what’s the point?"
