+++
author = ["authors/jeremy-hirsch.md"]
categories = "Review"
date = "2018-11-22T11:35:00-05:00"
lastmod = "2018-11-23T11:14:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542904299836/sqliederabend_christiane_karg_simon_lepper_barbara_aumueller_05.jpg.jpg"
primary_image_credit = "Christiane Karg (soprano) & Simon Lepper Ruf (piano) in recital with the Frankfurter Liederabend, 2018. Photo: Barbara Aumüller."
publishDate = "2018-11-22T11:35:00-05:00"
related_companies = ["scene/companies/oper-frankfurt.md"]
short_description = "Ms. Karg reassured the audience that she had recently performed the two Debussy sets anchoring her program – for this year&#039;s centenary of his death – though never with pianist Simon Lepper (her usual collaborator, the eminent Gerold Huber, was booked). Ms. Karg and Mr. Lepper had never shared the stage before Tuesday night."
slug = "on-days-notice-duo-is-ideal-recital-replacement"
title = "On day&#039;s notice, duo is ideal recital replacement"
+++

Vocal folds are fickle. Sickness can render them unusable, but the show must go on. Christiane Karg, a former Oper Frankfurt ensemble member, who performed a program of Debussy, Satie, and Wagner songs Tuesday night, was booked on one day's notice to replace an ailing Hanna-Elisabeth Müller.
 
Ms. Karg reassured the audience that she had recently performed the two Debussy sets anchoring her program – for this year's centenary of his death – though not with pianist Simon Lepper (her usual collaborator, the eminent Gerold Huber, was booked). Ms. Karg and Mr. Lepper had never shared the stage before Tuesday night.
 
Underdog status can work to a singer's advantage. While the audience warmed to the soprano's timbre – the evening began with Debussy's *Cinq poèmes de Charles Baudelaire* (later she performed the composer's *Ariettes oubliées*) – she and Mr. Lepper became acquainted with each other.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542904389973/liederabend_christiane_karg_simon_lepperbarbara_aumueller.jpg.jpg)
<figcaption>Christiane Karg (soprano) & Simon Lepper Ruf (piano) in recital with the Frankfurter Liederabend, 2018. Photo: Barbara Aumüller.</figcaption>
</figure>

Throughout the evening, Mr. Lepper tactfully accommodated his partner. I imagine under ordinary circumstances his playing is bolder. Tuesday night, it was accurate, pliable, and thoroughly musical. Professionalism is the word, if taken to imply a base level of unimpeachable artistry.
 
Ms. Karg, also an established pro, sang Debussy's songs with understated grace. She emits an aura of dignified calm, the kind only a singer courageous enough to train away personality-aping tics meant to cover vocal deficiencies attains. Her delivery is forthright yet warm. Her highest notes gush forth soothingly, essential for Debussy's wide-ranging melodies that can so easily be mangled by a shrill top.
 
The evening's first set of songs, Debussy's *Cinq poèmes de Charles Baudelaire*, toil toward successive epiphanies. Tangled, murmuring melodies grope their way through uncertain harmonies. Reaching a crisis, the voice leaps headlong into a tangle of dissonance, then improbably, it rises, buoyed into communion with an unfurling of consonance. These brief excursions are like being led through a threshold of opaque turquoise mesh, from a hall of obscure lamplit darkness into a clearing illuminated by jewel refracted light.
 
Debussy's songs, like Paul Verlaine's poems (set by the composer for his *Ariettes oubliées*), are Romances sans paroles – the paradoxical title of Verlaine's collection, meaning "songs without words". Their melodies, harmonies, and structures suggest enough meaning to be understood without explicit texts.
 
Erik Satie's songs, by contrast, do not.
 
Francophones revere Satie's songs, but a non-French speaking public is left cold by them. The rhythmic and harmonic workings of his songs are mere foundations, stable structures to support text. The composer's signature cleverness and wit are lost in translation. No wonder Satie's catalogue is full of rarely performed vocal relics that once had currency, like Socrate or frankly, most of his songs besides "Je te veux", with its seductive cabaret tune. The three works by Satie on the program withered between the robust Debussy cycles.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542904400865/2liederabend_christiane_karg_simon_lepper_barbara_aumueller.jpg.jpg)
<figcaption>Christiane Karg (soprano) & Simon Lepper Ruf (piano) in recital with the Frankfurter Liederabend, 2018. Photo: Barbara Aumüller.</figcaption>
</figure>

At the first words of the final set, Wagner's *Fünf Gedichte von Mathilde Wesendonck*, the audience exhaled in relief. German at last!
 
Mr. Lepper assumed an air of stoic reverence while Ms. Karg's throat seemed to connect directly to her heart. Her frame resonated entirely in her native tongue.
 
Listening to Wagner is like watching a Woody Allen movie or old Cosby standup; the artistic object is tainted by its creator's [detestable past](https://www.dw.com/en/the-hateful-side-of-wagners-musical-genius/a-16850818). That said, people enjoy these songs. Wagner wrote them concurrently with *Tristan und Isolde* and the same motif from the opera's ground breaking prelude appears in the introduction to the final song, "Träume". The composer said about this collection, "I have not written anything better."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542904414260/liederabend_christiane_karg__simon_lepper_barbara_aumueller_02.jpg.jpg)
<figcaption>Christiane Karg (soprano) & Simon Lepper Ruf (piano) in recital with the Frankfurter Liederabend, 2018. Photo: Barbara Aumüller.</figcaption>
</figure>
 
Applauding persistently, the audience ushered the duo back to the stage again and again. With no encore prepared, Ms. Karg instead read a brief verse by Debussy: "Listen to the advice of no one except the wind in the trees. It tells you the story of all humanity." Amidst bravas, she thanked the audience, who warmly thanked her back.
