+++
author = ["authors/andrew-schneider.md"]
categories = "Review"
date = "2018-01-21T12:55:00-05:00"
lastmod = "2018-01-21T18:31:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516557234468/sq---hgo---elektra---piano-rehearsal---photographer-lynn-lane-26-3000x2000.jpg.jpg"
primary_image_credit = "Christine Goerke (Elektra) in Elektra, Houston Grand Opera, 2018. Photo: Lynn Lane."
publishDate = "2018-01-21T18:31:00-05:00"
related_articles = ["articles/in-review-elektra.md","articles/talking-with-singers-christine-goerke.md"]
related_companies = ["scene/companies/houston-grand-opera.md"]
related_people = ["scene/people/christine-goerke.md","scene/people/tamara-wilson.md","scene/people/greer-grimsley.md"]
short_description = "If Strauss had not given Elektra so much deceptively tender waltz music of her own, then Chrysothemis&#039;s tender accompaniments (waltzes about mammaries) would come across as a moment of respite; however, by the time Chrysothemis is introduced, we know Elektra so well that nobody comes across as anything else other than a foil to her. "
slug = "on-a-mental-precipice-hgos-elektra"
title = "On a mental precipice: HGO&#039;s Elektra"
+++

After a turbulent week which demonstrated to Houston the value of preparing for winter weather with an abundance of foresight, a German opera about revengeful Grecian princesses might be the last thing on people's minds. On the other hand, Richard Strauss's *Elektra* rather emphasizes the importance of expecting the unexpected, so it was actually very fitting that Houston Grand Opera's striking opening performance of this music drama was what ended a very chaotic week. 

From the start of this incredibly well-integrated production, and this writer does mean "from the very opening D-minor chord," Elektra ([Christine Goerke](/talking-with-singers-christine-goerke/), moved about with irregular convulsiveness that perfectly matched Strauss's precisely written score, as only to be expected from the master of the tone poem. 

Truly, Goerke demonstrated a fluency in the art of moving from one sentence to the next throughout this production in her tone production, which gleefully matched her character's disoriented personality, while never lapsing into overt crudity. In this way, she could be said to inhabit the stage effortlessly without calling any more attention to herself than the score mandates, which is ultimately what made Elektra believable. Her not infrequent serpentine hissings contributed to the perception of her character always being on a mental precipice, especially when she was on the stage's numerous physical precipices, such perceptions only being aided by the silent-film-like lighting.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516556937721/hgo---elektra---piano-rehearsal---photographer-lynn-lane-13-3000x2000.jpg.jpg)
<figcaption>Chad Shelton (Aegisth), Greer Grimsley (Orest), and Christine Goerke (Elektra) in *Elektra*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

And what a stage she did inhabit indeed! One literally thought of the odysseys of Heinrich Schliemann, that enterprising excavator of the sites of Mycenae and Troy as one saw the imposing temple ruins which dominated the whole of the scene. Even though they caused half of the orchestral ensemble to be invisible to the present writer, their imposing effect was truly palpable; the magnificent sanctuary at the top, which enclosed some sort of fiery furnace, was contrasted at the bottom with an array of broken slate tiles, possibly owing their existence to no government having appropriated funds to repair them.  

But in all seriousness, one was not only confronted with the sense of having discovered something unimaginably marvelous, but also the sense of it having been irreparably corrupted by some insidious force, rather like the manner in which the notoriously crude archeological methods of the aforementioned German visionary likely destroyed the site of the ancient city of Troy. Such paradoxes often inhabit great theatrical constructs, much to our delight.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516556948493/hgo---elektra---piano-rehearsal---photographer-lynn-lane-19-3000x2000.jpg.jpg)
<figcaption>Christine Goerke (Elektra) and Tamara Wilson (Chrysothemis) in *Elektra*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

In the heading of paradox also falls the quandary of how Chrysothemis ([Tamara Wilson](/scene/people/tamara-wilson/)) could possibly be Elektra's sibling. Clearly, she seems so much more pliable to the will of the court of Queen Klytaemnestra ([Michaela Martens](/scene/people/michaela-martens/)), and yet she seems much more open to exposing a world of great human tenderness otherwise cast away from the world of the court and its chatty, yet nervous, maidservants. If Strauss had not given Elektra so much deceptively tender waltz music of her own, then Chrysothemis's tender accompaniments (waltzes about mammaries) would come across as a moment of respite; however, by the time Chrysothemis is introduced, we know Elektra so well that nobody comes across as anything else other than a foil to her. 

Still, Wilson imbued her character with a belief in her own desires to actually have a life, via a luscious connectivity of tone which belied her static figure. Perhaps nothing highlighted these differences so much as these sisters' very last duet, where we get a sense that despite the overwhelming difference in their characters and hence their expressive timbres, Strauss can combine any voices he wants, and he does not even have to be deep about it; he just lets the music do the work in what comes to my ears as a wonderful study for his next closing ensemble for female voices: the *Rosenkavalier* trio.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516556957041/hgo---elektra---piano-rehearsal---photographer-lynn-lane-33-3000x2000.jpg.jpg)
<figcaption>Christine Goerke (Elektra) in *Elektra*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

Queen Klytaemnestra was a creature of a different color. Introduced by music whose ritualistic primitivism closely anticipates Stravinsky's *Le sacre du printemps*, and closely attended thereafter by her train of fawning reptilian yes-persons (Mané Galoyan and Kaitlyn Stavinoha, both of whom possess plenty of cheekily snooty facial expressions to match their limited state-sanctioned repertory of sonorously snarky comments), the Mycenaean queen could best be described as a quasi-hierophant on outward appearance. 

Even with the queen's self-opinionated personality, Martens does admirably in portraying somebody aware that this trait of hers encumbers her path to true self-knowledge, despite all of her attempts to convince herself of the contrary. Strauss well illustrates her efforts at dignity as being anything but regal, with Mahlerian tenuousness. When she does finally utter her soul-curdling cry which marks her slaying by her vengeful son, it is almost with a measure of relief that she finally finds rest from her nightmares.

[Greer Grimsley](/scene/people/greer-grimsley/) as Orest had a very intimidating appearance which spoke to his character's extremes of emotional endurance, and his aquiline and grizzled figure reminded me of the great Nikolai Cherkasov in his portrayal of Tsar Ivan Grozny in Eisenstein's iconic film scored by Prokofiev. His love for his long-lost sister was clearly genuine, though not even it could ever overwhelm the inevitability, indeed, the perceived necessity, for vengeance which looms over the whole scene, to which his Tutor (Anthony Robin Schneider, who also plays the Old Servant) is only too eager to prod him towards "with bated breath." 

The foppish Aegisth (Chad Shelton), his ultimate victim after one too many libations, accompanied by sardonically refined Classical marches, stands no chance whatsoever. Even the yellow color of his dress radiates fatigue and a sense of passive malaise which Shelton portrayed deliberately and with intent. Perhaps we are to interpret the Younger Servant (the splendidly vigorous Richard Trey Smagur) as Aegisth's foil, as how he delusionally sees himself?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516557199850/hgo---elektra---piano-rehearsal---photographer-lynn-lane-40-3000x2000.jpg.jpg)
<figcaption>Christine Goerke (Elektra) in *Elektra*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

The HGO Chorus filled its offstage role with suitable shock value, with a brass choir's luminescence, reminding me of the sound world of Sir Granville Bantock's *a cappella* choral symphony, *Atalanta in Calydon*, written only two years after *Elektra*, and highly analogous to this opera in terms of sheer size and complexity. 

The orchestra, an integral component of any fin-de-siècle opera, was superb, as routinely these players prove themselves to be in German works, though Heckelphone and basset horn fan clubs would surely be disappointed by these instruments' absence in the reduced orchestration used in this production. (Surely a company that prides itself on having just finished a highly anticipated run of *Der Ring des Nibelungen* is not naturally inclined to inhibit itself in this way.) Even though the orchestra was behind the stage as in [*La traviata* earlier this year](/la-traviata-shows-houston-how-to-arise/), they were not in any way muffled as a result this time around, which was just as well with an orchestra of this size and variety. 

While the players' virtuosity made Strauss's music sound like it was written yesterday, with an appealing freshness and authenticity notable for its scarcity in most works written today, and with many attractively tonal moments (read: "waltzes" and "aria-like cadences") that many commentaries about this drama go out of their way to obscure, the timbre as interpreted by conductor Patrick Summers sounded rather stylized and equalized, if not monochromatic, but in a way that made Strauss sound like a proto-Technicolor film score, with all the dazzling effects thereof without being deliberately more shocking than the singers. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516556965234/hgo---elektra---piano-rehearsal---photographer-lynn-lane-41-3000x2000.jpg.jpg)
<figcaption>Tamara Wilson (Chrysothemis) and Christine Goerke (Elektra) in *Elektra*, Houston Grand Opera, 2018. Photo: Lynn Lane.</figcaption>
</figure>

If this performance might not be a reason that one goes on a lark to hear Strauss today, it rather exemplifies that Strauss himself is masterful and timeless, which makes me optimistic that when HGO returns to its venue of choice, they will be able to make numerous Romantic works sound at their very best in considerably more ideal circumstances.

>[Elektra](https://www.houstongrandopera.org/elektra) runs at Houston Grand Opera through February 2. For details and tickets, follow our box office links below.
