+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2018-09-23T13:31:00-04:00"
lastmod = "2018-09-23T15:48:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537723966449/sqEnsemble_2.jpg.jpg"
primary_image_credit = "The ensemble of Odyssey Opera's La Reine de Saba, 2018. Photo: Kathy Wittman."
publishDate = "2018-09-23T15:48:00-04:00"
related_articles = ["articles/odyssey-operas-giovanna-darco-bold-and-flawed.md"]
related_companies = ["scene/companies/odyssey-opera.md"]
related_people = ["scene/people/kevin-thompson.md","scene/people/kara-shay-thomson.md","scene/people/dominick-chenes.md"]
short_description = "Odyssey Opera&#039;s work restored all of the finales of the middle three acts to their complete forms, with a note in the program adding that they believe most of the material they restored had never been heard prior to their performance. That this content was cut to begin with should come as an absolute shock: the restored content felt absolutely vital to how the work unfolds dramatically."
slug = "odyssey-operas-grand-la-reine-de-saba-a-great-season-opener"
title = "Odyssey Opera&#039;s grand La reine de Saba a great season opener"
+++

Whenever an opera company makes it their mission statement to revive infrequently performed gems, the question of how to restore a work with missing content does eventually come up at some point. Thus, when a company decides to not only present a work that has never been done in America, but to also restore material cut during the original production, it's clear that they typically have their work cut out for them. And even then, sometimes their work is not always fruitful: at times, perhaps the cuts were made for the best reasons, and it is at best a historical curiosity. 

However, there comes a few times where the result asks the performers and the listeners to re-evaluate the work, and possibly the composer as well. This latter result describes the efforts of [Odyssey Opera](/scene/companies/odyssey-opera/) in their season-opening concert performance of Charles Gounod's rarely heard grand opera [*La Reine de Saba*](https://www.odysseyopera.org/2018-gounod-la-reine-de-saba/), here presented with restored and reordered content according to how Gounod likely intended it originally.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537723772181/KevinThompson_KaraShayThomson_DominickChenes.jpg.jpg)
<figcaption>The ensemble of Odyssey Opera's *La Reine de Saba*, 2018. Photo: Kathy Wittman</figcaption>
</figure>

Odyssey Opera's work restored all of the finales of the middle three acts to their complete forms, with a note in the program adding that they believe most of the material they restored had never been heard prior to their performance. That this content was cut to begin with should come as an absolute shock: the restored content felt absolutely vital to how the work unfolds dramatically, from the intense blast furnace explosion in the Act II finale and the glorious Prayer Septet that ended the first half of the concert, all the way to the climactic duet in which Solomon and the Queen of Sheba have a duel of wills. This restoration of content not only provides dramatic clarity and direction to a lot of the plot points already present in the opera, but it also restored some of Gounod’s best, most dramatic music. 

The fact that the opera as a whole features some of Gounod's best music was also enough to get us to stop thinking about the fact this libretto takes some pretty extreme liberties with the Queen of Sheba story: the fact the plot revolves around Balkis falling in love with Solomon's architect Adoniram in direct violation of an invented engagement to Solomon became secondary, for the drama made enough sense within the confines of Gounod's music that pointing this out only amounts to a nitpick.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537723843121/KaraShayThomson.jpg.jpg)
<figcaption>Kara Shay Thomson in Odyssey Opera's *La Reine de Saba*, 2018. Photo: Keira Cronin.</figcaption>
</figure>

And to think: if any other company had thought to stage this work, they would have kept the cuts as is! It is not difficult to imagine that any other opera company would be reluctant to restore this music: the performance ran at a whopping three and a half hours, including intermission. However, Odyssey Opera should be applauded for taking this step that, on paper, would seem like a dumb idea: the result really only helped the work in performance. Of course, the work still fell into some of the pitfalls that Parisian grand opera ran into (the ballet sequences at the top of Act IV felt overlong and out of place, as usual), but overall the evening did not overstay its welcome in any way at all.

From a standpoint of performance, Charles Gounod's operas usually require top-caliber singers, and *La Reine de Saba* is absolutely no exception: in fact, if anything, it is demanding even by Gounod's usual standard of difficulty! Adoniram in particular comes to mind: with how the role hovers in the stratosphere for so much of the opera's run-time, and given the orchestration he has to project over, it is almost the kind of role that could only have been written by a man who hated dramatic tenors. However, Dominick Chenes stepped up to the plate wonderfully, adding a warm, soulful voice that defiantly floated above the orchestration in tune with the ways Adoniram eventually ended up defying Solomon's authority in the show's second half. It was such a defiant performance that it wound up stealing the show from the rest of the principle cast, which is fitting considering the character himself ends up occupying more screen time than our actual title character.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537723830108/DominickChenes.jpg.jpg)
<figcaption>Dominick Chenes in Odyssey Opera's *La Reine de Saba*, 2018. Photo: Keira Cronin.</figcaption>
</figure>

The remainder of the cast was no less capable of navigating Gounod's score: in particular, Kara Shay Thomson made for a great Balkis: her role was just that slightest bit less demanding than Adoniram, but she absolutely shone as the title character, lending a warmth to her that suited the character. Also taking a prominent spotlight was Kevin Thompson as King Solomon himself: his bass voice easily projected over the orchestra behind him, and it lent an air of authority to the character that worked quite well with the drama. Matthew DiBattista, David Kravitz, and David Salsbery Fry also made for great villainous foils for Adoniram: the three of them displayed top-notch ensemble work, and gave them the right kind of menacing edge in the climactic quartet in which the three of them attack Adoniram in the final act. 

Rounding out the cast are Michelle Trainor, whose strong voice is underutilized as Adoniram's apprentice Benoni, and Katherine Maysek, who unfortunately did not have much of an opportunity to leave an impression due to how little her character was used throughout the opera. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537723821857/MichelleTrainor.jpg.jpg)
<figcaption>Michelle Trainor in Odyssey Opera's *La Reine de Saba*, 2018. Photo: Keira Cronin.</figcaption>
</figure>

Supporting them is an interesting challenge: for Gounod, *La Reine de Saba* features some unusually heavy orchestration. Thankfully, the Odyssey Opera Orchestra kept a strong command on the score's many subtleties, in no small part thanks to the excellent direction of Gil Rose. The chorus was also excellent, and they did a wonderful job bringing a sense of grandeur to the show's bigger moments, from the chorus that heralds Balkis' entrance all the way to the choral finale in which Balkis sees a vision of Adoniram going into heaven.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1537723812204/Ensemble_1.jpg.jpg)
<figcaption>The ensemble of Odyssey Opera's *La Reine de Saba*, 2018. Photo: Kathy Wittman.</figcaption>
</figure>

Ultimately, the aim of any great concert performance of an opera should be to give the audience a sense that the work should be staged in whatever way possible, and this aim goes double for when the work is something that almost never sees performances. In this case, the mental image of what *La Reine de Saba* would look like onstage certainly matched the grandeur that the performance implied, and it gave me the hope that some day this work could be staged as Gounod intended it to be. Odyssey Opera should certainly be applauded for bringing *La Reine de Saba* to audiences, and in this restored edition it shows it certainly deserves a place in the opera house usually reserved for either *Faust* or *Roméo et Juliette*.
