+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2018-04-08T21:01:00-04:00"
lastmod = "2018-04-08T21:01:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523235648972/sq---DanielSutin_HaeranHong.jpg.jpg"
primary_image_credit = "Daniel Sutin and Haeran Hong in Giovanna D'Arco, Odyssey Opera, 2018. Photo: Kathy Wittman."
publishDate = "2018-04-08T21:01:00-04:00"
related_articles = ["articles/odyssey-operas-grand-la-reine-de-saba-a-great-season-opener.md"]
related_companies = ["scene/companies/odyssey-opera.md"]
short_description = "Of course, Verdi also uses park-and-bark arias and ensembles throughout the score (what opera of that time would be complete without them?), but there is enough musically interesting material going on throughout the whole that it becomes almost criminal that the music serves the libretto it does."
slug = "odyssey-operas-giovanna-darco-bold-and-flawed"
title = "Odyssey Opera&#039;s Giovanna D&#039;Arco Bold and Flawed"
+++

A big problem with many of Giuseppe Verdi's early operas is how they brush up against the conventions of Italian opera: one frequently gets the distinct feeling watching any performance of Verdi's early works that he would have been able to produce much better results, had he eschewed the bel canto trappings of his time. This is especially true of his efforts in *Giovanna D'Arco*, a production of which ended Odyssey Opera's season-long exploration of various rarely-performed musical settings of the life of Joan of Arc.

Verdi does not merely content himself with fighting the conventions of his time in *Giovanna*: here, he also battles a subpar libretto by Temistocle Solera which reads like a bad fanfiction.

First, there is the matter of Giacomo, the father of Giovanna: here, he is rendered as a man willing to betray his country to save Giovanna from the devil, a course of action so over-the-top it pushes credibility even by the standards of most bel canto plots. It also strikes me as inane that Giovanna's personal conflict ends up revolving around an invented love story with King Charles VII. 

And then there is the ending: what insane train of thought convinced Solera that killing Joan of Arc with any course of events other than her iconic execution at the stake was anything even approaching a good idea? And yet, he has her die in battle, before being resurrected and then promptly ascending into heaven: the effect is silly and far too obvious.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523235431793/HaeranHong_withDancers.jpg.jpg)
<figcaption>Haeran Hong with dancers in *Giovanna D'Arco*, Odyssey Opera, 2018. Photo: Kathy Wittman.</figcaption>
</figure>

It is a shame, then, that Solera's libretto is likely the main reason why *Giovanna D'Arco* does not frequently see performances in the modern day, for Verdi still somehow managed to produce dramatic music out of such a libretto. Even Verdi cannot overcome the puerile finale that Solera gave him, but regardless he lends enough emotional weight to the inner turmoil of his characters that he manages to render their motivations mostly credible. 

It is also one of the more interesting scores of his early years, as he makes many musical decisions that many of his other early operas would not have. He has, for example, a very lovely a capella trio near the end of Act I in which Giovanna, Carlo VII, and Giacomo all sing — at the same time — about how Giovanna's meeting with Carlo relates to all of their motivations. 

He also displays a use of his forces that acts as a sort of idée fixe to depict the chorus of angels and demons that speaks to Giovanna on occasion: the chorus of angels is accompanied by harp and harmonium in lines that stretch harmoniously on over long harmonium notes, while the chorus of demons is typically accompanied by punctuated brass chords that underscore the chorus' sinister triplets, and I doubt Verdi would have explored such use of forces in any other work of his. 

Of course, Verdi also uses park-and-bark arias and ensembles throughout the score (what opera of that time would be complete without them?), but there is enough musically interesting material going on throughout the whole that it becomes almost criminal that the music serves the libretto it does.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523235421377/HaeranHong_4.jpg.jpg)
<figcaption>Haeran Hong in *Giovanna D'Arco*, Odyssey Opera, 2018. Photo: Kathy Wittman.</figcaption>
</figure>

Thus, performing Giovanna successfully comes down to having a group of performers who can meet Verdi’s score with confidence and skill; on this front, the players that traversed the stage of the Huntington Avenue Theater were up for the challenge. Haeran Hong absolutely shone as Verdi's titular heroine: one can rarely feel jealous of the poor soprano who takes on Verdi's technically challenging role, but Hong met the role's demands head-on, easily navigating Verdi’s difficult vocal writing with confidence and a technically precise voice that could cut through steel. Hong's confidence also bled into the character, lending great dramatic credence to Carlo's eventual romantic interest in Giovanna and giving us a sense of her heroism, even in her most vulnerable moments. 

Marc Heller is technically her match in the equally demanding role of Carlo VII, and acting-wise he conveyed the reluctant ruler quite well. He also showed some great singing chops, even if his voice did feel a touch too heavy for the role. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523235472836/DanielSutin_1.jpg.jpg)
<figcaption>Daniel Sutin in *Giovanna D'Arco*, Odyssey Opera, 2018. Photo: Kathy Wittman.</figcaption>
</figure>

But of course, the real scene-stealer was Daniel Sutin as Giacomo, who was able to craft a complex, believable character out of the libretto he was given. It is a rare opera singer who can act both with and without his voice, and Sutin showed adept skill at both; the result was magnetic and full of pathos.

Maestro Gil Rose proved to be a steady hand to lead this reading of Verdi's opera. He was able to keep the many elements of Verdi's score perfectly balanced, and I have never heard an opera orchestra play so together whenever the singers took time to perform the ornaments. He also chose his tempi extremely well, not taking anything too fast and allowing the singers time to really nail the emotions of the scene. The only blemish on the evening in terms of the performance was the chorus, which tended to weave in and out of Maestro Rose's tempi to the point that they were noticeably not together at a few points, and the effect was even more noticeable at the times when the chorus had to be offstage.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523235481540/Gil-Rose-Conducting-Odyssey-Opera-Orchestra.jpg.jpg)
<figcaption>Gil Rose conducting the Odyssey Opera Orchestra in *Giovanna D'Arco*, Odyssey Opera, 2018. Photo: Kathy Wittman.</figcaption>
</figure>

The production also had a fairly interesting look: the sets were unusually spare for a production of Verdi, but they were also visually striking and representative of location. The set's color schemes tended to lean towards the darker colors, and while this certainly seemed a little out of place with Verdi’s music it was still quite interesting to look at. Director Beth Greenberg also does what she can to keep the production moving at a brisk pace, and mostly stays out of the way of the singers. 

The only odd issue with the production was the costuming: some of the costumes used were noticeably cheap (Giovanna's suit of armor was made of non-metallic materials), but ultimately even if they were cheap they were not distractingly cheap, as they still fit the look of the production.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523235464595/MarcHeller_4.jpg.jpg)
<figcaption>Marc Heller in *Giovanna D'Arco*, Odyssey Opera, 2018. Photo: Kathy Wittman.</figcaption>
</figure>

In the end, Odyssey Opera should be applauded for its efforts to bring *Giovanna D'Arco* to life. It requires a perfect storm of elements for any production to overcome the sins of a subpar libretto, and fortunately for them the company found exactly the right people to bring Verdi's score to life. It led to an entertaining night at the opera, and even if the production as a whole could not quite overcome the silliness endemic to the opera's last five minutes it still took a diamond in the rough and polished it across the remainder. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523235449779/HaeranHong_MarcHeller_DanielSutin-ltor.jpg.jpg)
<figcaption>Haeran Hong, Marc Heller, and Daniel Sutin in *Giovanna D'Arco*, Odyssey Opera, 2018. Photo: Kathy Wittman.</figcaption>
</figure>

It may not have been a perfect night at the opera, but the performance was still excellent enough to allow us to see the work's merits even despite the many bumps in the road: ultimately, this is the real triumph of the night.
