+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = 2023-01-13T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "_note to a friend_ runs through January 15, 2023. [Details available here.](https://prototypefestival.org/shows/note-to-a-friend/)"
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1673656599/media/2023/01/sq_NotToFriends_009_c_Richard_Termine_mmlj7q.jpg"
primary_image_credit = "(l-r) Theo Bleckmann, Cyrus Moshrefi in note to a friend, Prototype Festival, 2023. Photo credit: © Richard Termine."
related_articles = ["articles/angel-s-bone.md"]
related_companies = ["scene/companies/beth-morrison-projects.md"]
related_people = ["scene/people/david-lang.md"]
short_description = "Suicide has been a frequent topic in opera over the centuries, and usually takes place in the passionate throes of a tragic event. Lang, however, explores the ‘act of taking one’s life’ not as a momentary impulse, but as a personal choice made after a great deal of contemplation."
slug = "note-to-a-friend-matters-of-life-and-death"
title = "note to a friend: MATTERS OF LIFE AND DEATH"
youtube_url = ""

+++
The 2023 [Prototype Festival](https://prototypefestival.org/) is presenting new operas covering some pretty serious subjects. And when composers add music to something dark we ask ourselves - does music shine a light here?

In the case of composer/librettist David Lang's [_note to a friend_](https://prototypefestival.org/shows/note-to-a-friend/), the answer is yes. Suicide has been a frequent topic in opera over the centuries, and usually takes place in the passionate throes of a tragic event. Lang, however, explores the "act of taking one's life" not as a momentary impulse, but as a personal choice made after a great deal of contemplation.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1673656690/media/2023/01/NotToFriends_113_c_Richard_Termine_fiepbn.jpg){{% /md %}}

<figcaption>Theo Bleckmann (centre), and musicians (l-r): Kyoko Ogawa, Tomotaka Seki, Ayako Tahara, Ayano Kamimura; in note to a friend, Prototype Festival, 2023. Photo credit: © Richard Termine.</figcaption>  
</figure>

Lang is a prolific writer who has composed a number of other operas - and, like the poems of e.e. cummings, the titles are all in lowercase, such as the Pulitzer Prize-winning _the little match girl passion_. For _note to a friend_, he has written an hour of splendid chamber music (two violins, a viola and cello) to serve as counterpoint to a far-ranging solo male voice. The music is tuned viscerally at exactly the right moments to complement the text and vice-versa. The result is both cerebral and emotional. String-players Kyoko Ogawa, Tomotaka Seki, Ayako Tahara and Ayano Kamimura are perfection.

_note to a friend_, which was also presented by the Japan Society, is based on the life and stories of Ryunosuke Akutagawa (author of _Rashomon_.) The main character, (“the dead man”), the only one who sings in the piece, is loosely based on Akutagawa himself, who committed suicide in 1927. Akutagawa left a suicide note entitled "A Note to a Certain Old Friend," in which he explains that his death was not a hasty decision, but one that was given much consideration. The text of that one-page note is the text for much of the libretto.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1673656744/media/2023/01/NotToFriends_006_c_Richard_Termine_z02zo3.jpg){{% /md %}}

<figcaption>Theo Bleckmann and Cyrus Moshrefi in note to a friend, Prototype Festival, 2023. Photo credit: © Richard Termine.</figcaption>  
</figure>

The "friend" in the title is the first to appear on the stage. Some items fall off a table, as if pushed by an invisible force and soon "the dead man" (Theo Bleckmann) appears as a ghost. Through eight arias, the ghost recounts to his living friend the death of his mother, father and sister and how these events led to his obsession with the idea of dying himself. "The friend" remains silent but interacts at times and is clearly riveted (a difficult role, well-played by actor Cyrus Moshrefi.)

Recording artist Theo Bleckmann, (as the lone singer,) who has made records featuring his "vocal acrobatics" can hit the very low and very high notes. His voice has a soft, otherworldly quality (enhanced by some reverb.) This, along with the intensity of his performance and his almost-balletic movements serve the piece effectively. This, in spite of the fact that his instrument isn't quite up to the music here. Lang has written a number of beautiful, sustained notes and no doubt this will be sung one day by someone who doesn't "bend it like Bleckmann."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1673656771/media/2023/01/NotToFriends_043_c_Richard_Termine_ugwafx.jpg){{% /md %}}

<figcaption>(l-r) Cyrus Moshrefi and Theo Bleckmann in note to a friend, Prototype Festival, 2023. Photo credit: © Richard Termine.</figcaption>  
</figure>

Director Yoshi Oida's staging is ingeniously simple, especially in his use of props. For example, a dining chair slowly sliding under a table represents a family crypt. And three pieces of fruit, representing the deceased family members, are placed on a candelabra and, in turn, the fruit is replaced by candles which are blown out one by one. There is no choreographer listed so Oida must also be credited with the excellent use of movement.

Lang effectively uses a great deal of repetition in his libretto. When "the dead man" first appears he sings "people who kill themselves" over and over again, as if he's trying to form his own thoughts on the matter before continuing. His multiple variations of "my father, my mother, my sister, my mother, my sister, my father, etc…" show us that the ghost is himself haunted.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1673656804/media/2023/01/NotToFriends_108_c_Richard_Termine_jme72e.jpg){{% /md %}}

<figcaption>(l-r) Cyrus Moshrefi and Theo Bleckmann in note to a friend, Prototype Festival, 2023. Photo credit: © Richard Termine.</figcaption>  
</figure>

Lang's most touching moment is on the very last note. People who have attempted suicide on bridges have spoken of the feeling of immediate regret right after jumping. Though "the dead man" seems to be sure of his decision for most of the opera, he shows perhaps a moment of regret as the moment of death approaches and then arrives.  As the music soars to a final high note on the word "gone," Lang conveys the feeling that perhaps a life has been truly lost.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1673656833/media/2023/01/NotToFriends_136_c_Richard_Termine_iae0h7.jpg){{% /md %}}

<figcaption>(m-r) Cyrus Moshrefi and Theo Bleckmann in note to a friend, Prototype Festival, 2023. Photo credit: © Richard Termine.</figcaption>  
</figure>