+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-07-21T11:54:00-04:00"
lastmod = "2017-07-24T13:24:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1500852873622/2017-07-23---Women.jpg.jpg"
publishDate = "2017-07-24T13:08:00-04:00"
related_articles = ["articles/opera-culprits-women-with-low-selfesteem.md","articles/audition-season-or-the-annual-festival-of-shattered-dreams.md","articles/tamara-wilson-gives-a-flawless-aida-at-wno.md","articles/facts-leaps-taking-unnecessary-offence.md"]
short_description = "Certainly, if you look at opera&#039;s plots in a vacuum, perhaps you could find evidence of misogyny. But it would entirely miss the point of opera - art, really - to ignore the opinions of its composers and librettists."
slug = "no-opera-is-not-misogynist"
title = "No, opera is not misogynist"
+++

"How can I love an artform that is so consistently, insistently cruel to its female characters?" asked Charlotte Higgins in her article for *The Guardian*, ["Is opera the most misogynistic art form?"](https://www.theguardian.com/music/2016/feb/26/is-opera-the-most-misogynistic-art-form) 

It's easy to see what Higgins means if one looks at opera of the 18th and 19th centuries. The stories can be maddening, patriarchal laws and time periods making a true happy ending impossible for the women in *La traviata*, *Lucia di Lammermoor*, and *Le nozze di Figaro*. Even Carmen, who gives a stiff middle finger to rules and mores, gets her dues for being such an unapologetically free person. (That'll teach 'er!)

Yet the argument of opera's lady-hating leanings still seems to stick, even with new works. In her review of *Oksana G.*, the 2017 commission [Tapestry Opera](/scene/companies/tapestry-opera/) about a young Ukrainian woman who is sold into sexual slavery, [Lydia Perović wrote](https://definitelytheopera.wordpress.com/2017/05/30/oksana-g-is-shockingly-bad/),

"There’s a very old operatic trope that goes like this. The impure woman has to die at the end of an opera – either by her own hand, by a man's hand or due to an illness – as that is the only way we can feel for her. With no dramatic reason except this one, that we can finally be allowed to love and pity her, Oksana, finally free from her enslaver, commits suicide out of shame. What fresh Butterfly BS is this?"

Perović doesn't use the M-word, but she expresses the same frustrations that make it easy to point at opera and holler, "*misogyny yonder*!" Maybe it's because opera is often equivocated with that which is old, but associating the art form with woman-hating is common, maybe even easy. 

You might deem the stories un-feminist, fine; but is there nothing to be said for the people - men may they be - who create them? Violetta may have the shit end of stick when it comes to romantic and financial autonomy, but you can hear in his music that Verdi had respect for her person and sympathy for her plight; the same goes Donizetti's Lucia and Mozart's Countess. 

For their female characters, these composers wrote music that is heart-wrenching in its understanding of their storeis; the texts they set are written by librettists who also knew that these women had brains, hearts, and moral righteousness. Though their stories may be unjust to women, the authors of these operas do not cheer the injustice done to the heroines; they write "tragedy" on the front covers of these stories, and write mournful music for these characters' losses.

Certainly, if you look at opera's plots in a vacuum, perhaps you could find evidence of misogyny. But it would entirely miss the point of opera - art, really - to ignore the opinions of its composers and librettists. 

I was listening to a podcast the other day, and heard a story about a man whose new girlfriend was firmly against his watching HBO's *Game of Thrones*, because the series included a lot of violence against women. Setting aside the bizarre concept of forbidding one's partner from watching a TV show, the issue brings up an interesting point: when it comes to the arts, does misogyny lie more harmfully in the stories being told, or in the intent of the manpower (and womanpower) responsible for creating them? A more question must be asked: 

**If there's empathy involved in its creation, is opera still misogynist?**

If you'll indulge another TV example: Jenji Kohan. She's the brain behind shows like *Weeds*, *Orange is the New Black*, and the recently released *GLOW*. All of these shows have women writers, feature female leads, and the latter two have nearly all-female ensemble casts. But here's the catch: the fictional female characters deal with some serious life-garbage.

Nancy in *Weeds* is a widow who, in doing what she can to support her family, finds herself blackmailed and enslaved by her male bosses; Piper in *OITNB* is literally held captive in prison, but she's also paying serious dues for being naïve and ignorant about the consequences of her actions; the women in *GLOW* are trying to pay their bills and get their big acting breaks, in part by putting up with a skeezy coke- and sex-addicted boss in order to be a part of astaged women's wrestling show that many see as a live sex show.

No, Kohan's women don't have tuberculosis, nor are they forced into arranged marriages; but they are certainly held hostage in some way by men, or have tragic self-esteem issues that translate into self-harm. Still, even though the characters in her shows are full of flaws, Kohan certainly employs lots of women in the process of making them.

It's the same with the operas of Mozart and Donizetti and Verdi. Their works premiered in times of few professional options for women; undoubtedly, it was not lost on these composers that in the process of writing stage-stealing music for these female characters, they were created serious moments of artistry, recognition, and employment for the women who would sing the roles. Perhaps another question should be asked: 

**If its stories thrust female artists into well-deserved spotlight, is opera still misogynist?**

When you think about it, the question of opera's misogyny is really a question of placing what happens in fiction up against what happens in reality. In fiction, opera heroines are certainly mistreated, and their stories end unjustly; they don't have the power or education to stop others from making major decisions for them, and their stories end unsatisfactorily, to say the least. But in reality, composers and librettists understand how captive their female characters are - and women are employed (and lauded) in the process of telling their stories.

Opera is well-designed to make us feel strongly - does it do its job so well that we get wrapped up in its fiction, even to the point of calling it misogynist?
