+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2019-06-01T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1559066216/media/2019/05/kopernikus_30.jpg"
primary_image_credit = "Kopernikus, Americas Society/Music of the Americas, New York Opera Fest, 2019. Photo: Nicolas Manassi/Roey Yohai Studios for Americas Society."
related_articles = []
related_companies = []
related_people = []
short_description = "Opera composers who write their own libretti are rare and with good reason.  Musicians train in the land of notes and chords but structuring a good piece of theatre requires a different skill set. In the case of The Impossible She, presented by Rhymes with Opera (as part of the New York Opera Fest) composer Daniel Thomas Davis should have stuck with what he does best."
slug = "no-explanation-needed"
title = "No Explanation Needed"
youtube_url = ""

+++
Opera composers who write their own libretti are rare and with good reason.  Musicians train in the land of notes and chords but structuring a good piece of theatre requires a different skill set. In the case of _The Impossible She_, presented by Rhymes with Opera (as part of the New York Opera Fest) composer Daniel Thomas Davis should have stuck with what he does best.

_The Impossible She_ is yet another sexual-identity discovery story but it contains a bit of unknown history to some: the heroine is humanitarian and former First Lady Eleanor Roosevelt.  Eleanor (soprano Elisabeth Halliday) realizes that she is in love with a woman (journalist Lorena "Hick" Hickock, played by soprano Bonnie Lander) and the timing couldn't be worse – Mrs. Roosevelt's husband, FDR, has just been elected President of the United States. It's 1932 and a lesbian in the White House is something that would be beyond scandalous. And so, Eleanor and "Hick" have to hide their affair, and, are ultimately kept apart for fear of public condemnation.

>There is a love scene that follows which grows increasingly erotic, with the sex accompanied by sax.

Rhymes with Opera is dedicated to developing new works and that should always be considered a noble endeavor. Mr. Davis is a composer worth developing. He has an original voice in his use of strings, cello underscoring, saxophone lines, and chords that build to revelatory moments in the story. In addition, he has created some songs that are an evocative pastiche from the period. By the end of _The Impossible She_, however, the stage is littered with books and confetti and it's a bit of a mess, reflecting the structure of the work and the state of the direction.

The five short scenes that make up this historical episode cover about a year and a half. It all starts out promising, then things fall apart and get wrapped up far too abruptly. In Scene 1, we meet the two main characters before they actually meet each other. Mrs. Roosevelt is a yearning, sensitive soul who reads 18th century poetry. Hick is a reporter who wants to get an interview that won't be the kind of fluff you find on the "women's" pages of the newspaper. Baritone Robert Maril, as a fellow news reporter, tells us that Hick is considered "one of the guys" while at the same time harassing her. (It's still not easy for a woman to be in a profession dominated by men, but it was much worse some eighty-seven years ago.)

>Though the behemoth set piece is turned a couple of times to put it at different angles, no further stage space is gained.

In scene 2, the two women share their lives on a car trip along the Hudson River and discover that they have a lot in common, in spite of the fact that one has had a patrician childhood and the other the exact opposite.

In between these two scenes, a vintage radio is "turned on" and we hear the song "Ain't Got No Home Anymore", a spot-on tribute from Mr. Davis to Depression-era folk songs. The radio interlude is used again as a successful device between the next two scenes when we are treated to a jazzy nod to the blues, appropriately titled "Red Line Blues." Unfortunately, the next two interludes are song-free and are used to convey historical facts via announcer broadcasts. As the librettist, Mr. Davis lost his way. In fact, the last two scenes are more of a lecture rather than the interpersonal story that began the show, and it's all abruptly wrapped up in the final scene with a recitation of correspondence – always the least dramatic choice on stage.

The best scene is the third, in which the women go on a romantic picnic, and are ambushed by a bevy of curious press. There is a love scene that follows which grows increasingly erotic, with the sex accompanied by sax.

>Most great operas – and even good ones - need very little explanation.

Mr. Davis has intentionally placed his saxophone player (Zach Herchen) on the stage for the entire production to serve as a character in the action. According to the program notes, Mr. Herchen serves as the "Present Voice" while the love story is an exploration of the "past." We get to see Mr. Herchen play every version of the saxophone – soprano, alto, tenor and baritone – but his presence is a distraction and keeps us at a distance from the love story unfolding around him. Director Laine Rettmer makes things even worse by having Mr. Herchen move back and forth across the stage, fiddle with some props and even perform a set change.

Ms. Rettmer also puts up a literal roadblock to the action. With designer Andrea Merkx, she limits the principal movements of the performers to getting on and off of an enormous white wooden countertop that takes up most of the very small stage. While the countertop is a reasonable facsimile for a bed when the characters make love, when they stand on it, they're too close to the ceiling to be lit. Though the behemoth set piece is turned a couple of times to put it at different angles, no further stage space is gained. And if that isn't enough of an obstacle, Ms. Rettner starts the piece with books being strewn all over the floor and the singers spend the next hour and ten minutes stepping over and around them.

There is some evocative and effective video design. A large close-up of Mrs. Roosevelt's face is projected to give us a good look at her inner struggle. Newspaper print becomes part of the white costumes during the reading of newspaper stories. A "rear-view mirror" of passing images help create the road trip that the two women undertake.

Musically, there are some bad notes from sax and soprano alike. Part of it may be due to the unnecessary curtain raiser (_On Loneliness and Solitude_) from composer Colin Read who set three hard-to-follow poems to music which did not enhance or enlighten the words. Ms. Rettmer also directed this one and she gives the performers some lame movements, trying squeeze whatever staging can be found in the flowery 19th-century, and heavily symbolic 20th-century language of the poems. But the endeavor only succeeded in perhaps wearing out the voices of the same singers who then had to take on _The Impossible She_.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1559066162/media/2019/05/kopernikus_33.jpg){{% /md %}}

<figcaption>Kopernikus, Americas Society/Music of the Americas, New York Opera Fest, 2019. Photo: Nicolas Manassi/Roey Yohai Studios for Americas Society.</figcaption>  
</figure>

Most great operas – and even good ones - need very little explanation. The music and librettos speak for themselves. While it's true that you can often get further insights reading the notes written by the director or composer, the printed program will often reveal the wide gap between intent and execution. _Kopernikus_ (1979) is, according to program notes from composer Claude Vivier, "a meditation on various and poetic and cultural states…" with the lofty goal of making music a revolutionary force. So much for intentions, good or otherwise.

There's an audience for just about any opera genre but the potential audience for a work like _Kopernikus_ is quite small; perhaps no bigger than the very small (but appreciative) audience that attended the work's revival by Americas Society/Music of the Americas (as part of the NY Opera Fest.) Mr. Vivier was trained in "spectral music" which is concerned more with sound rather than pitch. It's essentially a "wall of noise" as the singers sing, screech, whistle, make animal sounds, etc., with a chamber ensemble underneath them that is going about its own "spectral" business.  Musically, it's a big game of "tag" where no one is "it."

One of the biggest of the big problems with this production is that someone (the deceased composer? Sebastian Zubieta, the music director?) has decided that the audience shouldn't look at the performers. Faced away from the singers and musicians, audience members had to twist around, uncomfortably, to see where all the noise was coming from. We were only allowed to look at a large wall with video projections. The wall – in a formerly elegant Moose Lodge in Brooklyn – was an impressive projection space, though the videos were far less than that. It was quite an endurance test to stare, for seventy minutes, at images from artist Sergio Policicchio that looked something like outer space or slowly exploding suns (or were they cells in mitosis?) Other repetitive images included the silhouette of trees, some X-rays and some geometric shapes.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1559066151/media/2019/05/kopernikus_13.jpg){{% /md %}}

<figcaption>Kopernikus, Americas Society/Music of the Americas, New York Opera Fest, 2019. Photo: Nicolas Manassi/Roey Yohai Studios for Americas Society.</figcaption>  
</figure>

The intent was clearly to force us to listen to the composer's sounds and think his "deep thoughts" without distraction. There is, however, a completely distracting "plot" to the whole thing with an occasional subtitle on the wall to hint at some kind of story.

_Kopernikus_ appears to be about a character named Agni who is facing death and is being guided to "infinity" and "dematerialization" by the ghosts of Copernicus, Lewis Carroll and Mozart, and even some fictional characters such as Mozart's "Queen of the Night" from _The Magic Flute_. The wizard Merlin also gets a number of lines and there is even a cameo from Tristan and his Isolde (but without any of the musical pleasures.) All these roles (and a few others) were sung (uttered?) by Meridonalis, a talented six-member vocal ensemble. It was clear that they were all highly trained singers. It's a high compliment to say that they never made you feel that this was a daunting or difficult score, though clearly it was. The same can be said for the musicianship of the seven-member International Contemporary Ensemble.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1559066138/media/2019/05/kopernikus_08.jpg){{% /md %}}

<figcaption>Kopernikus, Americas Society/Music of the Americas, New York Opera Fest, 2019. Photo: Nicolas Manassi/Roey Yohai Studios for Americas Society.</figcaption>  
</figure>

It's always a bad sign when the program notes are extremely dense or indecipherable. It's almost a sure thing that the work itself will suffer with the same maladies.