+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2014-09-09T15:00:00-04:00"
lastmod = "2015-04-27T18:00:00-04:00"
preamble = "This weekend Nightwood Theatre presents the [New Groundswell Festival](http://www.nightwoodtheatre.net/index.php/whats_on/groundswell_festival#tab1), presenting new works of theatre through workshop productions and a series of play readings. One of the pieces being workshopped is _Obeah Opera_, created by [Nicole Brooks](http://caribbeantales-events.com/?page_id=6419) and directed by [Weyni Mengesha](http://weynimengesha.com/) (_'Da Kink in my Hair_, _Raisin in the Sun_). Nicole is something of an artistic Renaissance woman, with credits as a filmmaker, playwright and director, and she'll appear in _Obeah Opera_ as Tituba. \"_Obeah Opera_ synthesizes the breadth of Black music into an unprecedented a capella theatrical epic. An all-female cast animates the story of the legendary Salem Witch Trials, from the unique perspective of enslaved African women.\" I asked Nicole about creating _Obeah Opera_, and using music to tell us a new story; she responded beautifully, and I'm looking forward to seeing it. Performances run September 11-14th in the Distillery District; for more details and ticket info, [click here](http://www.nightwoodtheatre.net/index.php/whats_on/groundswell_festival#tab2)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429212255394/Nicole%20Brooks.jpg.jpg"
publishDate = "2014-09-09T15:00:00-04:00"
related_articles = ["articles/in-review-obeah-opera.md","articles/dont-miss-anthropologies-imaginaires.md"]
related_people = ["scene/people/alison-wong.md"]
short_description = "This weekend Nightwood Theatre presents the New Groundswell Festival, presenting new works of theatre through workshop productions and a series of play readings. One of the pieces being workshopped is Obeah Opera, created by Nicole Brooks and directed by Weyni Mengesha (&#039;Da Kink in my Hair, Raisin in the Sun). Nicole is something of an artistic Renaissance woman, with credits as a filmmaker, playwright and director, and she&#039;ll appear in Obeah Opera as Tituba. "
slug = "nicole-brooks-on-obeah-opera"
title = "Nicole Brooks on Obeah Opera"
+++

### What can people expect from an "a cappella theatrical epic"?

This is a hard production to categorize and I myself am coming to grips with this work being labeled as an 'a cappella theatrical epic.' But I will work with this definition and break it down as best as possible. It is a cappella in that it is fully sung without any external assistance from instruments or recordings. It is theatrical in that we are aiming toward a full narrative with a strong beginning, middle and end. We are using the tools and conventions of theatre in production to help convey the story. It is epic for its subject matter (the Salem witch trials), its scope (it looks at the source history that is not typically shared in Salem's history including slavery and traditional African spirituality) and the mere logistics (20 women on stage, 30 plus songs in this workshop production)!

### What do you think is unique about the workshop process of this piece?

Everything about this process is unique. We have the many moving variables of music and narration. As a composer who does not have formal music training, my method to create the music is to record all part of the composition vocally with a microphone and music software. It is then given to Music Director Andrew Craig, whose task is to digest the material and then map the music onto the performers’ bodies. Most of our performers don't read music. We have actors in the cast who can also sing and we have singers who can also act - an amazing combination. This is quite a huge challenge for Andrew to work with. To top off that, many of the production crew are wearing many hats: Andrew is also a producer; I'm the librettist, composer, performer and producer etc.). We found throughout this process that if we need to solve something for the overall story, it has to go through the musical sieve, where we will then see that it needs to be readjusted for libretto and musicality, and THEN it goes to the performers and from there needs to be readjusted again. The work is very specific and detailed and challenging at times, but when something clicks, we are all reminded of the necessity of this project. 
### What makes Obeah Opera a play that adapts well to a musical setting?

One of the unique aspects of this piece musically is that it's sourced from many different genres of contemporary and traditional music. This goes a long way in creating atmosphere and aesthetic short cuts for the audience. When we hear a tango, we know there is tension. When we hear a ballad we know a character is emoting. The witch trials themselves were horrific and terrible and a shameful part of history. But in hindsight, there was also unique sociological occurrences that are implemented in this play: the introspection and 'analysis' of slavery, women’s injustice, mass hysteria; mingling of traditional and contemporary spiritualism; revolutionary activities by girls and adolescences. These themes are big and require a big production to do them justice; exploring them musically not only makes sense but aids in telling a story that carries such density. 

### What is special about this account of the Salem Witch Trials?

When people think of the Salem witch trials, they think of the story of white women. Arthur Miller first popularized Tituba in [The Crucible](http://en.wikipedia.org/wiki/The_Crucible) but this version centralizes the narrative of the black slaves who through the faults of historical recording were never given the opportunity for their story to be shared. 

### Can you tell us about your process of creating _Obeah Opera_, and adapting it to include music?

My process in creating this work has been a huge learning curve on how I create. As stated earlier, I have no previous institutional musical training though I do have a background conducting choirs and being a performer. All of these skills were honed by ear and 'practice'. My process is unconventional by many means. I learned depending on 'the moment' that I was working on in this work, which came to me in a variety of ways. I may hear the music first or I may form the libretto first and then add music -- there is no set way the work came to me.
When Andrew Craig came on board as MD in this process, I explained to him my current process (which wasn't very efficient and I had become frustrated because I didn't know how to share what was in my head). He provided me with the equipment needed and instructed me to sing everything I had in my head so that he could facilitate bringing the music to not only the performers but to the audience. He assured me that I wasn't 'mad' and gave me the necessary tools to bring out the work. I am forever indebted to him for this incredible gift.

That is the musical process as best as I can describe it.

But I am also inclined to talk about the book and librettist process, where another incredible gift was given. As an emerging playwright, I had spent many years piecing together moments that I was convinced had to be in the play. When Nightwood Theatre stepped in, they gave me an amazing dramaturg (Erica Kopyto) and full assistance in the developmental stage to create a strong narrative. This is not necessarily something that is found in conventional opera, but there was a need to honour and tell the story of Tituba and these women in a full and rich way.

The combination of these gifts shows me that there is indeed a two-step process when creating a new work: creating the music versus looking at the narrative and deciding how the music and genre best serve those moments.

### What do you see as the next steps for this piece after this current workshop?

The road thus far is pretty set. We present 5 shows as part of this workshop presenting excerpts from the fully developed work in Nightwood's New Groundswell Festival. From there I'm told I get a 12 hour break before we begin responding to all of the feedback from the process. We'll need to adjust songs/libretto and look at scenes and characterization to finesse everything we have learned in the last 3 weeks of rehearsal. Which I might add has been intense! This workshop is a tool to get us to the final stage of development so that the script and music are ready as we move toward the final production set for July 2015 during PANAMANIA, the arts and culture program of the Toronto 2015 Pan Am and Parapan Am Games .

Catch the shows this weekend, September 11-14th. Tickets and more details [here](http://www.nightwoodtheatre.net/index.php/whats_on/groundswell_festival#tab2).
