+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-09-28T14:16:00+01:00"
lastmod = "2016-09-29T11:00:00+01:00"
preamble = "Nick Fletcher is a London-based conductor and répétiteur, and currently a member of the [Royal Opera](/scene/companies/royal-opera-house/)'s Jette Parker Young Artists Programme. As part of [Meet the Young Artists Week](http://www.roh.org.uk/about/jette-parker-young-artists-programme/events/meet-the-young-artists-week), he'll be joining the JPYAP singers for workshops and concert events, including [Juke Box](http://www.roh.org.uk/productions/meet-the-young-artists-week-juke-box-by-jette-parker-young-artists) on October 9 at St. Clement Danes Anglican Church.\n\nWe spoke with Fletcher about the role of the répétiteur in young artist programmes, and what a day in the life looks like for him at the Royal Opera House."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1475068776193/2016-09-28---Fletcher-Nick.jpg.jpg"
primary_image_credit = "Photo courtesy of ROH."
publishDate = "2016-09-29T11:00:00+01:00"
related_articles = ["articles/opera-for-lunch-the-roh-young-artists-in-concert.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/nick-fletcher.md"]
short_description = "&quot;It&#039;s taken me a long time to realise that as a rep you&#039;re not just a piano player meekly sitting in the corner, but instead a wide-ranging and versatile musician whose ideas, even if ultimately rejected, should still be part of the creative process that happens in the rehearsal room.&quot;"
slug = "nick-fletcher-reps-at-the-roh"
title = "Nick Fletcher: reps at the ROH"
+++

## Can you describe a day in the life as part of the Jette Parker Young Artists Programme?

Every day is different! I try and get in about 9-9:30am, to give myself some time to warm up and do a bit of practice. Then after that there are a whole host of things I may be doing! I could be coaching singers, playing for language coachings or stagecraft sessions, or getting coaching myself to work on upcoming repertory, to work on my languages or even getting Alexander technique sessions.

If I'm working on a specific production I tend to be working solely on that project, but again I could be playing for rehearsals, coaching singers or playing for dance sessions. Add to that occasionally playing keyboard instruments in the orchestra or conducting backstage... it is rarely boring!

If I don't have a rehearsal or performance in the evening I tend to be either practising, or at least doing something useful like writing in translations, or looking through full scores and writing aspects of the orchestration into my vocal score. There's always something coming up that needs attention. 

## What are the ways that young répétiteurs and conductors can gain work experience? What sort of role do YAPs play in their training? 

As a répétiteur (rep), when I came to London to go to music college, what really helped me get experience was the smaller-scale opera scene, working on productions with smaller companies, often only accompanied by piano. It gave me a sense of how the opera rehearsal process works, what the role of the conductor should be, and similarly what the role of a rep should be. 

It's taken me a long time to realise that as a rep you're not just a piano player meekly sitting in the corner, but instead a wide-ranging and versatile musician whose ideas, even if ultimately rejected, should still be part of the creative process that happens in the rehearsal room. It took me even longer to put that into action (I'm still trying!) and working on these smaller scale productions give you a good environment to start having ideas and opinions.

I believe opera scenes have a role to play in our educational process; they're great at getting to grips with areas of the repertory. But ultimately they only get you so far as a rep, as the challenge is always playing a large volume of music consistently well having had little time to practice it. Once you have 7+ operas in a year in your diary (I once got told at a job interview for a German house that I would be involved in 15 operas the next season if I got the job!), that experience building up a body of repertory really pays off.

As someone who is on my third young artist programme - having done a year at the National Opera Studio, then been the trainee rep at [English National Opera](/scene/companies/english-national-opera/) and now on the JPYAP - I've found them to be a great way of working upwards and breaking into the professional ranks. 

There is a lack of work out there, especially with regard to full time rep positions, and it takes time to develop enough work to be self-sufficient as a freelance rep, so these young artist positions are an invaluable way of making new contacts and showing your skills to the professional companies. Most importantly, they give you experience working at the very top level of our profession, but with the support and guidance to help you get through any problems you may have and fundamentally to continue to develop as an artist. 

Also I think it's helpful to realise that being a rep is to be at the centre of a Venn diagram of differing skills and abilities. Yes, we are pianists, but we're also conductors, coaches, chorus masters and continuo players. Any experience that helps with any of these is useful. To name a few examples, playing for choir rehearsals is great for getting used to following a conductor; playing a song recital can help you brush up on languages and working with singers, playing for singing lessons will help you gain an understanding of vocal technique, playing a string instrument (or a wind instrument if you're a string player) will help you understand more about the orchestra, and so on and so forth. All of these experiences help in developing the differing skills that are required of us. 
 
## What do you find unique about making music with singers?

I sang as a child, first in the local church choir and then in the choir of Southwell Minster, so singing was my life from ages 6-14. Although once my voice broke, I didn't go back to singing seriously, I think I've been drawn to working with singers ever since. 

One of the main reasons I like working with singers is the interplay between text and music. It causes so many layers, there are endless paths to go down, and whether I'm a conductor, repetiteur or an accompanist, it's always exciting to be a part of that artistic process.

## Are there any specific highlights of this season that you look forward to?

Basically everything I'm involved in this year is a highlight for me in one way or another! Once [Meet the Young Artists Week](http://www.roh.org.uk/about/jette-parker-young-artists-programme/events/meet-the-young-artists-week) is over, we go straight into production for *Oreste*, which will be my first Handel opera, and means a lot of harpsichord playing, which is always exciting! 

Then I go into working on *Written on Skin*. It's quite daunting, though I'm getting through it, slowly! But it's such an honour to be working on an opera I love, and which is probably the greatest opera written this century. And I'm quite looking forward to playing harmonium in *Der Rosenkavalier*, as it means I can sit in the pit and watch Nelsons conduct it night after night. That's going to be a great experience. That doesn't even take me past January, I think it's going to be a great year! 
