+++
author = ["authors/michael-calderone.md"]
categories = "Review"
date = "2018-01-24T20:11:00-05:00"
lastmod = "2018-01-26T20:11:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516841879592/sq---32546229403_47f4d8e53c_o.jpg.jpg"
primary_image_credit = "Photo: Jan Versweyveld."
publishDate = "2018-01-25T18:03:00-05:00"
related_articles = ["articles/in-review-death-desire.md"]
short_description = "The singers gave gripping and intensely theatrical performances. Yet the atmosphere created was meditative, as their judicious movements possessed calm and reserve. The singing was nuanced, if at times a bit uneven. In the tenor Peter Gijsbertsen&#039;s highest register, some passages sounded tense and forced, but these were also the moments of most impassioned emotional intensity."
slug = "newly-staged-the-diary-of-one-who-disappeared"
title = "Newly staged: The Diary of One Who Disappeared"
+++

In a new staging of *The Diary of the One Who Vanished*, the Belgian director Ivo van Hove adds rich new layers of meaning to Janáček's song cycle. Presented at Grand Théâtre de Luxembourg on January 4 and 5, 2018, the production inserted new music from the Belgian composer Annelies van Parys and recitations of Janáček's letters to his young muse Kamila Stösslová into to the body of Janáček's 22-movement song cycle. 

Leoš Janáček met Kamila Stösslová in the Moravian resort town Luhačovice in 1917 and became quickly infatuated with her, despite both of them already being married. Janáček wrote Stösslová hundreds of letters (available translated and annotated by the Janáček scholar John Tyrrell in his splendid 1994 volume *Intimate Letters*), to which she only occasionally replied. Janáček's love and devotion went unrequited, yet he exclaims that much of his late music - including the heroines of *Katya Kabanová*, *The Cunning Little Vixen*, *The Makropulos Affair*, the String Quartet No. 2 (*Intimate Letters*), and also *The Diary of One Who Vanished* - were all inspired by her.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516842431835/33282164275_0e62535099_o.jpg.jpg)
<figcaption>Photo: Jan Versweyveld.</figcaption>
</figure>

The text Janáček set in *Diary* is a collection of anonymous poetry, published in 1916 in the daily newspaper "Lidové Noviny." In it the narrator, a young man named Janíček, meets a Gypsy woman (Zefka) and falls madly in love. He abandons his family to pursue her, to accompany her on her travels in the countryside, and to begin a family together. It is plausible to imagine Janáček identifying with the Janíček in *Diary*, and wishing to follow his example: this impassioned man (whose name is just one letter off from his own) channeled his desire into action, yet is fated to alienated himself from his family in the process.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516842447733/33282167325_d579ba0f1e_o.jpg.jpg)
<figcaption>Photo: Jan Versweyveld.</figcaption>
</figure>

Mr. van Hove and the dramaturg Krystian Lada explore this likely identification between Janáček and Janíček. The actor Hugo Koolschijn recited excerpts of Janáček's letters to Stösslová in English, personifying the composer’s personal perspective. Koolschijn was dressed in an identical crisp blue dress shirt and slacks to the tenor playing Janíček (Peter Gijsbertsen), creating a visual link. The placement of these recitations in the performance parallels the dramatic content of the music. In the final line of the work, peaking on a powerful sustained high C, Janíček sings, "Zefka waits for me, in her arms is my son." The tenor exits, and the last thing we see is Koolschijn reciting one of Janáček's final letters, in which he explains his last will and testament leaving the rights of his music to Kamila. He expresses his longing for her to bear his children, while dropping freshly lit letters into a wastebasket (Janáček burned many of Kamila's letters, at her request.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516842456444/33240974436_44bc8f050e_o.jpg.jpg)
<figcaption>Photo: Jan Versweyveld.</figcaption>
</figure>

Ms. van Parys's music also uses the letters as inspiration for her first composition in the production, and to link Janáček and *Diary*. At the top of the show, the mezzo-soprano Marie Hamard, who plays Zefka, entered through a door in the back wall of the set, calmly hung up her tan trenchcoat, put a pot of coffee on, and slowly walked towards the piano on stage. She turned on a reel-to-reel tape player, which played back a recitation of one of Janáček's letters in which he tries via post to teach Kamila a folk song, and sat at the piano, working out the recorded instructions. Ms. van Parys says she sought to arrange this song in a the style of Janáček, which certainly came across. The remaining texts were folk song texts in Roma, an Eastern European language that Ms. van Parys set to floating, ethereal music. Her writing gives voice to the Zefka, and allows us to stew in her emotional evolution in addition to Janíček's. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516842472939/32517358934_edaac0cdfd_o.jpg.jpg)
<figcaption>Photo: Jan Versweyveld.</figcaption>
</figure>

The singers gave gripping and intensely theatrical performances. Yet the atmosphere created was meditative, as their judicious movements possessed calm and reserve. The singing was nuanced, if at times a bit uneven. In the tenor Peter Gijsbertsen's highest register, some passages sounded tense and forced, but these were also the moments of most impassioned emotional intensity. I did not mind the slight hardness in the sound, because it heightened the dramatic effect of Janíček's predicament. The pianist Lada Valešová provided consistently powerful, rhythmic, and sensitive playing - ideal for Janáček's repetitive, proto-minimalist compositional cells and angular melodic lines.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516842513122/32517335964_9ae89cb132_o.jpg.jpg)
<figcaption>Photo: Jan Versweyveld.</figcaption>
</figure>

Notable also was the palpable sexual chemistry between Gijsbertsen and Hamard. They writhed on the floor, culminating in Hamard straddling Gijsbertsen. They groped each other, and Hamard undressed him with her teeth. There is a explicit sexuality embedded in the work: Zefka sings, "Will you let me show you how Gypsy people sleep?", a solo piano interlude at the piece's midpoint subtitled is "Intermezzo erotico," and Janicek sings of Zefka’s "white, white, white" thighs while she is birthing his child. Mr. van Hove's staging makes the narrator's (and Janáček's) intense desire clear. 

These performances occurred in the Studio Theater, a 400-seat black box venue at the Grand Théâtre de Luxembourg. Jan Versweyveld's set had various stations, all fashioned in mid-century modern furniture: on stage left there was a table with photo developing trays, and a kitchenette in the back corner. Towards center stage were several worktables, cluttered with messy stacks of photos, dossiers, and books. The piano too became part of the set, as it was camouflaged with a reel-to-reel player and a small bookshelf. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516842532048/33205043042_4412f2c2ae_o.jpg.jpg)
<figcaption>Photo: Jan Versweyveld.</figcaption>
</figure>

Mr. Versweyveld's lighting design created a wealth of striking images within this mysterious, quasi-home office set. The walls and ceiling were perforated with a regular pattern of oval-shaped holes, which when backlit filled the set with streams of filtered golden light. When the tenor and actor were pouring over photos of Zefka on the worktable at the center of the set, the stark and sickly fluorescent light overhead illuminated their frantic fumbling. Eventually the men chose a photo to print, and they rushed to the stage right wall of the set, where they got to work dipping the print into developing trays. In an instant, intensely bright red light saturated the entire set - for a moment it was hard to imagine the set being anything other than this deep and throbbing red. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516842542032/32517349064_95a63403e1_o.jpg.jpg)
<figcaption>Photo: Jan Versweyveld.</figcaption>
</figure>

In all, the sophisticated components inserted into Mr. van Hove's production bring additional depth and interest to some of Janáček's most hauntingly beautiful music. 

Leoš Janáček's *Le journal d’un disparu* (*The Diary of the One Who Vanished*) is a production by Muziektheater Transparant, and was co-produced by Toneelgroep Amsterdam, Klarafestival, De Munt/La Monnaie, Kaaitheater, Les Théâtres de la Ville de Luxembourg, Opera Days Rotterdam and Beijing Music Festival. Future performances are planned at the Opéra de Lyon (February 8-11, 2018), Théâtre de Cornouaille, Quimper (March 13, 2018), and Scène do Golfe, Vannes (March 16, 2018).
