+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-07-13T11:24:00-04:00"
lastmod = "2016-07-19T10:29:00-04:00"
preamble = "We first met Montréal-based tenor [Pasquale d'Alessio](/scene/people/pasquale-dalessio/) at The Banff Centre in 2015, singing in *Crush*, a new opera by James Rolfe and Anna Chatterton. D'Alessio keeps busy as a singer, including an upcoming performance of the title role in *Faust* at Highlands Opera Studio in August, 2016. Offstage, he's a composer, and he's currently working on a new opera, *The Imaginings*. We asked d'Alessio about writing for singers, and combining fantasy with opera. \n\nYou can hear a sample of *The Imaginings* on [Soundcloud](https://soundcloud.com/modernfugues/the-imaginins-demosections)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1468424654892/2016-07-13---Pasquale-Dalessio.jpg.jpg"
publishDate = "2016-07-16T00:11:00-04:00"
related_articles = ["articles/michael-christie-new-opera-that-the-box-office-loves.md","articles/elitism-irony-and-the-phantom-of-the-opera.md"]
related_companies = ["scene/companies/stujess-productions.md"]
related_people = ["scene/people/pasquale-dalessio.md"]
short_description = "&quot;I&#039;ve been wanting to write an opera ever since I watched Amadeus. There has always been lingering ideas in my mind for a libretto. Using the paintings as characters came initially from Stu &amp; Jess productions commissioning me to adapt several poems into a song cycle based on classic paintings (Mona Lisa, Napoleon etc.); the initial poems had a humorous tone and sparked an idea.&quot;"
slug = "new-works-the-imaginings"
title = "New works: The Imaginings"
+++

## Where did the idea for the story of *The Imaginings* come from?

I've been wanting to write an opera ever since I watched *Amadeus*. There has always been lingering ideas in my mind for a libretto. Using the paintings as characters came initially from [Stu & Jess Productions](/scene/companies/stujess-productions/) commissioning me to adapt several poems into a song cycle based on classic paintings (Mona Lisa, Napoleon etc.); the initial poems had a humorous tone and sparked an idea. 

I then wanted to adapt a libretto around it because I felt it would be better as a short comic opera. The idea basically morphed into *A Night at The Museum*. I was unsatisfied with it - it felt to unoriginal and not exactly the scale I wanted. The next push of inspirations sent me down a fantastical/comical path (operas are so serious nowadays), inspired by *Alice in Wonderland*, *Peter Pan*, *A Midsummer Night's Dream*, and *Harry Potter*. I thought instead of the painting coming to life, why doesn't someone get pulled into the paintings and discover a whole world - like Alice? And let's make the main character a kid and call him Max. 

This way I was able to play on the heroes journey, mystical elements and explore Napoleons battlefield, and a Bacchanalian feast in Athens all in one opera. Suddenly everything started to make sense - it just felt right and no one had really done something like this in opera in a long time  - or maybe I'm just watching too much Game of Thrones. Another thing about the idea was I wanted it to be original and larger than life. Why isn't opera as successful as musical theatre? they are so similar in a sense, where did the 20th century go wrong when Disney would rather take *Into the Woods*, or *Sweeney Todd* - why haven't we written things like that in our own aesthetics? 

## How have you chosen to depict all the historical characters (and paintings) with your music?

There is an mystical undertone that permeates the whole opera from the opening Prelude, as to make us feel we are "somewhere else" (à la *Midsummer* cello glissandi); as for the characters themselves, I went with what I thought fit their individual persona. 

Napoleon is a strong/silent general-type you would find in a *bel canto* opera - so his music is in that vein - with a few necessary quotes from Beethoven. Mona Lisa is diva-esque - so she has a Bersteinian feel with a sort of Puccini romanticism. Bacchus is basically a bumbling drunk Falstaff - there are other aspects of the music that don't really seem to fall into any category but are more of an amalgamation of my musical experience and history. 

It was important for me to imagine being the character on stage, how would he/she move, think, and act? - what motivates them? Characters seem to come to life by virtue of how much you talk about them - Mitch Findlay (my partner in the libretto writing) and I would just discuss for hours about who this person was, what do they want? How would that make the plot unfold?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1468424901808/2016-07-13---The-Scream.jpg.jpg)
<figcaption>The Scream. Illustration by Cynthia Magri.</figcaption>
</figure>

## How much does your work as a singer inform how you write for the voice? What qualities do you look for in contemporary opera?

My work as a singer is probably the most important part of all of this whole process - I'd say even more than any studies I did in composition. To have that "feel" of being on stage and knowing intimitely how characters interact. Having performed in so many operas really informs decisions like like range, vowel placement through passaggio, musical pace, melody, orchestration, and what is possible and not on stage (although a director will like to stretch that line ;)).

I also feel that all my work with coaches, conductors, and directors has helped me develop what is expected from a great work to be able to work and have fun with it. Also, after doing Opera for so many years you begin to think in "operatic" terms - and ideas just come from some sort of "stored memory". I find it extremely important that the singer enjoy singing the part - it seems silly, but all too often singers don't actually enjoy singing very new contemporary music - and they are not wrong. 

We live in an extremely eclectic musical world, so this is not true for every modern opera - but there is always a challenge - a challenge of comprehension of the language being used, a challenge in understanding and singing the music. I'm not a fan of this. If I look at when I did contemporary operas like *Turn of the Screw*, *Midsummer*, and *Rake's Progress*, there is absolutely a challenge at first, but there is also a sense of incredible underlying technique and logic that brings each part together - it doesn't wander and it certainly is not random. 

So as a singer, I would say that the quality I look for the most is basically something worth singing. Another quality is "does the music move under me?"...all too often, in new operas the music doesn't move beneath the singer the way it does in Verdi, Puccini or Mozart, which I find paramount because it informs the movement on stage.  

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1468424885254/2016-07-13---Napoleon.jpg.jpg)
<figcaption>Napoleon. Illustration by Cynthia Magri.</figcaption>
</figure>

## What are your own thoughts on the musical aesthetic of new opera? What sort of musical language best suits you and this story?

I think the best musical language is your personal version of tonality. To echo Bernstein's words "I believe in music that is rooted in Earth...as long as spring succeeds winter and man is there to perceive it". I think it's important to not let the intellect get in the way of the Earth in the music, but only to use it when necessary. 

Music is mainly about connection between work, spirit, performer and audience, and in order to achieve that it is beyond a compositional technique. It is an amalgamation of all music and culture. The virtue of "being different" in classical music has had an opposite effect in the 20th century. We are a counter-culture driven niche art form when it comes to composing, and it's what I love about it, however, what are you countering if every body is countering the same thing the same way? You have to counter the counter culture. 

This is why I stepped back a bit into tonality and more straightforward forms, and singable melodies. You will hear a fugue, an aria, a bassoon melody and it will dip into things that are a bit more unorthodox - but it has to be relatable to the audience. The anxiety of influence modern composers feel to be greatly original is a condition we should get rid of. Why not copy or write in the style of Beethoven, Debussy, or Chopin? If not only to study and learn their method. You have to study and imitate great masters of the past to create something new. 

Think of Stravinsky, Britten, Mahler - they all have hints of older styles and techniques in them - should Beethoven and Mozart have given up on the fugue because they were overshadowed by Bach's unbelievable technique before them? The 20th century rejection of the past seems silly to me, especially given that the most works performed are still from 19th and 18th century music.

There is no sense of true originality, but only the adaptation of the old into the new this is a huge part of my aesthetic and what I chase. There are too many rules in this industry on what is acceptable and not - this kills creativity, I think. There is no comment that makes me shudder more than "it's too tonal" - what does that even mean? Is there some standard by which tonality should be balanced with a-tonality or pan tonality? Is that not my choice as a composer? And should everyone adhere to that standard. 

I think, it jumps out on a score when a composer has tried to be different only for difference sake - so I try to avoid that. Being [involved in indie rock](https://videoman.bandcamp.com/) has really effected my aesthetic in opera and classical writing in the sense that anything should be possible, and what role does your audience play in what you write. Indie has a very f\*\*\* you attitude - which I think is something more and more composers and classical artists should adopt. Indie and pop work a lot with feel and we work with technique - we need a mix of both. 

Oh yeah, and another thing: HAVE FUN!! Music writing is fun, performing is fun, expressing is fun - it should translate into your work. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1468424868409/2016-07-13---Old-Curator.jpg.jpg)
<figcaption>The Old Curator. Illustration by Cynthia Magri.</figcaption>
</figure>

## What kind of audiences/venues do you envision for *The Imaginings*? How far along in the workshop process are you at the moment?

In terms of venues the opera is adaptable to any kind - it can be big and small. The one thing I think would be great is to make it a complete immersive experience, and in some way utilize VR technology, as if the audience steps into the world Max falls into. The audience I suppose would be theatre and music lovers, and a more general one that enjoys epic fantasy. 

I kind of want to make a "blockbuster" opera. I often think what would an opera be like if Peter Jackson wrote it, or Christopher Nolan? How would they pace it and plot it - what devices do they use to make a plot coherent. Of course opera has music, but if you think of films like *Chicago*, *Sweeney Todd*, and *Into the Woods* - they have that feel and aesthetic. Opera should too. We can learn a lot from movie. 

I have not began to workshop the opera in full yet because it's not finished - I just finished Act I. I have however performed Mona Lisa's aria with Magali Simard-Galdes at the Opera America conference through l'Opéra de Montréal, where the opera received interest from several companies. I hope to have it workshopped this coming year. 
