+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-06-28T02:21:00+01:00"
lastmod = "2016-06-30T21:43:00+01:00"
preamble = "The [Boston University Tanglewood Institute](http://www.bu.edu/cfa/tanglewood/) has launched its new [Young Artists Opera Intensive](http://www.bu.edu/cfa/tanglewood/program/yaoi/), a two-week programme for young singers aged 18-22 who have completed their first year of undergraduate studies. Running from June 19-July 2, participants will have the chance to perform a mainstage role, receive coachings, and try out their repertoire in mock auditions, and learn entrepreneurial skills like networking and curating marketing materials.\n\nWe spoke with Program Director Dana Lynne Varga, and stage director Sarah Meyers, about the mission of this new program, and why *Die Fledermaus* is a great choice for the YAOI's introductory summer."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1467077197619/BUTI-Ensemble.jpg.jpg"
primary_image_credit = "Photo: Dana Lynne Varga"
publishDate = "2016-06-29T15:06:00+01:00"
related_articles = ["articles/how-to-make-the-most-of-your-summer-program.md","articles/all-about-the-tafelmusik-baroque-summer-institute.md"]
short_description = "&quot;The main goal is to give these promising artists a taste of what a professional career in opera is like. They are held to very high expectations; each of them is assigned a full role and they must arrive with it 100% memorized. They are expected to be well prepared and eager to learn, show that they are team players, and act in a professional manner throughout the program.&quot;"
slug = "new-programs-opera-at-tanglewood"
title = "New programs: Opera at Tanglewood"
+++

## Who is this new opera workshop for, and what are the goals for the two-week period?

**Dana Lynne Varga**: The new BU Tanglewood Institute Young Artist Opera Intensive is specifically meant for undergraduate singers ages 18-22 that show great promise for a career in opera. In two weeks we prepare a fully staged, lit, costumed opera and perform it twice (once per cast, as we are double cast). Singers have daily coachings, dialogue work and rehearsals. We also hold six master classes over the course of two weeks, bringing in established coaches, singers, artistic directors and actors to work with the singers on both their own repertoire and repertoire from our show.

## What are the priorities for training this age group of participants?

**Varga**: The main goal is to give these promising artists a taste of what a professional career in opera is like. They are held to very high expectations; each of them is assigned a full role and they must arrive with it 100% memorized. They are expected to be well prepared and eager to learn, show that they are team players, and act in a professional manner throughout the program. Since the hours can be grueling, they are also expected to take care to use their voices wisely, hydrate, get adequate sleep and resist the urge to party. In return, they gain invaluable experience and grow as singing actors with the help of our accomplished faculty and guest artists.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1467077350304/2016-06-27---Dana-Lynne-Varga.jpg.jpg)
<figcaption>Dana Lynne Varga, Program Director BU Tanglewood Institute Young Artists Opera Intensive.</figcaption>
</figure>

## Why choose *Die Fledermaus* for the program's inaugural summer?

**Sarah Meyers**: When I first spoke to Dana Varga about doing *Die Fledermaus* with the Young Artist Opera Intensive, I was excited by the thought of young singers doing this opera in English. For artists who are truly at the beginning of their career, it can be enlightening and empowering to do an opera in their own language. It allows them to focus on some of the most basic skills - how to connect with the text, how to be present and in the moment, how to listen to their colleagues on-stage - without having to  constantly translate in their heads from a foreign language. I decided I wanted to take it one step further -- to give them the experience of an opera not only in their own language, but actually in their own world. I updated the opera to the here and now, allowing each cast member to work from a familiar frame of reference. This required creating an entirely new translation/adaptation of the original opera. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1467077423430/2016-06-27---Sarah-Meyers.jpg.jpg)
<figcaption>Sarah Meyers, Stage Director, BU Tanglewood Institute Young Artists Opera Intensive.</figcaption>
</figure>

**Varga**: This delightful operetta is not too long and has a great balance of female and male roles, many of which are well suited to young voices. A few of the leading roles require a more experienced, technically developed singer. Fortunately for us, we had an impressive pool of applicants from which to choose, and were able to find older, more seasoned undergraduates for some of the tougher roles. Our stage director Sarah Meyers created a brand new, modern English translation for both the music and the dialogue of the entire piece that really allows the opera to shine.

**Meyers**: In creating this adaptation, I discovered that - with a few adjustments - the story itself translates rather well to a contemporary setting. The most important theme in the original is the tension between public and private - how our private lives conflict with our public personas. How do you stay true to someone else - to yourself? To me, these questions are more important than ever in our technology-infused, internet-obsessed, unreal reality TV world. Our young artists are all too familiar with exactly these issues, and they are enjoying tackling them head on. I am delighted to see how they have taken ownership of their roles and of this production. It is my hope that from our work together, they discover they can feel the same degree of investment in every opera/role they approach in the future. 

>The Young Artist Opera Intensive presents Die Fledermaus, July 1 at 7:30pm & July 2 at 2:30pm, at the West Street Theatre, 45 West Street, Lenox, MA. Admission is free! [Click here](http://www.bu.edu/cfa/tanglewood/performance_calendar/) for BUTI's full performance schedule.
