+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-08-25T19:56:00+01:00"
lastmod = "2016-08-29T13:03:00+01:00"
preamble = "[Arizona Opera](/scene/companies/arizona-opera/) is commissioning its first world premiere, Craig Bohmler's [*Riders of the Purple Sage*](http://www.azopera.org/performances/riders-purple-sage/), running in Tucson and Phoenix in February and March of 2017. The libretto by Steven Mark Kohn is based on the Western novel by Zane Grey, which tells the story of Jane Withersteen, a devout Mormon who grows increasingly at odds with the expectations of her church, and Lassiter, a rugged cowboy set on revenge.\n\nA true Western opera, the vast Southwestern landscape of *Riders of the Purple Sage* is created in the scenic design by [Arizona-based artist, Ed Mell](https://youtu.be/8UwlwjYXXlc). Fenlon Lamb directs the premiere production, and Keitaro Harada conducts.\n\nWe spoke with Craig Bohmler about his new opera, setting Grey's story to music, and about creating a world of sound for the American Southwest.\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1472156734364/2016-08-27---PipeSpring_CraigBohmler.jpg.jpg"
primary_image_credit = "Photo by Craig Bohmler."
publishDate = "2016-08-29T12:50:00+01:00"
related_articles = ["articles/brian-mulligan-singing-jack-torrance.md","articles/michael-christie-new-opera-that-the-box-office-loves.md","articles/in-review-rocking-horse-winner.md","articles/riders-of-the-purple-sage-meet-lassiter.md","articles/susannah-is-the-great-original-american-opera.md"]
related_companies = ["scene/companies/arizona-opera.md"]
short_description = "&quot;For me, it is important to make an audience comfortable before we take them on an unexpected journey. My mentor Carlisle Floyd says that if an audience has a vocabulary of 200 words, give them those words plus 200 they don&#039;t know. I have stood by that in all of my writing.&quot;"
slug = "new-operas-craig-bohmlers-riders-of-the-purple-sage"
title = "New operas: Craig Bohmler&#039;s Riders of the Purple Sage"
+++

### Why does Zane Grey's novel adapt well to an opera?

*Riders of the Purple Sage* is dramatic, with vivid characters who have clear agendas and interact in situations with high stakes. There is plenty of conflict and opportunity for the drama to soar. While the characters live large in a massive landscape, their story is an intimate one. In reading it, I felt it was "operatic" and only needed a few minor tweaks.

### Themes in the story, like religious fundamentalism, gun violence, & women's rights resonate loudly today; how do you think audiences today will react to the timeless issues in this opera?

I believe it is art's responsibility to pose questions without giving didactic answers. These issues are touched on throughout the piece as they affect the characters, but we do not lean on them too heavily.

The most controversial aspect of this question has been the gun issue (surprisingly, not the Mormon one). We definitely show both sides of that question, as does Grey in his novel. One of the main characters is completely opposed to guns; another feels unsafe and incomplete without his. Gun enthusiasts will probably feel they have won the battle in this opera, and I think gun control advocates will feel heard as well. Having treated this so openly, our story seems to be embraced by all.  

The issue of religious fundamentalism is what I considered to be the most currently relevant subject in the novel and what first attracted me. Because it was specifically Mormon fundamentalism, I consulted several Mormon church members, friends, and elders, and went to Salt Like City on a research tour. The more I began to know of these people, the more admiration I had for them. The Mormons in Grey's book tend to be more black and white bad guys, but when we adapted the story, we endeavored to give all our characters clear and believable motivations. 

Grey wrote strong women characters, like Riders heroine Jane Withersteen, who come into their own as his novels progress. Because her father had no sons, Jane was encouraged and trained to take up his duties, and thereby became the self-reliant woman she is. This is particularly at odds with a society that subjugates women with plural marriage and property ownership, and it is her strength, often through faith, that drives her and compels her decisions.

While we don't expect audiences to react in just one way, we think they will find relevance in their own lives and come away entertained – and with a lot to think about!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1472156800408/2016-08-27---CraigBohmler_ChrisLoomis.jpg.jpg)
<figcaption>Craig Bohmler, composer. Photo by Chris Loomis.</figcaption></figure>

### What have been your influences or references for how the music will sound?

Because I was raised on westerns and also have written 10 musicals, I've found *Riders* to be the perfect vehicle to avail myself of numerous styles in which I’ve worked. Though it is a true opera from start to finish, it has reprises, occasionally rhyming lyrics, and an orchestration that tips its hat to the western movie score. There have not been many operas based in the American Wild West.  The only musical point of reference an audience has for westerns is a large orchestral movie sound, usually with French horns. I believe it is important to reward expectation before the sound world of Riders grows more complex and individualistic. 

For me, it is important to make an audience comfortable before we take them on an unexpected journey. My mentor Carlisle Floyd says that if an audience has a vocabulary of 200 words, give them those words plus 200 they don't know. I have stood by that in all of my writing. 

### Do you find anything unique about the language of the text?

There are the usual western idioms (clichés) that imbue this piece – mostly things like the clipped "n" ("Goin'") instead of going for example and a few "ain'ts" and the very occasional "reckon". We did find that Jane speaks more formally – perhaps she is more educated or prides herself in her use of the language. I find it helps set her apart from the other characters. The Bishop also speaks more formally, being a preacher. The others are rougher in their language and we have tried to articulate these differences in our text. There is some cursing, but we tried to use it sparingly and only when it seemed important to emphasize an emotion. I find that too much cursing actually defangs the intent. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1472156841501/2016-08-27--RidersCostume-Inspiration_CourtesyofArizonaOpera.jpg.jpg)<figcaption>Costume inspiration for *Riders of the Purple Sage*. Photo courtesy of Arizona Opera.</figcaption>
</figure>

### How do various English dialects change the way you set the libretto?

All textual syllables dictate to me how they should be set, whether proper English or more rough dialects. I tend to say the text over and over in my head until the notes or emphases make themselves apparent. 

### Is there any character or dramatic point in this story with which you have a particular connection?

I particularly like Lassiter, a cowboy who arrives at the Withersteen ranch on a mission to avenge his sister's death but who is also full of sensitivity and tenderness beneath his outward hardened appearance. He is deeply complex and makes his journey with interesting revelations and unexpected turns. My favorite moment is the one where he reveals his personal philosophy at his sister's grave – one in which he eschews relying on any particular religion or society, yet still leaves room for love and wonder – and also lets his emotions come forward. This seems to be a high point for the audience as well. We get the sensitive side of the rough but reflective man.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/18wFLp42ZD4" frameborder="0" allowfullscreen></iframe>
</figure>

>*Riders of the Purple Sage* plays in Tucson and Phoenix, February 25 to March 5, 2017. For details and tickets, [click here](http://www.azopera.org/performances/riders-purple-sage).
