+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-03-30T12:02:00+01:00"
lastmod = "2017-04-04T17:47:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1491233651140/2017-04-04---Repetiteur.jpg.jpg"
publishDate = "2017-04-04T12:11:00+01:00"
related_articles = ["articles/star-repetiteur-there-is-such-a-thing.md","articles/how-to-lead-your-pianist.md","articles/the-pianists-tech-week-plight.md"]
short_description = "Centuries ago, the piano could act as a self-contained, portable element that encompassed the sound world of an orchestra; the role of the répétiteur has evolved organically out of this practice, and most rehearsal pianists are valuable assistants to conductors and liaisons for singers. Now, composers are now working with a sound spectrum that is larger than a piano can represent; to use a piano in rehearsal no longer achieves the goal of re-creating what the singers will hear when the &quot;real orchestra&quot; shows up."
slug = "new-opera-repetiteur"
title = "Is new opera putting the répétiteur out of a job?"
+++

Terrifying question for you: is new opera putting rehearsal pianists out of a job?

Realistically, the answer is a no. But many répétiteurs can vouch for the world of difference between playing an orchestral reduction of a Mozart opera, versus something that's brand new.

It seems an easy progression, maybe even one that pianists should have seen coming for decades. It's par for the course that a répétiteur can rarely play all the notes of a full score, and neither should they try; pianists who play orchestral reductions are charged with paring down music written for anywhere from 20-100 musicians, constantly finding the "least worst option" that's possible with ten fingers and two feet. It's about function and representation, not about accuracy.

Most répétiteurs would agree that the music of Strauss, Wagner, and Britten offer more challenges than scores by Handel or Donizetti. Those challenges come from the larger orchestra with more varied instruments, and the growing imagination of later composers. Sounds like skittering strings with [bows on bridges](https://www.merriam-webster.com/dictionary/sul%20ponticello), [flutter-tongue](https://en.wikipedia.org/wiki/Flutter-tonguing) winds, and pitch-bending timpani solos are the precursors to the enormous spectrum of "permissible" sounds in the classical music and opera worlds.

By the time we get to the late 20th and 21st centuries, when composers are experimenting with electronically produced sounds, instrument-specific sound effects, and even *a cappella* opera, pianos can be a less-than-ideal choice for a rehearsal instrument.

It's something we noticed at Mahogany Opera Group's fantastic [Various Stages Festival](/6-new-works-presented-at-various-stages-2017/) earlier this year. Out of the six operas-in-progress they presented, we heard a handful of scores that would be tricky to represent on a piano. These scores feature pitchless sound effects, entirely electronic drones, and even the sounds of ceramic bowls clinking together; the choices are evocative and the operas are exciting, but rehearsing with a piano would seem ineffective.

Centuries ago, the piano could act as a self-contained, portable element that encompassed the sound world of an orchestra; the role of the répétiteur has evolved organically out of this practice, and most rehearsal pianists are valuable assistants to conductors and liaisons for singers. Now, composers are now working with a sound spectrum that is larger than a piano can represent; to use a piano in rehearsal no longer achieves the goal of re-creating what the singers will hear when the "real orchestra" shows up.

It seems as though if a répétiteur or rehearsal pianist were to be replaced by technology - opting for a recorded track rather than a malleable human being - it won't be your classic case of automation stealing jobs. The pieces themselves no longer lend themselves to an "orchestral reduction". Maybe it's up to répétiteurs to respond to opera's acoustic evolution; maybe the electric keyboard, the laptop, and the "tickle trunk" of percussion instruments are the rehearsal pianist's next set of tools.
