+++
author = ["authors/michael-ching.md"]
categories = "Op-ed"
date = "2015-09-07T22:03:00-04:00"
lastmod = "2015-09-09T08:06:00-04:00"
preamble = "This is a guest contribution by American composer and conductor Michael Ching. He is known for *Buoso's Ghost* (1996), *Corps of Discovery* (2003), *Slaying the Dragon* (2012), *Speed Dating Tonight!* (2013), and an *a cappella* setting of Shakespeare's *A Midsummer Night's Dream* (2011). After you're done reading, check out his blog, [Opera and Beyond](http://operaandbeyond.blogspot.ca/). You can also catch *Speed Dating Tonight!* at Opera McGill this November. For details, follow the box office links below."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1441717333942/MC-in-fountain-L-MurpheySquare.jpg.jpg"
primary_image_credit = "Photo by Lance Murphey."
publishDate = "2015-09-09T08:04:00-04:00"
related_articles = ["articles/the-future-of-opera-is-indie.md","articles/conductors-what-else-do-they-tell-us.md","articles/michael-park-on-opera-disease.md","articles/the-score-how-to-see-what-a-composer-sees.md","articles/living-up-to-its-name-experiments-in-opera.md"]
related_companies = ["scene/companies/savannah-voice-festival.md","scene/companies/opera-mcgill.md"]
short_description = "Historical memory in opera production is very short. It is probably a shorthand that is not intended to insult, but as time passes we forget the directors, designers, singers and producers of an opera. Even the librettists can get left behind. It is a shame and creates the perception that composers are all Wagnerian control freaks whose work arrives perfectly formed."
slug = "new-opera-more-singer-input-needed"
title = "New Opera: More Singer Input Needed"
+++

Historical memory in opera production is very short. It is probably a shorthand that is not intended to insult, but as time passes we forget the directors, designers, singers and producers of an opera. Even the librettists can get left behind. It is a shame and creates the perception that composers are all Wagnerian control freaks whose work arrives perfectly formed.

As the official premiere of my opera [*Alice Ryley*](http://savannahvoicefestival.org/festival/alice-ryley-a-savannah-ghost-story/) approaches on October 30th, I'd like to reflect for a bit on the helpful collaborative input I have received from singers in hopes that by describing this process, it might be replicated elsewhere. To paraphrase Koko in *The Mikado*, my hope is that singers will not be afraid to "put in their oars."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1441717357129/alicefinal5Resized.jpg.jpg)<figcaption>Artwork by Telly Konstantinidis for *Alice Ryley*.</figcaption>
</figure>

Founded by barigod [Sherrill Milnes](/scene/people/sherrill-milnes/) and [Maria Zouves](http://savannahvoicefestival.org/whos-who/), the [Savannah VOICE Festival](/scene/companies/savannah-voice-festival/) is, not surprisingly, a singer-based company. The commissioning process began with a long chat between Sherrill and me about their wanting a piece with memorable, excerpt-able arias and ensembles. Later on they requested that I remove a Mozartean instrumental ending to an aria so that the final cut-off could include the mezzo soprano. Maria pushed the concept that the title character in the opera (Alice) be played by two singers and at some point in the opera there would be some way for them to sing together. This kept not happening until it did--and you can hear the result [here](https://soundcloud.com/michael-ching-3/duet-from-alice-ryley/s-EfPgV) from the Tarpon Springs workshop. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1441761411548/Ching%20ALICE%20RYLEY%20workshop.jpg.jpg)
<figcaption>Jessica Ann Best as Jailed Alice in the recent workshop of *Alice Ryley* in Tarpon Springs. Photo by George Konstantinidis.</figcaption>
</figure>

I'm delighted that this feedback has produced several pieces that cast members want to use at auditions and concerts. On its way to the premiere, the opera has gone through workshops in New York, Savannah, and Tarpon Springs, Florida. At each workshop refinements have been made for the cast and with their input. 

I am suited to this kind of collaboration through both temperament and training. My principal composition teacher, [Robert Ward](http://www.npr.org/sections/deceptivecadence/2013/04/03/176141445/remembering-pulitzer-prize-winning-composer-robert-ward) (*The Crucible*) insisted that I be able to play and sing every note of any opera I wrote, so in the end there are very few passages in the show that aren't singer friendly. Another thing that was done deliberately (composer-readers here take note) is that when possible, dissonance was put in the accompaniment/orchestration against the vocal lines, which were kept as conjunct as possible. This was made possible in part  by the storyline which, to use a gamer acronym, is very PVE (Player vs. Environment). So just as the main character, Alice, struggles with the challenges she faces in the new Georgia colony, so the singer faces challenges from the accompaniment. This approach has allowed the piece to be both fun to sing and not afraid of occasional dramatic dissonance. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1441800342220/MC-5X7.jpg.jpg)<figcaption>Michael Ching. Photo by Nancy Smith-Blackwell.</figcaption>
</figure>

I would encourage composers not to internalize the bearded-deadguy-genius model of the composer and to instead think of ourselves as photographers and fashion designers. If we make our models great clothes and frame them in just the right light, everyone will end up looking good and the audience will be left wanting more. And, fellow Schmoperans, I would encourage singers to put in their .02. Just as the viola player knows more about their instrument than the conductor does, you probably know more about your voice (and singing) than the composer. And if you are happy and shown off to good effect, everybody wins. 

>Canadian readers can see composer/librettist Michael Ching’s popular opera, *Speed Dating Tonight!* this fall at McGill University. *Alice Ryley* is the first of two operas he is writing for the Savannah VOICE Festival. Michael’s regular blog is [Opera and Beyond](http://operaandbeyond.blogspot.com/). Michael is Music Director of [Nickel City Opera](http://www.nickelcityoperaco.com/) in western New York and former Artistic Director of Opera Memphis.
