+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2019-03-08T01:38:59+00:00"
disclaimer = ""
image_gallery = []
postamble = "For a full line-up of events at the 2019 New Generation Festival, [visit their website](https://www.newgenerationfestival.org/en/2019)."
preamble = "Happening in the Gardens of the Palazzo Corsini in Florence, the New Generation Festival is an annual festival that celebrates young and emerging artists in everything from opera to jazz. Kicking off the 2019 Festival, which runs August 28-31, is a proper classic: Mozart's _Le nozze di Figaro_.\n\nSouth African stage director Victoria Stevens is set to span centuries with her _Figaro_, placing Mozart's Classical opera in the late baroque Palazzo Corsini, and adding technological surprises of the 21st century.\n\nWe spoke with Stevens about her place in this year's New Generation Festival, and her lofty plans for her free time in Florence."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1552009616/media/2019/03/sqVictoriaStevens.jpg"
primary_image_credit = "Victoria Stevens, stage director."
related_articles = ["articles/how-lucky-are-we-the-children-of-opera.md", "articles/talking-with-directors-jennifer-williams.md"]
related_companies = []
related_people = []
short_description = "\"I am also excited to have a predominantly female production team around me, made up of inspiring women with strong ideas and the conviction to realise them.\""
slug = "a-figaro-for-a-new-generation-victoria-stevens"
title = "A Figaro for a New Generation: Victoria Stevens"
youtube_url = ""

+++
### What do you think is the message of Mozart's Le nozze di Figaro? Do you find there are any common misconceptions about the characters or the piece?

At face value, Mozart and da Ponte's setting of Beaumarchais's contentious play _La folle journée, ou le Mariage de Figaro_ presents as a comedic romp in which witty underclass triumphs over powdered, plump aristocracy—and all's well that ends well.

But beneath the frothy, light-hearted exterior of this _opera buffa_ is a remarkably honest and often sobering commentary on human nature and, simply put, _why we do what we do_. It confronts a number of difficult truths that simmer below the surface of many relationships: mistrust, disloyalty, a disconnect between idealized expectation and reality, and the pervasive fear of a love that slowly ebbs away.

Starker still are the themes of sexism and power dynamics that abound throughout, which remain arguably as problematic and reflective of the world around us as they were for Beaumarchais and Mozart. In a time where women are encouraging other women to expose and speak out against engendered exploitation on the basis of sex, and in worst case scenarios, sexual abuse, the active decision of the female protagonists in the piece to take a stand against the Count's perpetual objectification resonates.

>"We will set our Figaro in a film studio estate in the Golden Age of Hollywood, an environment riddled with pretense and governed by the same power structures as Beaumarchais intended."

Through the women's unified efforts, the Count is forced to atone for his behaviour, and though the lushness of the music here hints at a genuine apology, a cycle is wont to repeat itself and not all parties are necessarily left happy or vindicated.

### What sort of aesthetic do you contribute to the New Generation Festival 2019?

The Festival is a wonderful initiative that acts as a playground for young artists to explore themselves and their art. It finds, nurtures and collaborates with young talent to build a new collective of artists with the power and curiosity to communicate. To bring the internal life of a piece to the fore takes training, insight, sensitivity, and crucially, collaboration, and the New Generation Festival facilitates this.

In terms of aesthetics, I try to connect with a universal humanity in my work, rather than choosing between a modern staging, with so-called contemporary relevance, versus a traditional one. Reflecting real-life interactions, decisions, thoughts and conundrums onstage creates a link between the work at hand and the audience, as they begin to recognize parts of themselves in the characters—despite the specificity of the "world" or "The Concept".

>"As a director, I don't claim to have all the answers."

This opera unfolds around the notion of disguise and of pretense: each character "plays a role" to varying extents, dons the guise of another, pretends to think one thing while concealing their true feelings, and suspends a falsehood to achieve an aim or prove a point. With this as a point of departure, we will set our _Figaro_ in a film studio estate in the Golden Age of Hollywood, an environment riddled with pretense and governed by the same power structures as Beaumarchais intended. Without giving too much away, we will incorporate new technologies and mixed media to develop the narrative, and will involve the magnificent surrounds of the Palazzo Corsini, the home of the Festival, into our staging.

I am also excited to have a predominantly female production team around me, made up of inspiring women with strong ideas and the conviction to realise them.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1552009961/media/2019/03/VictoriaStevensBW.jpg){{% /md %}}

<figcaption>Victoria Stevens, stage director.</figcaption>

</figure>

### What do you hope to say with your work?

I don't pretend to have something novel, revolutionary or special to say with my work. My role is simply to offer up what has already been said, and immortalized in pen and ink, for re-observation and interpretation. As a director, I don't claim to have all the answers; it is only through collaborative work and the sharing of ideas that a nuanced and honest narrative can be found, and together we bring the characters to the point where they are ready to speak. We, the team and cast, are only facilitators—it is up to the audience to determine what the piece has to say to them.

### Do you have any tourism plans for your time in Florence?

I completed my directing studies in Verona, so I'm looking forward to returning to Italy and seeing whether I can remember any Italian! Florence has much beauty and culture to offer, but the most quietly wonderful experience is running through the cobbled streets at dawn before the city is awake. Top that off with a scoop of gelato, which I suppose negates any running you might do, BUT, _gelato_.