+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-06-01T21:05:00-04:00"
lastmod = "2018-06-04T22:52:00-04:00"
preamble = "Nevill Holt Opera is rolling out its [2018 season](https://www.nevillholtopera.co.uk/whats-on), to be housed in the company's brand new theatre. The 400-seat theatre, developed within a Leicestershire stable yard, will be inaugurated with Mozart's [*Le nozze di Figaro*](https://www.nevillholtopera.co.uk/whats-on/le-nozze-di-figaro), **June 14-21**, and Thomas Adès' [*Powder Her Face*](https://www.nevillholtopera.co.uk/whats-on/powder-her-face), **June 28 & 30**.\n\nWe spoke with General Manager Rosenna East and Artistic Director Nicholas Chalmers about the theatre's award-winning architecture, and the nod to both old and new in [Nevill Holt Opera's 2018 season](https://www.nevillholtopera.co.uk/whats-on)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527902531699/sqNevillHoltOperaPowderherFaceMaryPlazasDuchessAdrianDwyerElectrician.jpg.jpg"
primary_image_credit = "Mary Plazas (Duchess) and Adrian Dwyer (Electrician) in Powder Her Face. Photo courtesy of Nevill Holt Opera. "
publishDate = "2018-06-04T22:52:00-04:00"
short_description = "&quot;Above all, it&#039;s a beautiful and intimate space. The natural colours and textures of the historic materials are brought out, and through a stunning skylight, daylight is brought into the space that was formerly a courtyard. It&#039;s a gem of a theatre!&quot;"
slug = "nevill-holt-opera-inaugurates-new-theatre-with-mozart-ads"
title = "Nevill Holt Opera inaugurates new theatre with Mozart &amp; Adès"
+++

### What has been the vision for Nevill Holt Opera's new performance space?

**Rosenna East**: Nevill Holt Opera has sought to create a unique and intimate performance space, underlining our mission to produce world-class opera with the best young talent. The theatre is a landmark in the area, sitting on top of a hill above a valley, visible for miles around. We wanted to create a beacon of artistic and architectural excellence, as well as brining a historic building to life. The Stirling prize-winning architects Witherford Watson Mann have worked with top acoustic and theatre design team [Sound Space Vision](http://www.soundspacevision.com/) to create a perfect performing space, in sympathy with the old building.

Above all, it's a beautiful and intimate space. The natural colours and textures of the historic materials are brought out, and through a stunning skylight, daylight is brought into the space that was formerly a courtyard. It's a gem of a theatre!

### How did you choose the two operas which will inaugurate Nevill Holt Opera's new performance venue?

**Nicholas Chalmers**: The new theatre is a wonderful architectural mixture of the old and the new. I chose *Le nozze di Figaro*, as it is has such a celebratory overture and the opera represents the highest achievements of
a composer and librettist in the 18th century (the same century as our stable yard theatre exterior was constructed). *Powder Her Face* tells of the life and times of the Duchess of Argyll. The score is full of the energy of a young composer, Thomas Adès. Like the architecture of the new building, we have programmed the traditional with the contemporary.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527902684785/EastChalmers.jpg.jpg)
<figcaption>Nevill Holt Opera General Manager Rosenna East, and Artistic Director Nicholas Chalmers.</figcaption>
</figure>

### What considerations do you think are unique to designing a space for theatre and opera?

**RE**: Most buildings are designed from the outside in. But a theatre must be designed from the inside out – the most important thing is the acoustic, above all. After that it needs to be visually great for all the audience – and we are proud that in our theatre there are no "bad" seats, no restricted views. That is important. The audience should feel drawn in to the magical space of the performance, and the performers should be able to look out and feel the audience there, supportive, and wrapped up in the drama and the music.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527902650596/NewtheatreatNevillHoltOpera.jpg.jpg)
<figcaption>The New Theatre at Nevill Holt Opera. Image courtesy of Nevill Holt Opera.</figcaption>
</figure>

### What makes *Le nozze di Figaro* a good opera for Nevill Holt's commitment to fostering the careers of emerging artists?

**NC**: Five of the principal roles can be sung by young voices; Figaro, Susanna, The Count, Countess and Cherubino. A chorus is also required. So we are able to fill our cast with exceptional young artists. Many of the choices we make in repertoire centre around showcasing and providing opportunities to young performers.

### How do you think *Powder Her Face* balances salacious or scandalous details, with telling a true story of a real woman?

**NC**: The balance is perfect in the libretto of Philip Hensher and the music of Thomas Adès, because they capture the life and times of this fascinating woman and allow us to find sympathy with her in the demise she faces. Antony McDonald directs this piece for us and gets to the heart of the drama and the isolation facing the Duchess in old age. The soprano, Mary Plazas is amazing in this role and I cannot wait for our audience to experience this piece and this 5 star production.

### Are there any highlights of this season that you particularly look forward to?

**NC**: I am delighted that we are able to work with such wonderful young talent. We are pleased to showcase local talent too, and we have Leicestershire born baritone, James Newby singing the role of The Count. I am particularly looking forward to introducing our new orchestral partners to Nevill Holt; The Royal Northern Sinfonia will play *Le nozze di Figaro* and The Britten Sinfonia will play *Powder Her Face*. I am also looking forward to gauging the audiences' reaction to hearing our new acoustic with these fabulous orchestras.

>Nevill Holt Opera's season starts with [*Le nozze di Figaro*](https://www.nevillholtopera.co.uk/whats-on/le-nozze-di-figaro) on June 14. For details, [click here.](https://www.nevillholtopera.co.uk/whats-on)
