+++
author = ["authors/greg.md"]
categories = "Review"
date = "2018-02-09T11:43:00-05:00"
lastmod = "2018-02-09T17:22:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518193482982/sq---17-18-04-MC-D-1013.jpg.jpg"
primary_image_credit = "Claire de Sévigné as Blonde and Owen McCausland as Pedrillo in the Canadian Opera Company’s new production of The Abduction from the Seraglio, 2018. Photo: Michael Cooper."
publishDate = "2018-02-09T11:52:00-05:00"
related_articles = ["articles/spotlight-on-owen-mccausland.md","articles/in-review-peter-deutsch-at-wigmore-hall.md","articles/jane-archibald-more-than-the-sum-of-all-those-notes.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/jane-archibald.md","scene/people/mauro-peter.md","scene/people/claire-de-sevigne.md","scene/people/owen-mccausland.md"]
short_description = "It was a decidedly more positive portrayal of the &quot;Mohameddans&quot; as they&#039;re called in a new prologue by Mouawad. However, we are sort of expected to gloss over the fact that Bassa Selim is involved in the slave trade (he hands Blonde off to Osmin as property) and reward him for being &quot;kind&quot; to Konstanze and Blonde  - meaning he didn&#039;t imprison them or send them to the kitchens, but to the bedrooms."
slug = "never-black-white-abduction-at-the-coc"
title = "Never black &amp; white: Abduction at the COC"
+++

Opening night for Mozart's [*The Abduction from the Seraglio*](https://www.coc.ca/productions/13570) (*Die Entführung aus dem Serail*) took place Wednesday night, bringing to the stage director Wadji Mouawad's new take on the work. First performed at Opera de Lyon in 2016, Mouawad's artistic vision has been called "an agent of change" by the *New York Times*. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518193602720/17-18-04-MC-D-1161.jpg.jpg)
<figcaption>(l-r) Jane Archibald as Konstanze, Mauro Peter as Belmonte, Owen McCausland as Pedrillo and Claire de Sévigné as Blonde in the Canadian Opera Company's new production of *The Abduction from the Seraglio*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

The basic story is this: Konstanze and her two servants Blonde and Pedrillo are kidnapped by pirates and sold into slavery to Turkish Muslims. Belmonte comes to Turkey to rescue them. Mouawad's goal was to portray the story genuinely and seriously. Presented as a flashback, he takes the opportunity to ask, "What happens after?" 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518193611122/17-18-04-MC-D-0020.jpg.jpg)
<figcaption>A scene from the Canadian Opera Company's new production of *The Abduction from the Seraglio*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

The original singspiel dialogue has been replaced with Mouawad's own script that takes a decidedly more dramatic angle to the buffo story we've come accustomed to for *Adbuction*. I'll agree that this was a creative, complete, honest examination of the events from a different perspective and it raised a lot of questions you don't normally ask in this opera.  

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518193629253/17-18-04-MC-D-0474.jpg.jpg)
<figcaption>(foreground) Jane Archibald as Konstanze and Raphael Weinstock as Bassa Selim in the Canadian Opera Company's new production of *The Abduction from the Seraglio*, 2018. Photo: Michael Cooper</figcaption>
</figure>

Most particularly poignant for me was when Konstanze and Blonde rail into Belmonte and Pedrillo saying "You would have only saved us if we were faithful - otherwise you would have left us behind." This production highlights the fact that Belmonte has no clue what has transpired in Turkey in the intervening two years. While from his point of view Belmonte's objectives are pretty noble, this is only the case if the situation is clear-cut in black and white. Unfortunately for him, these situations never are. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518193640434/17-18-04-MC-D-1110.jpg.jpg)
<figcaption>Jane Archibald as Konstanze and Mauro Peter as Belmonte in the Canadian Opera Company's new production of *The Abduction from the Seraglio*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

In the role of Konstanze, soprano [Jane Archibald](/scene/people/jane-archibald/), COC's inaugural Artist-in-Residence, sang with passion and verve. The natural bloom over the top of her register, which this monolith of a role demands, was thrilling. Her coluratura was clean and precise and her dynamic range was pretty spectacular. Archibald's Konstanze was elegant without being haughty and her relationship with the Pasha Selim showed a range of character, which was a driving force throughout the whole show. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518193649520/17-18-04-MC-D-0873.jpg.jpg)
<figcaption>Jane Archibald as Konstanze (centre) in the Canadian Opera Company's new production of *The Abduction from the Seraglio*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

Swiss tenor [Mauro Peter](/scene/people/mauro-peter/), in his Canadian debut, sang a brilliant Belmonte, a full lyric with a lightness to his production that is both powerful and delicate and perfect fit for Mozart roles. His portrayal of Belmonte as this altruistic hero was heightened by the music Mozart provides for the role. He was earnest in his desire to rescue Konstanze, if a little backwards through the 20/20 hindsight scope of history. When paired with Archibald it was beautiful music-making. It made me feel as though I was listening to Mozart masquerading as bel canto. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518193665377/17-18-04-MC-D-1255.jpg.jpg)
<figcaption>(foreground, kneeling) Raphael Weinstock as Bassa Selim, Jane Archibald as Konstanze and Mauro Peter as Belmonte; (background, kneeling) Claire de Sévigné as Blonde and Owen McCausland as Pedrillo in the Canadian Opera Company's new production of *The Abduction from the Seraglio*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

Back home on the COC Stage is COC Ensemble graduate soprano [Claire de Sévigné](/scene/people/claire-de-sevigne/) in the devilishly tricky role of Blonde. Her bright, agile, and free sound was a scene stealer, not to mention her plucky characterization. Blonde was feisty but still loveable and managed to show the full journey of Blonde's pretty traumatic two years. De Sévigné brought to light the conflict she felt at accepting her current fate. The release felt during her scene with Pedrillo when she first learns of Belmonte's coming is a breath of fresh air, and was a highlight of the show for me. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518193679940/153.jpg.jpg)
<figcaption>Claire de Sévigné as Blonde and Goran Jurić as Osmin in the Canadian Opera Company's new production of *The Abduction from the Seraglio*, 2018. Photo: Gary Beechey.</figcaption>
</figure>

Fellow COC Ensemble graduate tenor [Owen McCausland](/scene/people/owen-mccausland/)'s Pedrillo felt like the most "traditional" Mozartian role, and it fit perfectly in this show considering Pedrillo's station in all of this. McCausland's steely and agile tenor brought a strong solid tone throughout the show. He sounded fantastic singing with Peter and his chemsitry with de Sévigné was delightful.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518193693543/17-18-04-MC-D-1043.jpg.jpg)
<figcaption>Goran Jurić as Osmin and Owen McCausland as Pedrillo in the Canadian Opera Company's new production of *The Abduction from the Seraglio*, 2018. Photo: Michael Cooper.</figcaption>
</figure> 

Bass Goran Jurić as Osmin, along with McCausland, was the comic relief of the show. His rich, booming bass married well with this stubborn, set-in-his-ways, portrayal of the Pasha's honoured henchman. His relationship with Blonde was curious for me. You saw that he actually genuinely came to love her, even though she was given to him as property. He was very good at letting his guard down around her, while not being a pushover with anyone else. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518193702268/17-18-04-MC-D-1294.jpg.jpg)
<figcaption>(top, l-r) Jane Archibald as Konstanze and Claire de Sévigné as Blonde; (bottom, l-r) Owen McCausland as Pedrillo and Peter Mauro as Belmonte in the Canadian Opera Company's new production of *The Abduction from the Seraglio*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

Israeli actor Raphael Weinstock brought us a layered Bassa Selim. After forgiving the given circumstances of his position politically, Weinstock kept the Pasha with an even keel and a logical discourse. This treatment is probably left over from the original play where it is noted that the Pasha has had some European education. His scenes with Archibald seemed to be the most settled in the show. He was a handsome, grounding force. I heard more than one person in the lobby saying "Yeah, I'd go with THAT Selim, for sure."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518193719118/151.jpg.jpg)
<figcaption>Jane Archibald as Konstanze (fourth from left) in a scene from the Canadian Opera Company's new production of *The Abduction from the Seraglio*, 2018. Photo: Gary Beechey.</figcaption>
</figure>

It was a decidedly more positive portrayal of the "Mohameddans" as they're called in a new prologue by Mouawad. However, we are sort of expected to gloss over the fact that Bassa Selim is involved in the slave trade (he hands Blonde off to Osmin as property) and reward him for being "kind" to Konstanze and Blonde  - meaning he didn't imprison them or send them to the kitchens, but to the bedrooms. I felt like the ladies were presenting some Stockholm syndrome in my completely medically and psychologically untrained opinion. 

My only issue with this new dramatization is the length. I very much felt like I was watching two different shows - Mozart's *Abduction* and Mouawad's sequel "After the Seragilo" - which left me feeling like the production didn't know exactly what it wanted to be. Is this a play that uses Mozart's music to highlight it? In that case, you need some judicious cuts to the music. Or, is it a modernization of the classic opera as a whole? In that case, some cuts and a revisit to the dramaturgy might help. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518193742377/180.jpg.jpg)
<figcaption>Goran Jurić as Osmin in the Canadian Opera Company's new production of *The Abduction from the Seraglio*, 2018. Photo: Gary Beechey.</figcaption>
</figure>

The new dialogue was fantastic but there were pacing issues, which did seem to relax in the second act. I also felt the text in the original arias were often at odds with what was being presented in the spoken dialogue. 

The orchestra and chorus were fabulous under Johannes Debus who, as I said above, conducted the show with more of a bel canto feel than the usual sprightly Mozart. I wasn't against it at all, in fact I felt like the conducting actually heightened Mouawad's vision and helped me buy into this re-telling a lot more wholeheartedly. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518193729887/17-18-04-MC-D-0127.jpg.jpg)
<figcaption>Mauro Peter as Belmonte (centre) in the Canadian Opera Company's new production of *The Abduction from the Seraglio*, 2018. Photo: Michael Cooper.</figcaption>
</figure>

[\#COCAbduction](https://www.coc.ca/productions/13570) runs from February 7-24 at the Four Seasons Centre for the Performing Arts. The singing is out of this world, and the perspective from which this story is told is incredibly fresh, invigorating, and creative. 
