+++
author = ["authors/kristen-seikaly.md"]
categories = "Op-ed"
date = "2016-08-04T05:55:00-04:00"
lastmod = "2017-11-28T19:49:00-05:00"
preamble = "This post was originally published by [Kristen Seikaly](/scene/people/kristen-seikaly) on [Operaversity](http://operaversity.com/business/networking-for-introverted-performers), a great resource for working singers and teachers. For more, follow Operaversity on [Twitter](https://twitter.com/Operaversity) and [Instagram](https://www.instagram.com/operaversity/)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511915019200/2017-11-28---Introvert.jpg.jpg"
publishDate = "2016-08-10T03:27:00-04:00"
related_articles = ["articles/the-anxious-singer-10-tips-to-help-with-anxiety.md","articles/the-introverts-opera.md","articles/the-heart-and-the-art.md","articles/dear-me-advice-to-my-freshman-self.md"]
related_people = ["scene/people/kristen-seikaly.md"]
short_description = "While it may seem to many people that &quot;introverted performers&quot; is an oxymoron, I assure you that this is not the case. Being an introvert in an extroverted field can pose its own challenges though. Perhaps the biggest challenge it poses is networking."
slug = "networking-for-introverted-performers"
title = "Networking for introverted performers"
+++

While it may seem to many people that "introverted performers" is an oxymoron, I assure you that [this is not the case](http://operaversity.com/performance/introverted-performers-thing/%20). Being an introvert in an extroverted field can pose its own challenges though. Perhaps the biggest challenge it poses is networking.

## What is Networking?

Networking is one of those words that makes most introverts (and some extroverts) groan. It comes with images of schmoozing up billionaire oil tycoons at fancy cocktail parties, or going to conferences and handing out business cards like candy. However, this isn't really networking.

In fact, the honest definition of networking is *making and cultivating relationships to create a web of people that can operate interactively*. When you think about it, networking doesn't happen just in business (though this particular term is used almost exclusively when referring to business relationships). Think about how you make friends, or find new romantic partners. Many people do so by meeting others through people they already know. This is networking! The end goal is simply different. In your personal life, the goal is to cultivate new and meaningful relationships that can help you achieve your personal goals. In business, it's to do the same thing, but with professional goals.

With that said, what are the other ways people meet each other besides fancy cocktail parties, loud bars, or large conferences? Or even better, how do introverts navigate these extroverted situations with the best possible outcome without destroying their peace of mind?

## An Introvert in an Extrovert's World

There are ways that people can network away from the bustle of large events or crowded parties, but as a fellow introvert, I know it would be all too tempting to avoid networking at social events altogether. Instead, I'd like to first take a moment to discuss how you can use extroverted situations to your benefit by focusing on one goal.

When at a large event or a party or some situation where it's easy to find yourself overwhelmed with people you might meet, it's helpful to go in with a plan of action. If you go in with one goal, it will be a lot easier to get less overwhelmed than if you’re trying to meet everyone at once. Here are some goals you might have going into an event.

- Meet one person who knows someone else you know.
- Arrange one coffee date with someone who's doing work you'd like to do.
- Find one interesting fact about anyone you meet that you can use to remind them of your connection later on.
- Tell three people about an interesting project you're working on, and/or find out what interesting project someone else is working on.
- Learn about one new performance venue or ensemble in your area.

Whatever your goal may be, remember that there are three elements to any good networking goal. First, it is singular in focus. Achieving one good goal is better than halfway achieving many goals. Second, a good goal will give you information or even an opportunity. Networking is a great opportunity to learn what you don't know. Third and finally, a good networking goal will allow you to cultivate a connection with someone later on, either by an anecdote, a shared experience, or contact information.

## Changing the Playing Field

Those networking social situations don't seem so overwhelming now, do they? Still, they can be exhausting to do all the time. Here's the good news though – you don't have to do them all the time! One of the reasons introverts get overwhelmed with networking is they feel like they have to do everything. That's just exhausting anyway!

Instead, just like you picked a goal at the event, pick a goal for choosing events you go to. Do you want to meet opera directors? Do you want to meet donors? Do you want to meet other performers? Knowing who you want to meet will help you decide which events to go to. If an event won't have people who you want to meet, or meet your goal, then maybe you sit that one out. Will there be people there that might be good for you to know? Sure, but that's always true. If you sit it out every so often, your batteries will be charged for when you meet the people you really want to work with.

Furthermore, don't forget about the internet. The internet is an amazing tool for networking. Most people seem to think that the internet is merely a tool for cultivating relationships, rather than making them. Really though, it can do both. After all, [I landed a performance gig from blogging](http://operaversity.com/performance/blogging-landed-me-a-paid-performance-gig/%20), so why couldn’t you?

Participating in conversations with other musicians online is another way to build connections to reach your professional goals. You can do this easily through Facebook groups or Twitter chats. Plus, the internet comes with the added bonus of being able to connect on your own time, so you don't get put on the spot.

Networking seems like a scary ambiguous concept that is constantly looming over our heads. Hopefully this post has shown you though that it doesn’t have to be! If you'd like some help getting started, or just refining your networking skills, feel free to contact me here. We can strategize on how to best connect with others to meet your professional goals.

>How do you best connect with others to build on your professional goals?
