+++
author = ["authors/jenna.md"]
categories = ""
date = 2014-09-30T15:39:00Z
lastmod = "2015-04-14T15:01:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1633706769/media/2021/10/OperaNetflix_ytrl99.jpg"
publishDate = "2014-09-30T11:39:00-04:00"
related_articles = ["articles/googles-very-specific-opera-offerings.md", "articles/bring-back-opera-on-latenight-tv.md", "articles/opera-on-letterman.md", "articles/is-technology-making-it-harder-to-tell-stories.md", "articles/theres-still-no-opera-on-netflix.md", "articles/great-ideas-a-streamable-opera-miniseries.md", "articles/the-brief-history-of-madefortv-opera.md"]
short_description = "It&#039;s a fair question, isn&#039;t it? I mean, anyone who&#039;s into opera and classical music knows that the Internet is not our friend. While there&#039;s always trusty YouTube to the rescue when you&#039;ve got an urge to watch that old Met Gala, or Jonas Kaufmann is anything at all. But wouldn&#039;t it be amazing to be able to browse an opera collection of old and new broadcasts? "
slug = "netflix-why-not-opera"
title = "Netflix: Why Not Opera?"

+++
It's a fair question, isn't it? I mean, anyone who's into opera and classical music knows that the [Internet is not our friend](/online-music-is-obscuring-opera/). While there's always trusty YouTube to the rescue when you've got an urge to watch [that old Met Gala](https://www.youtube.com/watch?v=IDEOaz8v54Q&list=PL67AC3AA6E9D76C48), or Jonas Kaufmann is anything at all. But wouldn't it be _amazing_ to be able to browse an opera collection of old and new broadcasts? Especially the new. Plenty of companies broadcast or stream live performances; imagine if they all became available to watch on Netflix?

I decided not to begin this post with an assumption and do some searching for opera on Netflix. I started simply, with a search for "opera". I got a short list of suggestions "related to" _The Phantom of the Opera_ (including a _Power Rangers_ movie, no joke).I tried browsing categories, trying "Musicals" first. Turned up stuff like _Rent_, the Shirley Jones _Carousel_, and _Fiddler on the Roof _followed closely by _South Park: Bigger, Longer and Uncut_, _Shrek the Musical_, and lots and lots of Bollywood. I tried the "Music" category, and got plenty of music documentaries, musician biopics, the complete _Ken Burns: Jazz_, and a special with Stephen Fry about being a Jew who also loves Wagner (_Wagner & Me_).

So, slim pickings. I think it's fair to say that starting now, Netflix will be a major source of media intake for anyone under the age of 25\. Think about kids born in the last five years; they'll be part of the first generation of kids who very well may never be exposed to live theatre or music. While people of my generation and older grew up watching what was available on local television stations, today's kids will have a massive store of TV and movies that they can watch at any time. If [Victor Borge](https://www.youtube.com/watch?v=-gaKOKpGJ0s) on PBS and [_The Lawrence Welk Show_](http://en.wikipedia.org/wiki/The_Lawrence_Welk_Show) hadn't hogged the airtime for a couple of hours here and there, who knows how many people would have watched it? Basically, if opera doesn't have a place in that massive store from services like Netflix, we just might lose it in one generation.

So does Netflix, or services like it, have some sort of responsibility to provide a proper cross-section of today's visual culture? I say that because I suspect the biggest hurdle to getting plenty of opera in their collection would be convincing Netflix to provide it. I doubt that offering more opera would boost their income by much, and so it would have to be a real investment in culture, made jointly between Netflix and the opera companies themselves. It would be an amazing thing to have "episodes" of opera, made up of productions from the current and past seasons. You could follow seasons from Houston Grand Opera, Vienna State Opera and the Glyndebourne Festival; with enough of an operatic library built up, you could even follow specific singers, and get to know them and their careers. Bonuses like Richard Tucker Galas, or the Cardiff Singer of the World Competition could be up there too. I may be thinking idealistically, but imagine what could happen if the work of Peter Sellars, Ailyn Pérez, Robert Carsen, and Alice Coote made it into the average person's opera exposure, alongside Zeffirelli, Pavarotti and Kiri Te Kanewa. The real picture of what opera is today could be readily available to anyone who's been bored enough to browse, _deeply_, through Netflix for something new (I raise my hand, unashamed).

Searching in a similar vein for opera's presence on the Internet, I checked out relevant TED Talks. There isn't much, but it's still encouraging. There's a talk about Tod Machover's "robotic opera" [_Death and the Powers_](http://blog.ted.com/2010/09/17/tod-machover-talks-about-his-new-robotic-opera-death-and-the-powers/), and there's [Danielle de Niese](http://www.ted.com/talks/danielle_de_niese_a_flirtatious_aria#t-33323) proving that opera can be (gasp!) sexy; there's also [this fascinating chat](http://www.ted.com/talks/charles_hazlewood) with Charles Hazlewood about the complex role of the conductor. And I think we should all [go to TED.com and nominate ](http://www.ted.com/nominate/speaker)some of the charismatic characters we know could speak well on opera in a talk entitled, _Opera: What Is It_, or _Not All Opera Singers Have Horns. _Speakers like Joyce DiDonato or Antonio Pappano or Peter Sellars would push past operatic stereotypes, and they would be perfect liaisons from the general public into the _actual_ world of opera.

Of course, my idea about flooding Netflix with opera probably isn't new, and actually doing it probably has migraine-inducing hurdles attached. You'd have to convince Netflix that there's a long-term gain to be had by offering a collection of opera; on the side of the opera companies providing the productions, they might have to do some humbling negotiations for artist royalties and fees (I figure if they're basically doing opera a favour, some of the royalty fees involved in acquiring the production might be the hardest for Netflix to swallow). But it's intriguing, this idea of large Internet giants holding a certain level of responsibility for maintaining a large part of our culture. Conversely, with the possibility of opera getting dispersed throughout the general public with the same ease as television, our artists and companies might have to get comfortable with the idea of sacrificing royalty fees for the visibility. Could be humbling, but it could turn into something really exciting for opera.