+++
author = ["authors/jenna.md"]
categories = ""
date = 2017-10-30T01:56:00Z
lastmod = "2017-10-30T12:00:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509327496024/2017-10-29---Colours.jpg.jpg"
publishDate = "2017-10-29T22:07:00-04:00"
related_articles = ["articles/undergrad-degrees-why-youll-use-that-theory-class-after-all.md", "articles/4-tips-for-when-there-are-too-many-notes.md", "articles/4-ways-to-give-notes-still-be-liked.md", "articles/chiaroscuro-classics-the-marriage-of-figaro.md"]
short_description = "So. Back to the key of your aria. Basically, in the Baroque and Classical eras, the out-of-tuneness of various keys became associated with different affects. The theory was that a listener could be swayed to feel differently when they heard music played in G major versus in B-flat major, or in d minor versus f minor."
slug = "nerding-out-why-you-should-definitely-care-what-key-your-aria-is-in"
title = "Nerding out: why you should definitely care what key your aria is in"

+++
Singers, how closely do you pay attention to the key signature of the arias you sing? You know how to read music, of course - but that's not why I ask. Turns out, there can be a fascinating dramatic significance to the key in which an aria is written.

The reason why is somewhat long (and totally fascinating for some, so [check out Pythagorean tuning](https://en.wikipedia.org/wiki/Pythagorean_tuning)), but the gist is this: there's math involved in the tuning of intervals, and for some mysterious reason, the math doesn't actually allow every key to sound alike. Basically, a perfect fifth in C major (C-G, for example), will sound very different from a perfect fifth in C-sharp major (C#-G#). That means that when it comes time to tune a piano or a harpsichord - where the pitches are fixed - the tuner or player actually has to prioritize certain keys over others. Often, the result is a keyboard where "round keys" like C, G, and D major are decently in tune, and more mathematically complicated ones like a-flat minor sound mighty twangy.

It's a fascinating glitch of acoustic science that finds its way into our musical aesthetics; if you peruse J.S. Bach's two-volume _Well-Tempered Clavier_, you can see how he writes for the keys that sound more consonant, or "in tune" (like the lyrical [C-Major Prelude No. 1](https://www.youtube.com/watch?v=ezZdbzreNcs)), versus the keys that would have been given a lower priority (like the sour-sounding [Fugue in e-flat minor](https://youtu.be/EMkELvW39oE?t=260)).

Today, instead of "well-tempered" instruments, we use equal temperament. It's sort of a lowest-common-denominator approach to tuning a piano, meaning that the different keys sound mostly alike compared to each other, but the Pythagorean math has been fudged just enough so that the keys are all equally "out of tune". It's something you can actually hear when a piano joins an orchestra; the orchestra can play more "purely" in tune, while the piano needs to stick with its equal temperament. Try it: listen to any piano concerto that starts with just the orchestra; when the piano joins in, there's a bit of a dulling effect; your ears will adjust, but it's always a cool moment for tuning nerds.

So. Back to the key of your aria. Basically, in the Baroque and Classical eras, the out-of-tuneness of various keys became associated with different affects. The theory was that a listener could be swayed to feel differently when they heard music played in G major versus in B-flat major, or in d minor versus f minor. In a well-tempered world, the keys really did sound different, and there became an almost codified system of affects assigned to various keys. Musicologist Rita Steblin wrote about this practice in the 18th and early 19th centuries, in her aptly titled book, [_A History of Key Characteristics in the 18th and Early 19th Centuries_](A History of Key Characteristics in the 18th and Early 19th Centuries). In case you're not up for reading the whole book, you can find a summary of [keys and their affects here](http://www.wmich.edu/mus-theo/courses/keys.html).

Singers are always trying to peel back another layer about the characters they portray, and starting from the score is always a great option. It's not hard to find the connection between **D major**, the key of triumph, victory, and war cries, to the Count's aria from _Le nozze di Figaro_, or the discontent and ill-tempered nature of **g minor** with the opening of the Queen of the Night's first aria in _Die Zauberflöte_ ("Zum Leiden bin ich auserkoren").

It's even more interesting to find common ground among arias that seem quite different. Example: Sesto's "Cara speme" (_Giulio Cesare_), Donna Elvira's "Mi tradì quell'alma ingrata" (_Don Giovanni_) and Figaro's "Aprite un po' quegl'occhi" (_Le nozze di Figaro_) are all written in **E-flat major**, a key of love, devotion, and conversations with God. In Sesto's case, he's enamoured with the idea of justice and avenging Pompey's murder; Elvira is certainly devoted to Don Giovanni, and she's praying for his salvation; Figaro's angry musings on the nature of women is something of a man-to-man between himself and God, and there's certainly love for Susanna in the mix of emotions.

**F major** is a key of calmness and complaisance, an interesting common ground among arias like Almirena's "Lascia ch'io pianga" (_Rinaldo_), Donna Anna's "Non mi dir" (_Don Giovanni_), Figaro's "Se vuol ballare" (_Le nozze di Figaro_), Susanna's "Deh vieni, non tardar" (_Le nozze di Figaro_), and "Non più di fiori" (_La clemenza di Tito_). A calm quality feels noble in the Handel, wise in both Figaro and Susanna's arias, insane in Vitellia's mad scene, and holds a hint of dishonesty for Donna Anna.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/09rX9bDpVew?start=159" frameborder="0" gesture="media" allowfullscreen></iframe>
</figure>

Keys like **C Major** and **G Major** are considered "simple", the former a sign of purity and innocence, and the latter more rustic and gentle. They're common keys for arias sung by lower-class characters like Despina in _Così fan tutte_ ("Una donna a quindici anni"), Figaro in _Il barbiere di Siviglia_ ("Largo al factotum") and Papageno in _Die Zauberflöte_ ("Der Vogelfänger bin ich ja"). It's more interesting to hear these "simple" keys used for arias like the Countess' "Dove sono" (_Le nozze di Figaro_) and Count Almaviva's "Ecco ridente" (_Il barbiere di Siviglia_); in the case of the former, she's recalling simpler times, and for the latter, he's not being honest about his identity.

**B-flat major** is reserved for hope and clear consciences, like in Don Ottavio's "Il mio tesoro" (_Don Giovanni_), Sesto's "Parto, parto" (_La clemenza di Tito_), and Rodelinda's awesome "Spietati, io vi giurai" (_Rodelinda_). Contrast that with the innocent, trusting, youth-tinged love inherent in **A major**, like in Ferrando's "Un'aura amorosa" (_Così fan tutte_) or the sexy Act I duet between Zerlina in _Don Giovanni_, "Là, ci darem la mano".

Arias like Cleopatra's "Da tempeste il legno infranto" (_Giulio Cesare_), Fiordiligi's "Per pietà" (_Così fan tutte_), and Semele's "O sleep, why dost thou leave me?" (_Semele_) are all written in **E major**, the key of joy, laughter, anticipation, and delight. It's easy to spot in Cleopatra's aria, but the Fiordiligi and Semele picks offer deeper insight into their perceived seriousness.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/yUPxGcHyVhg" frameborder="0" gesture="media" allowfullscreen></iframe>
</figure>

Melancholic **d minor** is a shared key for the unlikely pairing of both the seductive "Deh vieni alla finestra" (_Don Giovanni_) and the Queen of the Night's infamous "Der Hölle rache" (_Die Zauberflöte_); more obvious pairing is the uneasy **g minor** of Pamina's "Ah! ich fühl's" and Papageno's Suicide Aria.

And one of the saddest: the **f minor** of Barbarina's little arietta, "L'ho perduta" from the final act of _Le nozze di Figaro_. Oftentimes it's a silly scene of "the help" having made a silly blunder; yet in this key of deep depression and longing for the grave, it's a reality check into Barbarina's potential fate (being fired from her job is really only the beginning).

<figure data-type="video">{{% md %}}<iframe width="896" height="672" src="https://www.youtube.com/embed/2Og3y4hRN1g" title="Le Nozze di Figaro-L'ho Perduta...Me Meschina!" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}

</figure>

It's hard to say exactly how much thought every composer put into the dramatic significance of an aria's key. Still, the clues left by the composer's choices are thought-provoking at the very least - and for those on the more extreme end of the music-nerd spectrum, they're positively gleeful finds.

Singers, let us know: how does your understand of your favourite arias stand up to its [key characteristics](http://www.wmich.edu/mus-theo/courses/keys.html)? Leave the juicy details in the comments below.