+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2019-06-23T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1561327973/media/2019/06/sqLittlePrince1976.jpg"
primary_image_credit = "The Little Prince, NEMPAC, 2019. Photo: Sabrina Ornae."
related_articles = []
related_companies = []
related_people = []
short_description = "One may ask oneself if the hyper-tonal, rather simplistic harmonic and melodic language of the source is perhaps too accessible for opera, but in my case I am not so certain it could have been done any other way."
slug = "nempacs-innocent-affecting-slightly-uneven-little-prince"
title = "NEMPAC's innocent, affecting, slightly uneven Little Prince"
youtube_url = ""

+++
Antoine de Saint-Exupéry's novella _Le Petit Prince_ presents two rather daunting challenges to anyone who hopes to adapt it out of its literary form and into a stage-based format, and both are to do with its fantastical story related through the sphere of child-like purity. One involves the fantastically symbolic nature of the plot, with its use of stellar setting that I imagine would be difficult for any stage director. The other then asks the tale's adapter to maintain the sense of wonder and innocence that the novella holds, for it is this on which any adaptation of it lives or dies.

Thus, we come to Rachel Portman's _The Little Prince_, her enchanting two-act opera on the subject, presented by the North End Music & Performing Arts Center's Opera Project. Certainly on the question of innocence she delivers. One may ask oneself if the hyper-tonal, rather simplistic harmonic and melodic language of the source is perhaps too accessible for opera, but in my case I am not so certain it could have been done any other way: the simplicity of the musical language interacts exceedingly well with the childlike nature of the opera's source, and the score finds really lovely ways to paint its text. It is ultimately pleasant music, if it does perhaps become a little too one-note owing to a not-so-poetic libretto and a second act which continues on too long after its thematic climax with the scene between the Prince and the Fox.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1561327832/media/2019/06/LittlePrince1874.jpg){{% /md %}}

<figcaption>The Little Prince, NEMPAC, 2019. Photo: Sabrina Ornae.</figcaption>

</figure>

Regardless, the innocence remains, and in the dramatically important moments it generally makes the right decisions on how to set its text. There are several notable instances of this: the Pilot to whom the Prince tells much of his adventures has an aria close to the top of the show in which he talks about his feelings towards flight: it is a fascinating window into his character, showing that he is very much an adult, but still capable of feeling a juvenile wonder at what he loves. In the show's funnier moments, it also has impeccable timing, managing its tone shifts with such grace the laughs came naturally. And then there is an _a capella_ choral point in the second act when the show's moral becomes clear that added a real dramatic heft. This, combined with the fact the music adds characterization that the libretto admittedly somewhat lacks, hints at the strengths of the work, and indeed shows that it is worthy of performance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1561327851/media/2019/06/LittlePrince1894.jpg){{% /md %}}

<figcaption>The Little Prince, NEMPAC, 2019. Photo: Sabrina Ornae.</figcaption>

</figure>

The fantastical settings are a different matter, and this depends less on the opera itself and more on the production design. And here is when we turn to the North End Music and Performing Arts Center's production of this opera in Faneuil Hall in the heart of Boston. There was really not much NEMPAC could do with producing the fantastical nature of the work: it is difficult, after all, to produce much in the way of set design in a decorated hall with priceless oil paintings and marble busts situated right behind the performance area.

> In the show's funnier moments, it also has impeccable timing, managing its tone shifts with such grace the laughs came naturally.

One also has to ask oneself how people deal with that when you have a very tiny budget to work with. Here, the production has mixed results, for while some touches worked others did not quite work out so well. For instance, the production design centered around a stage on which a prop plane was placed in center stage. Considering it is one of the few constructed pieces of set (and the only one that stays onstage the entire time), I was led to believe the plane would have more importance in the plot than it ultimately did: the fact that it ultimately was not so important to the plot did make me wonder if it hindered the stage action more than helping it. I also wondered if projections behind the action would have conveyed setting just as well, or even if the constructed setpiece should have been something else more central to the story.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1561327874/media/2019/06/LittlePrince1953.jpg){{% /md %}}

<figcaption>The Little Prince, NEMPAC, 2019. Photo: Sabrina Ornae.</figcaption>

</figure>

But then, there are other touches that work rather well, especially in how all the show's moving parts move about the stage. The supertitles, for instance, did show the Pilot's illustrations of the boa constrictor and the sheep. They added the perfect touch to the early part of the show's humor, and it was to such an extent that I wish the sketches displayed there had played more of a part throughout the production.

> Ultimately, however, it is all in the performances given, and in many ways everyone involved were rather excellent.

And then, there was the blocking, which was generally quite excellent. The blocking played with the height of the levels in Faneuil Hall to rather striking effect, particularly in the first act when it depicts the Prince's journey from his little asteroid to Earth, and how it colors his interactions with the various characters he meets along the way. The fact that the Prince sees the first four characters in this journey from the stage and then comes to converse with where they are situated directly in front of the front row of the audience (and thus beneath where he started) conveys a swooping down that simultaneously highlights how unusual and petty most of the characters are: when this dynamic is then flipped when the Prince encounters the Lamplighter, it adds importance to the Lamplighter, whose aria about when he has to turn his lamp on and off is perhaps as innocent and simplistic as the Prince himself. The blocking of every scene was also generally rather excellent even without this, from the comedy of the baobab seedlings running around being chased by the Prince's rake through the choreography of a hunter's chorus in Act II all the way to the Prince's not-quite death at the hands of the snake, as the snake dragged him through a row of children.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1561327920/media/2019/06/LittlePrince2014.jpg){{% /md %}}

<figcaption>The Little Prince, NEMPAC, 2019. Photo: Sabrina Ornae.</figcaption>

</figure>

Ultimately, however, it is all in the performances given, and in many ways everyone involved were rather excellent. Christina English grounded the whole work as the Pilot, whose straightlaced wonder at the Prince's simplicity acted as that bridge between the childlike and the mature which helps to make sense of the Prince's fantastical world. She did so with a warm, colorful voice, and acting that played off of the Prince's actions well. Roselin Osser also showed a playful, tender nature as the Fox: it was a one-scene role, but the Fox's significance to the theme of the work cannot be overstated, and Osser made sure the scene's impact came through with her playful yet tender portrayal of the character.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1561327943/media/2019/06/LittlePrince2060.jpg){{% /md %}}

<figcaption>The Little Prince, NEMPAC, 2019. Photo: Sabrina Ornae.</figcaption>

</figure>

Also notable was Ehimemen Omigie as the Lamplighter and the Drunkard: his turn with the Lamplighter's aria was as warm and sweet as it was strange, and his creamy voice projected well over everything else. Fran Daniel Laucerica as The Snake and The Vain Man also left a great impression: he produced a real contrast in tonal color between the two characters, and his agile turn as the Vain Man was only helped by hilarious antics with a kazoo that were a delight to watch. And then, there was Carley DeFranco's turn as the Rose on the prince's home planet: her airs were rather seductive, but she managed to show some true pathos at the Prince's departure. Rounding out this cast was Gray Leiper as a delightfully stuffy businessman claiming the stars are his, Marcus Schenck making or a king who cannot make up his mind on what others do and what powers he has, and Jennifer Caraluzzi as the water in a well that brings the climactic Act II scene together.

> Even despite the missteps, there was something to like about every aspect of the production.

Perhaps somewhat lacking was the Prince himself: Linus Schafer Goulthorpe perhaps was not as convincing as the rest of the cast. He had a tendency to park and bark, and it was obvious on several occasions that his parking was due to waiting for a cue from music director Tiffany Chang. This, however, can be chalked up to inexperience: in speaking to stage director Alexandra Dietrich after the show, it was made evident to me that this was Schafer Goulthorpe's debut in a solo role onstage, and for a first performance in a leading solo role he did rather well in at least conveying the broadest beats of how peculiar and perpetually innocent his Prince is. Perhaps his voice was a little thin owing to his age and inexperience (he is a child, after all), but he had a good tone color and his diction was the best of the cast, and it was clear he was trying his best. On these counts, I cannot fault him.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1561327963/media/2019/06/LittlePrince2247.jpg){{% /md %}}

<figcaption>The Little Prince, NEMPAC, 2019. Photo: Sabrina Ornae.</figcaption>

</figure>

But they all encountered one obstacle: the orchestra. Through much of the performance, the orchestra was loud to the point it made it difficult to hear much of the cast, especially poor Schafer Goulthorpe. It generally made the singing that much harder to understand, and in some cases it outright covered the whole action up. This is especially frustrating since, apart from this one issue, the orchestral players were top-notch: they expertly navigated Portman's score with ease, they crafted a sense of arc that helped the whole performance move at a rather good pace, and they injected plenty of character into the piece that even successfully conveyed mood where the singers could not. I also suspect that the orchestra's volume may at least partly have come down to placement in the hall, for there were some places in the venue where the singers projected better than even the stage itself. It is clear that the orchestra came close to perfection here, but they did not quite capture it on account of the volume issue.

In a strange way, perhaps the orchestral playing is a microcosm for the production as a whole: there are plenty of good things dotting NEMPAC's production, and there are a few things that threaten to pull it apart. At the end of the day, however, I feel that the overall performance ultimately highlighted a strong piece whose music felt fully integrated with the themes of Antoine de Saint-Exupéry's novella. Even despite the missteps, there was something to like about every aspect of the production, and the good elements altogether added up to an evening at the opera that was ultimately pleasant and uplifting even despite the rough patches.