+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-07-15T13:38:00-04:00"
lastmod = "2017-07-16T21:38:00-04:00"
preamble = "Onstage at [The Santa Fe Opera](/scene/companies/the-santa-fe-opera/)'s 2017 season is Johann Strauss II's catchy classic, [*Die Fledermaus*](https://www.santafeopera.org/operas-and-ticketing/die-fledermaus) (running until **August 26**). Stage director and Opera Memphis General Director Ned Canty brings a new production to the Santa Fe stage, with a stellar cast that includes [Susan Graham](/scene/people/susan-graham/) (Orlofsky), [Jane Archibald](/scene/people/jane-archibald/) (Adele) and [Joshua Hopkins](/scene/people/joshua-hopkins/) (Dr. Falke).\n\nCanty chats about the juicy details - or \"the salt we add to the caramel\" - in a seemingly harmless piece like *Die Fledermaus*."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1500141458714/2017-07-17---Square-Fledermaus.jpg.jpg"
primary_image_credit = "Gabriel von Eisenstein (Kurt Streit) and the Santa Fe Opera Chorus. Photo credit: Ken Howard for Santa Fe Opera, 2017."
publishDate = "2017-07-16T21:27:00-04:00"
related_articles = ["articles/die-fledermaus-die-flederfabulous.md","articles/in-review-the-marriage-of-figaro.md"]
related_companies = ["scene/companies/the-santa-fe-opera.md"]
short_description = "&quot;We did try to find some nuance at the very end of the piece, making Rosalinda&#039;s forgiveness a little more hard won. In both operas, I believe that this &quot;one crazy night&quot; is the thing that the marriages needed to figure out that question of what is this marriage without children. (Yes, Mère Coupable exists, but I file it with Go Set a Watchman. In my heart and soul the Count and Countess fall back in love, and Atticus Finch is not a bigot.&quot;"
slug = "ned-cantys-die-fledermaus-a-pleasant-persistent-buzz-of-happiness"
title = "Ned Canty&#039;s Die Fledermaus: &quot;A pleasant, persistent buzz of happiness.&quot;"
+++

## Where does *Die Fledermaus* fall, between the spectrum of "serious opera" and "crowd-pleasing fluff"?

Hm. I'm not sure I can answer that question, as I would say there is a bit of an implied value judgment in it.  Does something "crowd-pleasing" make it "fluff", which sounds like it is somehow of less value? Certainly my primary goal is to give the audience a wonderful experience, but that is true of serious works I direct as well, not just comic ones. I also believe that joy and delight can be as cathartic as death and despair.  Maybe I should just say nobody dies?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1500141279198/2017-07-15---SFO-Orlofsky.jpg.jpg)
<figcaption>Susan Graham (Prince Orlofsky) and the Santa Fe Opera Chorus. Photo credit: Ken Howard for Santa Fe Opera, 2017.</figcaption>
</figure>
 
## What are some common misconceptions that many opera lovers may have about *Die Fledermaus*?

Perhaps a belief that there is only one verison of the show or dialogues?  There is more than one version of the former, due to lawsuits by Meilhac and Halévy over their play, *Le Réveillon*, being turned into an operetta without their consent.  There are dozens and dozens of versions of the dialogues.  Some use the dialogues from the original Viennese production, others are new versions of the same story.  This version uses dialogues adapted by Charles Ludlam from WS Gilbert's play *On Bail*, which was his translation of *Le Réveillon*.  (WSG did translations and burlesques of Offenbach, Donizetti, and others as well.)  

One thing that did come up was the notion that the piece is set on New Year's Eve, which several folks seemed to think.  While some versions of the dialogues might set it then in order to align with a New Year's performance, that is not in the original text.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/Z1IzKcpPW3w" frameborder="0" allowfullscreen></iframe>
</figure>
 
## How do you balance the humour in Strauss' piece with the more serious themes of social class and marital respect/infidelity?

This is a great question, because finding that balance is one of the biggest challenges of the piece. It is especially tricky with audiences who think of the work only in terms of the comedy, as their minds may already be set, so they may miss some of the smaller moments or subtle touches that are intended to add dimension and humanity.  I often talked about them as the salt we add to the caramel to make a richer taste. (And now I'm hungry...)

The themes of class primarily come into play with the satire of Eisenstein as social climber, someone who is looking for approval from those higher on the social ranks.  There are several moments at the party when Eisenstein is simply alone, with no one to talk to.  None of them are "in-your-face", but they are deliberately placed.   Orlofsky's "moral" is a bit more on the nose, as it is baked into the piece, namely that money can't buy happiness.  A life without struggle is, as Orlofsky puts it, boring.  I don't want to give anything away, but there is a thread throughout Acts 2 and 3 that developed with [Susan Graham](/scene/people/susan-graham/) in rehearsal that provides a bit more closure to this thread.  I wouldn't call it an Easter egg, exactly, but it all heads back to that "poor little rich boy" idea.  If everyone wants you for your money, how do you find someone to love you for you?

Regarding the infidelity, there was more thought and discussion, but again, mainly to provide flavor and contrast to the piece.  The comedy will always be 90% or 95% of the whole, with the more serious stuff as "marbling".  Earlier this season I directed *Marriage of Figaro* at my home company, Opera Memphis.  There are a surprising number of similarities between the pieces in respect to infidelity, which we used as a framework: 

1. Both parties in the marriage are tempted, whether by old paramours or new conquests.  While in each case the men are, perhaps, more wrong than their wives, no one is spotless.
2. I ofter referenced "The Piña Colada Song" with both pieces, since they all share the same plot.  A person is bored in their relationship, woos their current partner in disguise, thinking it is someone else, only to find that they were turned on by or connected to their original partner.  Furthermore, both the Countess and Rosalinda get into it!  The role play and disguises ingite/reignite something.  This is important because their is a third big part of this:
3. Both couples have been married for years, but neither has kids.  I'm often surprised when this is not brought up around either piece.  Huge differences, obviously, between the Spain of Figaro (or France of Beaumarchais) and the Vienna of Strauss (or France of M&H).  Still, in both cases marriage was about a lot of things--property, family alliances, social mobility-- but especially kids.  In both cases, assumptions would be that after a few years of marriage, there would be kids.  If there weren't, well, what is a marriage then?  What connects them? Now, this isn't to say we wanted to add a layer of sadness or melancholy by suggesting infertility, etc., just to say that there was a lot of time in both marriages that was not filled by kids, or work, etc. Time in which to think about old flames or past conquests.

One big difference we discussed, and one that [tenor] Kurt Streit and I agreed on, is that Eisenstein is more talk than action.  He and Falke are essentially frat brothers, trying to recapture their lost mojo.  That watch that Eisenstein used to wow the ladies with hasn't seen action in years.  And none of those ladies at the party would be anything more than a flirtation if that one sexy gypsy didn't come into the picture, and make him feel a much higher level of attraction than the others.

We did try to find some nuance at the very end of the piece, making Rosalinda's forgiveness a little more hard won.  In both operas, I believe that this "one crazy night" is the thing that the marriages needed to figure out that question of what is this marriage without children.  (Yes, *Mère Coupable* exists, but I file it with *Go Set a Watchman*. In my heart and soul the Count and Countess fall back in love, and Atticus Finch is not a bigot.  I'm a romantic.)

## What do you hope the audiences of Santa Fe will take away from your production of *Die Fledermaus*? 

- A sense of connection with each other, and delight in each other's presence.  
- A subtle but deep reminder that the things that make us laugh are the things that make us human, and more like each other than not.  
- A pleasant, persistent buzz of happiness that occasionally brings a smile to one's face, perhaps even days later.  
- And a new, perhaps more open-minded, point of view on the quantum nature of facial hair.

>Die Fledermaus runs at The Santa Fe Opera until August 26. For full details and ticket info, [click here.](https://www.santafeopera.org/operas-and-ticketing/die-fledermaus)
