+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2015-05-29T12:17:00-06:00"
lastmod = "2015-06-30T22:55:00-06:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1435622804229/Map.jpg.jpg"
publishDate = "2015-06-30T07:56:00-06:00"
related_articles = ["articles/6-learn-language.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/jonas-kaufmann.md","scene/people/diana-damrau.md","scene/people/plcido-domingo.md"]
short_description = "I can&#039;t vouch for native speakers of German, Italian, French, Russian, etc., but for singers whose first language is English, the idea of &quot;singing in one&#039;s native tongue&quot; is a frightful one. English can be a tricky language to sing, especially if you&#039;re born in North America. "
slug = "native-speakers-their-operatic-advantage"
title = "Native speakers &amp; their operatic advantage"
+++

I can't vouch for native speakers of German, Italian, French, Russian, etc., but for singers whose first language is English, the idea of "singing in one's native tongue" is a frightful one. English can be a tricky language to sing, especially if you're born in North America. Our vowels are dull, and there are lots of schwas replacing what could be lovely bright vowels (my name, for example is Jenna, often pronounced [dʒɛnə]).

There stereotype is that when singing in your first language, you sing with a lot of lazy, bad habits. I was curious about the "bad habits" that creep in with native Italians singing in Italian, Germans in German, etc. The first one that comes to mind is Pavarotti:

<figure data-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/-kbi1EMcD3E" frameborder="0" allowfullscreen></iframe>
</figure>

"Recitarrrrreh!" If you don't speak Italian, but you've studied Italian diction, you would have gotten slapped for this kind of thing. Same with the mumbly syllables he sings in between nouns and verbs. On the other hand, it's entirely conversational, which is certainly the point. Compare the ease of Pav with this recording by Jonas Kaufmann:

<figure data-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/9Ug8OdslZg4" frameborder="0" allowfullscreen></iframe>
</figure>

It's not bad, not bad at all. But comparatively, there's a bit more of a hitch, a deliberateness about the language that is a little less-than-natural.

Kaufmann has plenty of other strengths, though, like singing Wagner in his native German tongue:

<figure data-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/FioGST4B4Jg" frameborder="0" allowfullscreen></iframe>
</figure>

Compare that to Plácido Domingo's "In fernem Land," and you hear immediately the difference in detail. Domingo is incredibly expressive and thoughtful with his texts; you can hear, though, that he's missing plenty of opportunity for meaty German consonant-loving:

<figure data-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/syLhrx1Ogbo" frameborder="0" allowfullscreen></iframe>
</figure>

If we head over to French repertoire, we can hear French-speaking Roberto Alagna commit cardinal sin of uvular Rs in *Carmen*:

<figure data-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/P0tUnqvRanM" frameborder="0" allowfullscreen></iframe>
</figure>

Cardinal sin may it be, I definitely prefer uvular Rs *plus* linguistic ease to this recording of Jon Vickers', which feels comparatively over-thought and stilted:

<figure data-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/itB1UlPFln4" frameborder="0" allowfullscreen></iframe>
</figure>

Finally, we get back to English. Compare Natalie Dessay singing "Glitter and be gay"...

<figure data-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/bCg4r1Ile4w" frameborder="0" allowfullscreen></iframe>
</figure>

...to June Anderson's: 

<figure data-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/GcmAdS8vkDA" frameborder="0" allowfullscreen></iframe>
</figure>

If you can't hear the difference, you may want to get your ears checked. In this particular aria, English-speakers can hear the difference between singing syllables, and singing words; it translates into an easier, *funnier* performance. (Spoiler: this is probably how a lot of North-American Violettas might sound to native Italians.)

And just to prove that you're not entirely screwed if you're not a native speaker of your Italian/Russian/German operatic repertoire, here's Diana Damrau's "Glitter and be gay," which is entirely delightful (and clear as a bell):

<figure data-type="video">
<iframe width="854" height="510" src="https://www.youtube.com/embed/oByViX0t-IE" frameborder="0" allowfullscreen></iframe>
</figure>
