+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-08-02T12:22:00+01:00"
lastmod = "2016-08-05T12:58:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1470314151136/2016-08-04---Nate.jpg.jpg"
primary_image_credit = "Photo by Lindsay Sawyer."
publishDate = "2016-08-05T12:50:00+01:00"
short_description = "&quot;I know a lot of people that like to sing and play, but they don&#039;t really like it the way I like it,&quot; admits Douglas. &quot;If you really like something you&#039;ll just keep doing it. I didn&#039;t know how much I like it until really recently.&quot;"
slug = "nate-douglas-writing-songs-is-fun"
title = "Nate Douglas: &quot;Writing songs is fun.&quot;"
+++

"The best audiences are in Québec. There's something about French-Canadian culture, music, art, they just love it," says guitarist and singer/songwriter [Nate Douglas](http://www.natedouglasguitar.com/) of the Celtic fiddle music that takes up a sizeable slice of his performing schedule. Douglas has toured with the likes of fiddle greats Doug Leahy and [Natalie MacMaster](http://www.nataliemacmaster.com/), and he plays a mix of Celtic music and jazz/rock fusion with various bands around North America.

Based in Barrie, ON, Canada, Douglas is in a different world than most of the folks we interview here at Schmopera; he grew up in a musical family, one that included lots of exposure to classical music. (\*Moment of honesty from the editor: Nate is my brother - hence the familiar last name - and not only am I insanely proud of him, but I've been eager to share his views of the music industry from a vantage point outside of the opera world.)

Douglas' studies included classical guitar at Western University, and all the trusty music theory that went along with it. And while he's pursuing a career in not-so-classical genres of music, there are some universal truths about musicians of all ilks.

One of these universal truths: a life on the road. "I really like playing live with good musicians, and wherever that takes me, then I'll do it," says Douglas of the tricky touring life of a working musician. "The touring is like a way for me to do that. If I could do that at home, I'd much rather do all the gigging with good musicians at home, but you can't."

As any would-be professional musician quickly finds out, making a career out of music takes more than great chops. Douglas relishes the different audiences around Canada and the United States, and he embraces the chance to "see cool places" that the average tourist wouldn't necessarily see. "I find the coffee shops are actually my favourite thing," he says; the "little hipster spots" scattered across the continent are his chance to find solace and a bit of routine away from home.

Ah, solace. It's an elusive treat for musicians on tour. "Sometimes you just don't have alone time," adds Douglas. "You're in the van, and then it's straight to the venue, sound check with everybody, eat dinner with everybody, and then you drive back to the hotel and you're sharing a hotel room with somebody."

Douglas agrees that the *en masse* schlepping from gig to gig is something that "tests your patience." Yet, he's grown to master the art of alone time, even when he's not alone. Before a gig, "I just find an area in the auditorium that's alone, a little corner in the top row or something, and just chill, do nothing." And in the inevitable cases where his plans for solitude are thwarted, Douglas finds the silver lining. "You learn to become really tolerant of not only people, but later when you're not on tour, you're a bit more tolerant in general of shit that happens."

Douglas uses what he calls the "gig triangle" to determine whether or not he takes the job and risks the uncertainty of nomadic life for the joy of making music. "You need two of the three points in order to take the gig. It's good money, good people, good music. If you have two, then you should do the gig. If you only have one, it's not good." For him, the triangle isn't entirely equilateral. "I think the people side of it has more weight," he agrees. 

Still, for Douglas, and the *many* artists who have their preferred ways to be refreshed and ready for a performance, time alone is still invaluable. He puts it simply enough: "You just do it, even if you look like a dick."

## Staying connected to home

As a married man, Douglas is constantly balancing the attention he gives to his work on the road, with the attention he gives to his relationship with his wife at home. "We try to connect as much as we can," he explains, "but still, it's hard to have a routine when someone's gone."

As difficult as the weeks and months apart are, the trickiest times can come when he returns home. "When I come back, there's always that week of re-adjusting to that life again. I probably act slightly off, or not myself; even if I don't mean to be, I'm just not in the right head space to be home again." 

The time in a tour van with fellow band members is a stark difference from being in a familiar place with the people closest to him. Douglas recalls feelings of "ok, what am I supposed to be doing right now?" as odd symptoms of returning-home syndrome. "You kind of forget who you are, and you're questioning all of your actions because you haven't done them in a while." Both he and his wife have learned to recognize this transition period, and they've found that laughing it off is the best way for both of them to find their way back to their domestic routine. 

Professional musicians know that the love of their work is incredibly strong, and it can be unnerving to achieve such heights of musical satisfaction without their loved ones around to share the experience. "It's a double life," Douglas explains. "It's hard because you have so much fun and you experience such musical joy - best gig of your life - and then three days go by, four days go by, and you finally talk to her, and she says 'Oh, how was that one gig?' And all you can think of is, 'Oh it was good, good crowd,' and you can't really share that."

And when his wife can make the trip to hear him play? "You almost don't even need to talk about the gig after," says Douglas, "because you were both there, you both lived it."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1470315191800/2016-08-04---Nate-Recording-Collage.jpg.jpg)
<figcaption>Clockwise from top left: Nate Douglas, Tom Fitzgerald, James Law, and Tara Douglas, recording at Phase One Studios, Toronto, 2016. Photos by Lindsay Sawyer.</figcaption>
</figure>

## The adventure of singing

"I started maybe 6 years ago," says Douglas of his fairly recent forays into singing. A guitarist first, his early gigs at pubs consisted of him and a fiddle player, playing instrumental Celtic music. "No singing, just tunes for like 5 hours."

After getting increasing feedback from listeners ("Hey man, sing us a song!"), Douglas decided that "Sorry, I don't sing" wasn't a great excuse after all. "Eventually it just bugged me, like, 'yeah, why don't I just sing?'

He began working on a few cover songs to sing ("really badly for the first couple times"), and tried it out in a safe environemnt. "In a bar, no one's really looking at you. They're not sitting down and watching you, they're there to drink beer and eat wings." Douglas recalls the relative invisibility of the pub performer as the initial confidence boost to try out his singing in public. "You sing your first song, and you look around when it's over, and nobody's even looking at you. And that was the best. That was exactly what I wanted," he laughs. "And then it eventually gets fun. Once you're comfortable with your own voice it's kind of fun."

He admits to having "bad technique" at the start, struggling with projection of low notes, a problem stemming from the fact that "I didn't know what I was doing."
Even with a [professional singer as a mother](/talking-with-voice-teachers-or-meet-my-mother/), and a sister who works with opera singers, there were discoveries that Douglas made about singing as he did it more and more. "Singing higher than you feel comfortable is always better in a bar," he offers. "When you work on things at home, it's quiet, you're in your living room. So you can sing lower, or in more of your speaking tone, and it's comfortable at the time." 

"So I would put things higher than I think I could do it. It's in your sweet spot more - you can project."

Douglas also discovered singing to be a "natural way of making music," noting the difference in how a melody sounds on a guitar, versus in the voice. "Things sound so much better sung, I think, than played," he adds. "When you sing, you sing the simplest thing, just a stepwise little small melody, and it sounds so much better than anything."

## Making music of his own

"I care so much more," Douglas says of his latest project, an album of his own original songs. The still-to-be-named album, set for release in January 17, features Douglas on guitar and vocals, Tom Fitzgerald on fiddle, James Law on drums/percussion, Andre Blais on electric bass, Julian Anderson-Bowes on upright bass, Lindsay Sawyer on backup vocals, and Douglas' wife, Tara Douglas, on piano and backup vocals.

"When it's your own thing, I totally feel different," says Douglas. "You're actually singing about something for the first time, ever."

Compared to the how-to guide for writing music in operatic circles, Douglas' method is decidedly backwards. For him, the words are the last ingredient in his songs. "I'll come up with a little groove or chord thing on the guitar, and record it on my phone. Then I'll sing a melody over it," he explains. "I'll just start writing words that fit the rhythm of that melody. And then the song becomes about what ever it's about." 

Classical singers are used to the concept of the music's being a product of the text; yet for Douglas, his lyrics are a malleable element of his music. "If they don't line up [with the music], I'll change the words to fit the melody."

Douglas likens his songwriting method to the music of his favourite band, Radiohead. "You can't hear a thing Thom Yorke is saying. It's just another instrument in the band, his voice, it's another layer. I love that, and I think the lyrics are important but they're not the most important part."

Listeners latch on to different elements of a song, Douglas has learned. "I think some people only connect to lyrics, and that's fine; some people only like the rhythm and the groove and beat. Other people like harmony." For him, they're all valid ways to enjoy music, and to take in his songs. "I can't wait to perform them," he smiles. "I've been playing so many tours and gigs with other bands, playing their music, and it's fulfilling, but not as much as doing my own stuff. Even playing my own stuff at the bar is really fun."

"I think deep down, it sounds selfish, but it's for me. I just love it. I love playing, and singing with the band. And if people like it, sweet, that's awesome. but I almost don't care if they like it or not." In the recording studio, Douglas has found huge satisfation in the process. "The most rewarding part was when I got the first mixes back. The idea in your head, that you've had for so long, actually sounds like that," he recalls. "Your idea is becoming a reality - it's so much fun."

Douglas calls it "a bonus" when he gets positive feedback about his music. It's no small achievement, for a musician to release himself from the urge to please his audience; yet without that external pressure, an artist is left with a singular motivation for his work: total love for the process.

"I know a lot of people that like to sing and play, but they don't really like it the way I like it," admits Douglas. "If you really like something you'll just keep doing it. I didn't know how much I like it until really recently."

"Writing songs is fun."

>This month, Nate Douglas joins The Fitzgeralds at the Iowa Irish Festival and the Northern Lights Bluegrass Festival in Saskatchewan. [Click here](http://www.natedouglasguitar.com/#!calendar-1/ujsk7) for more dates, & follow him on [Twitter](https://twitter.com/natedouglas87) to stay in the loop.
