+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-06-06T22:22:00-06:00"
lastmod = "2017-06-08T22:55:00-06:00"
preamble = "This month, [Opera 5](/scene/companies/opera-5/) presents a double-bill by \"opera's original nasty woman\", Ethel Smyth. Before last season's production of Kaija Saariaho's *L'amour du loin*, Smyth's opera *Der Wald* held the title of the most recent opera composed by a woman to be performed at the Metropolitan Opera - and it went up [over 100 years ago](/teddy-roosevelt-the-chicago-cubs-operas-by-women-at-the-met/). Perhaps more interestingly, Smyth lived a life of political activism, fighting fiercely for women's rights. \n\nSmyth's operas *The Boatswain's Mate* and *Fête Galante* make up Opera 5's production of [*Suffragette*](http://opera5.ca/project/suffragette-details-announced/), directed by [Jessica Derventzis](/scene/people/jessica-derventzis/); the double-bill runs at Theatre Passe Muraille, **June 22-25**. We spoke with Derventzis and Opera 5 co-founder and General Director [Rachel Krehm](/scene/people/rachel-krehm/) about feminist operas, and the strong female leadership of Toronto's opera and classical music scenes.\n\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496809007060/2017-07-07---SUFFRAGETTE_POSTCARD.jpg.jpg"
publishDate = "2017-06-08T21:27:00-06:00"
related_articles = ["articles/thomas-paine-in-violence-must-be-witnessed.md"]
short_description = "&quot;Seeing women at the forefront of so many of the indie opera companies here in Toronto is thrilling. Everyone is doing work that is pushing boundaries, poking at that glass ceiling, and making art that is interesting, exciting, and creative. To see the women responsible for that art, starting their own companies and beginning from nothing, it&#039;s truly inspiring.&quot;"
slug = "nasty-women-great-operas-opera-5s-suffragette"
title = "Nasty women, great operas: Opera 5&#039;s Suffragette"
+++

## What are you most excited about in presenting this double-bill in Toronto?

**Jessica Derventzis**: I am most excited to bring Ethel Smyth's works to light and showcase what this amazing woman wrote for the Toronto audience. These pieces show her very clear voice and fascination with society in the early 1900s. She was a spitfire of a woman, and that is very evident in her writing. Mrs. Waters, who is the main character in *The Boatswain's Mate*, reminds me of the type of woman that I imagine Smyth was. She is full of fire and passion and she stands up for what she believes in. 

*Fête Galante* is a beautiful piece that is complex, layered, and masterfully written. The music in both pieces is quintessentially British which tells me that Dame Smyth was a very proud and patriotic woman. I hope that people leave wanting to find out more about Dame Smyth - the person and composer.

## Dramatically, how have you approached these two operas, and the common theme between their stories?

**Jessica**: Outside of a lot of partying! good times! and drinking! the common thread between the two pieces that I am aiming to showcase is how societal perceptions remain the same and/or change in different environments. 

Ultimately, both the two main male characters, Harry Benn the *Boatswain* and the King in *Fête Galante*, believe that their respective way is the only way, and there is no room or necessity for change. How does a society evolve when some don't believe it needs to? 

In terms of style, narrative, and genre, both operas are vastly different. With *Fête Galante*, it is a throwback to the *commedia dell'arte* movement set in a lavish garden party hosted by the King and Queen that revolves around two intertwining love triangles. What we are ultimately trying to portray with this opera is celebrity worship and obsession with royalty, keeping up appearances, and how society can be manipulated, like puppets. My gut reaction from reading the libretto the first time was a sense of throwback to the Sex Pistols' punk anthem "God Save the Queen." From there, Erin Gerofsky (our set and costume designer) and I decided that if we set this in the 1970s in England, at the height of punk, rock 'n roll idols, mod fashion, in an elite garden party, we could be on to something with showing this story in a new light.

*The Boatswain's Mate* is a more straightforward piece about a fantastic woman, Mrs. Waters, constantly having to hold her own against the "gentlemen" who come around to drink at her bar and propose to her, all shown in a farcical manner. This piece is less cosmopolitan and more rustic. Design-wise we are moving into the late 70s/early 80s and showing the opposite side of society from those in Fête Galante. These guys are former soldiers, sailors, and labourers who have paid their dues to society and stop in for some drinks every night. Mrs. Waters is an exceptional woman who holds her ground amid this chess game of men thinking that they could run the bar better than she could, or worse, that she NEEDS them to run to bar.  

We are tying both shows together through a number of design elements as well. See if you can spot the similarities when you see the show!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496809433370/2017-06-07---Jess-Derventzis-Headshots_037.jpg.jpg)
<figcaption>Jessica Derventzis, Opera 5 Production Manager and Stage Director.</figcaption>
</figure>

## Aside from her history with the Metropolitan Opera, what do you think is interesting about Dame Ethel Smyth?

**Jessica**: Dame Ethel Smyth's bad-assery knows no bounds. She was arrested after throwing bricks through politicians' windows in the name of women's suffrage. She even combined her passion for politics and music, writing what became the anthem for women's suffrage ["March of the Women"](https://www.youtube.com/watch?v=qTYv4wT8g4E) which she was spotted conducting through her jail bars with a toothbrush while she was in prison. Every aspect of her life is fascinating and I would have loved to take her for a beer and hear her stories. I'm sure there are so many that have not been published which would stir up the patriot, the feminist, and the human rights activist bones in anyone.

**Rachel Krehm**: There is a really excellent radio documentary about her that can be found [here](https://archive.org/details/DAMEETHELSMYTH). It has so many stories that shows just what an accomplished, bold woman she was. Despite being championed by both George Bernard Shaw and Thomas Beecham, she received harsh criticism about her music (mostly tied to her gender) often explaining why "a female mind is deficient to write music, some describing her music as overly emotion and too feminine" while others felt it to too "masculine" for a woman. One of my favourite sections from a critic in the newspaper *The World* about her *Der Wald* premiere at the MET reads, "Her work is utterly unfeminine. It lacks sweetness and grace of phrase. Wagner was never so ruthless in his treatment of the human voice."

What I find most intriguing about Smyth's music is that she has an amazing sense of drama and storytelling, and she knows when to go from the ridiculous to the sublime. This to me is the mark of a fine composer who deserves a platform to be heard.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496809421420/2017-06-07---Rachel-Krehm-headshot.jpg.jpg)
<figcaption>Rachel Krehm, Co-Founder and General Director of Opera 5.</figcaption>
</figure>

## How unique is Toronto's opera scene, with its large representation of women in creative and leadership positions? Where do you find there still exists an imbalance?

**Jessica and Rachel**: Seeing women at the forefront of so many of the indie opera companies here in Toronto is thrilling. Everyone is doing work that is pushing boundaries, poking at that glass ceiling, and making art that is interesting, exciting, and creative. To see the women responsible for that art, starting their own companies and beginning from nothing, it's truly inspiring.

We think the rest of Canada could take a look at what is happening in Toronto and open their doors to more women in all leadership aspects: directing, conducting, artistic direction, design and administration. There are some great examples of women taking the lead in many organizations: Tania Miller just finished a 14 year tenure with Victoria Symphony. Gemma New is the Music Director of the Hamilton Philharmonic. Rose Thomson has been Music Director of the Okanagan Symphony since 2007. Vancouver Opera is celebrating its first season with Kim Gaynor as its leader. Barb Montalbetti has been Artistic Director of Saskatoon Opera since 2000. Judith Yan is the Music Director of the Guelph Symphony and Mélanie Léonard is the Music Director of the Sudbury Symphony. 

Other women around the country have created their own companies: Michelle Minke founded Cowtown Opera, Alexandra Kosachukova Babbel founded Opera Kelowna and Janna Sailor has founded Allegra Chamber Orchestra, an all-female orchestra in Vancouver. That is a list of six women hired into music organizations to lead and three others who have started their own companies. 

We are sure that we are missing a few women classical music leaders in Canada besides those leading the companies of Indie Opera TO, but it is troublesome that we can name fewer female leaders in the industry in Canada than in the Indie Opera TO leadership. It is time to see more women running administration, artistic and musical direction of classical music organizations in Canada.

>Suffragette runs June 22-25 at Theatre Passe Muraille. For full details and to purchase tickets, [click here.](http://opera5.ca/project/suffragette-details-announced/)
