+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2017-10-15T19:07:00-04:00"
lastmod = "2017-10-15T22:55:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508110142322/2017-10-16---square---nab_3005pr.jpg.jpg"
publishDate = "2017-10-15T21:07:00-04:00"
related_articles = ["articles/la-opera-scores-in-first-half-of-bizet-doubleheader.md","articles/nashville-operas-carmen-she-dies-because-she-told-a-man-no.md","articles/placido-baritones-ripple.md"]
related_companies = ["scene/companies/los-angeles-opera.md"]
related_people = ["scene/people/plcido-domingo.md","scene/people/morris-robinson.md","scene/people/liudmyla-monastyrska.md","scene/people/mario-chang.md"]
short_description = "Yes, there was a Verdi opera somewhere in those three and a half hours - and we got to see brilliant flashes at times of what the show should and could have been - but mostly we had to wade through a lot of concept and conceit to get there. It wasn&#039;t until Act IV (the final act) that our wishes came true: singing, acting and staging that actually touched the audience, and touched us deeply."
slug = "nabucco-is-hard-to-find-in-the-latest-la-opera-production"
title = "Nabucco is hard to find in the latest LA Opera production"
+++

A friend texted me as she was leaving the LA Opera production of [*Nabucco*](https://www.laopera.org/season/1718-Season/Nabucco/) and asked if I could explain the curtain call. The curtain call took some deciphering but it was simply the capper to a production that shouldn't have been called *Nabucco*, but rather "An Evening with Director Thaddeus Strassberger." 

Yes, there was a Verdi opera somewhere in those three and a half hours - and we got to see brilliant flashes at times of what the show should and could have been - but mostly we had to wade through a lot of concept and conceit to get there. It wasn't until Act IV (the final act) that our wishes came true: singing, acting and staging that actually touched the audience, and touched us deeply. By then, the character Nabucco had gone insane, but the director suddenly regained his senses (only to lose them again during the curtain call which was so long it almost became Act V.) 

The success of this final hour or so was due in large measure to the presence of [Plácido Domingo](/scene/people/placido-domingo/), in the title role. Considered by many - and rightly so - to be one of the greatest tenors who ever lived, he reinvented himself a few years ago as a baritone (ironically, he originally trained to be a baritone) and for the past five years, he has specialized in Verdi. He has stated that he was drawn to Nabucco because of "the mad scene" but it's the aftermath of that scene where Domingo demonstrates he is still a great singer and actor. At the age of 76, after six decades and almost 4,000 performances on the opera stage, he's at the age when most Shakespearean performers tackle King Lear. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508111511379/2017-10-16---nab_2538pr.jpg.jpg)
<figcaption>Plácido Domingon (Nabucco) and Liudmyla Monastyrska (Abigaille) in *Nabucco*, LA Opera, 2017. Photo: Ken Howard.</figcaption>
</figure>

Story-wise *Nabucco* is the operatic equivalent. As Nabucco, Domingo alternates between hot anger and child-like pathos as he ponders the loss of his kingdom, and later, the death of his daughter. In the Act IV jail scene he commands the stage even while lying completely prostrate. Domingo still has plenty to give an audience - and judging from the ovations, the audience here in Los Angeles is especially appreciative. (Domingo will be performing a solo concert on November 17th here to celebrate the 50th anniversary of his first performance in L.A.)

Unfortunately, up until the jail scene, Strassberger continually and deliberately distracted us from Verdi's music and, more importantly, from Verdi's intent.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508111556727/2017-10-16---nab_0210pr.jpg.jpg)
<figcaption>(l-r): Mario Chang (Ismaele), Liudmyla Monastyrska (Abigaille) and Nancy Fabiola Herrera (Fenena) in *Nabucco*, LA Opera, 2017. Photo: Ken Howard.</figcaption>
</figure>

*Nabucco* is early Verdi and, in a lot of ways, late Donizetti. It's more like *Lucia di Lamermoor* than *Rigoletto*, *La traviata* or many other Verdi masterpieces that were to follow. It's a solid work with several great roles and many wondrous moments for a great chorus. Once again - and always - the LA Opera chorus was stellar. Their harmonies wash over the audience in tidal waves of glorious sound. Their *a cappella* moment (sung along with the principals) in the final minutes of the production is breath-taking. Credit Chorus Director Grant Gershon and conductor James Conlon who leads the ever-flawless orchestra.

*Nabucco* is the biblical story of Nebuchadnezzar, considered the greatest King of Babylonia, who destroyed the Temple of Solomon in the kingdom of Israel and exiled the Jewish people from their ancestral homeland. Director Strassberger makes it clear from the overture that he doesn't think the opera can stand on its own. (This in spite of the fact that it has been revived for 175 years.) The action is based on historical events from around 562 BCE. However, during the overture we're introduced to supernumeraries from the year 1842 (as in CE, not BCE.) A lamplighter in powdered wig and buckled shoes enters the stage and we get to watch a "thrilling" spectacle as he lights each of the dozen or so footlights. He then has to go back and "comically" re-light one of the lamps that has gone out. The director isn't setting the table for a heart-wrenching story - he's clearly off in his own world. 

After the lamplighter, 19th century aristocrats enter the stage dressed in elegance designed by the talented costume designer Mattie Ullrich. At least one couple is clearly royalty. They proceed to a three-tiered section of opera boxes that have been erected on the side of the stage. There are also carbineris who march in with their rifles ready and stand at attention. All this while the iconic overture is playing. "Don't listen," Strassberger seems to be saying - "I have a better idea." Strassberger's Brechtian concept is obvious: he's telling us "it's just an opera - don't get too involved." And for most of the evening we don't.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508111567631/2017-10-16---nab_2707pr.jpg.jpg)
<figcaption>Liudmyla Monastyrska (Abigaille) in *Nabucco*, LA Opera, 2017. Photo: Ken Howard.</figcaption>
</figure>

The denizens of the fake opera boxes are there for the entire show, fanning themselves, checking their programs, looking out at the audience with their opera glasses, etc. They can't be ignored even during the most dramatic moments of the opera and, as a result, much of the drama is sacrificed. They're even used as a comic gag during what's supposed to be Abigaille's agony in her aria "Anch'io dischiuso." It must be noted here that [Liudmyla Monastyrska](/scene/people/liudmyla-monastyrska/) as Abigaille is a superb soprano with no limits - she plays the queen of the Babylonians but she's also the queen of the cadenza. [Morris Robinson](/scene/people/morris-robinson/), as the basso character of Zaccaria, powerfully commands the other end of the vocal spectrum and the two manage to stand out from all the directorial nonsense thanks to their prodigious talents. [Mario Chang](/scene/people/mario-chang/) is excellent as Ismaele, one of the most underwritten tenor roles you are likely to find.

Designed by director Strassberger, the sets are painted backdrops with forced perspective - something you'd no doubt see if you were attending the show at La Scala in the 1800's (the show was first presented in 1842.) One of the flats is of a lions' den - a nod to one of the libretto's sources, The Book of Daniel. Strassberger feels the need to surround the flat with a thick picture frame in case we were worried that somehow the lions were dangerous. It's not enough for Strassberger to have the real curtains of the Dorothy Chandler Pavilion - he has also painted another set of curtains on this and every backdrop, lest we forget for a moment that we're in the theatre and heaven forbid we should be carried away by the performances.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508111578349/2017-10-16---nab_2928pr.jpg.jpg)
<figcaption>Liudmyla Monastyrska (Abigaille) in *Nabucco*, LA Opera, 2017. Photo: Ken Howard.</figcaption>
</figure>

Strassberger is also fond of upstaging his singers and often draws us away from the music with superfluous stage movement. For example, the character of Fenena (a first-rate performance from Nancy Fabiola Herrera) wriggles beneath a bloody sheet while we're supposed to be paying attention to the solo of Zaccaria. 

The truly worst choice by Strassberger was to completely upstage the most famous number in the show, "Va, Pensiero." Verdi clearly meant this to be a vitally important moment. We're supposed to be concentrating our attention on the chorus of Hebrews and sympathizing with their lament; they've lost everything at this point. Strassberger decided we shouldn't be looking at the singers and instead he forces us to watch what's going on "backstage." We see people sewing costumes and basically taking a break; some are smoking, some in half-changed costumes. One large round set piece actually blocks a portion of the chorus as stage hands spend a long time placing lights inside the set piece and hoisting it into the air.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508111631733/2017-10-16---nab_1583pr.jpg.jpg)
<figcaption>(l-r): Mario Chang (Ismaele), Morris Robinson (Zaccaria), and Nancy Fabiola Herrera (Fenena) in *Nabucco*, LA Opera, 2017. Photo: Ken Howard.</figcaption>
</figure>

After you attend this production of *Nabucco*, you'll probably want to go to a different opera company and see what you missed.

[*Nabucco* continues its run](https://www.laopera.org/season/1718-Season/Nabucco/) 11/2, 11/5, 11/8, 11/11 and 11/19.
