+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2014-07-28T10:00:00-04:00"
lastmod = "2015-04-23T14:30:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429813717099/Met.jpg.jpg"
publishDate = "2014-07-28T10:00:00-04:00"
related_articles = ["articles/idealism-questions-unions.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md"]
short_description = "If you&#039;re reading this, you&#039;re probably already aware that the Metropolitan Opera is in trouble. This Thursday, the contracts of 15 unions are set to expire, and the negotiations between the unions and the Met&#039;s general manager, Peter Gelb, seem to be going nowhere good."
slug = "mutiny-at-the-met"
title = "Mutiny at the Met?"
+++

"We are willing to tighten our belts if Peter Gelb is willing to cut up his credit cards," [says Joe Hartnett of IATSE](http://www.burlington-record.com/burlington-sports/ci_26215053/lockout-looms-met-contracts-set-expire). "It's more than just our labor costs that's the problem."

If you're reading this, you're probably already aware that the Metropolitan Opera is in trouble. This Thursday, the contracts of 15 unions are set to expire, and the negotiations between the unions and the Met's general manager, Peter Gelb, seem to be going nowhere good. A strike ([or lockout](http://online.wsj.com/articles/the-future-of-opera-1405641354), depending on which way you look) is looming, and it would delay or cancel the 2014/15 season set to start in September. Gelb has proposed cuts totalling $180 million (or roughly 16%) from the compensation of the chorus, orchestra, stage management, carpenters, stage hands, set designers, costume shop workers, stylists, ticket sellers and broadcast technicians. The cuts affect these employees' net pay, overtime, benefits, and pensions; members of some of the troubled unions say that after all the math is done, [the 16% will be closer to 30%](http://www.amny.com/news/metropolitan-opera-contract-negotiations-with-unions-drag-on-1.8859772).

Under Peter Gelb, the Met's annual budget has grown by over 50%; he doubled the amount of productions per season and introduced [Live in HD,](http://www.metopera.org/metopera/liveinhd/live-in-hd-2014-15-season) broadcasting selected live performances to movie theatres around North America. Say Gelb, "When I took over the Met, the budget was about $200 million a year and we invested in new efforts to help make the opera more accessible and more successful." But the math of it all says Gelb simply didn't succeed. 

[Click here](http://www.local802afm.org/MetMusicians/2014-07-25_802-Presentation_Gelb.pdf) to read the fascinating breakdown of pre- and post-Gelb success, posted by Local 802, American Federation of Musicians. They measure reviews (most reflect well on the orchestra and singers, and poorly on the productions), and ticket revenue from Gelb revivals like the [Robert Lepage _Ring Cycle_](http://ringcycle.metoperafamily.org/)  (most take a clear nosedive after their opening runs).

And [he spent $169, 000 on a poppy field](http://peoplesworld.org/metropolitan-opera-unions-say-they-are-being-forced-to-strike/) for _Prince Igor_. Come on.

Now, when I look at the union stipulations currently in place, a few things make my eyebrows raise. For example, the chorus earns overtime for singing in an opera that lasts longer than four hours, meaning that Wagner can be a nice chunk of extra change. They're paid for 4 performances a week, and get compensated extra for rehearsals, even if they've only sung 3 shows that week. The orchestra musicians are among the most highly-compensated in the country, including anywhere between 10 and 16 weeks off per year, _paid_. The chorus and orchestra both get extra pay for appearing in the Met's cinecasts.

As a fairly young member of the opera industry, I often find it hard to sympathize with many of the Met's union stipulations. The idea of getting benefits and pensions with your _salary_ is pretty foreign to me, but I will be careful not to write out of envy. As with any industry, unions are good for securing jobs, but not good at promoting creativity. Stipulations, like these, that don't allow for time spent on _making a good product_ are short-sighted and anti-creative.

I won't say the orchestra and chorus don't work hard for their money; they _absolutely_ do. And it's clear that Peter Gelb has now stretched the allowances within these unions over too many productions, too many of which simply haven't earned the interest of audiences or the respect of critics. It seems that on the management's side of things, the unfortunate truth is that _ego_ is in the way. It must be insulting to the creative team that actually put up Gelb's product to be expected to bear the first brunt of financial mess. Local 802 writes on their [website](http://www.local802afm.org/metorchestra/), "Even if—after an objective analysis—the Met can be said to be facing some degree of financial challenge, it is clear what the solution isn’t. It isn’t slashing the compensation of the world-class performers and other craftspeople on whom the Met’s excellence and success relies."

It's a messy fight, and one with a rapidly decreasing time-line. The American Federation of Musicians [recently posted on their Facebook page](https://www.facebook.com/schmopera/posts/296341313871750), voicing their dismay at the apparent stand-still in union negotiations with the Met's management. The [Met has responded](http://www.broadwayworld.com/article/Metropolitan-Opera-General-Manager-Peter-Gelb-Threatens-Lockout-and-Cancellation-of-Season-20140723#.U9KEwIBdXm4) in a frustratingly stubborn statement: "We remain hopeful that the unions representing Met employees will recognize their need to share in the institution-wide cost controls we are proposing, and will reach an agreement before the contract expires on July 31\. We hope to avoid any work stoppage and continue preparations for our season opening on Sept. 22."

Hope all you want, Mr. Gelb, but first leave your ego at the door. If your artistic vision depends on behemoth-like "machines" ([*Ringcyclecough*](https://www.youtube.com/watch?v=4R_kcWP0_SE)), pricey poppies and quantity of productions masked as quality, then no artists can carry that out for you. Certainly not after you take the first budgetary swipe at the most creative people in that big ol' building of yours.
