+++
author = ["authors/jenna.md"]
categories = "News"
date = "2017-08-17T10:03:00-04:00"
lastmod = "2017-08-30T09:52:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502986825287/2017-08-18---Square---MozartVsMachine_Folkestone_034.jpg.jpg"
primary_image_credit = "Mozart vs Machine dress rehearsal. Folkestone Quarterhouse. 3 February 2017. Photo: John Stevens/ Qu Junktions."
publishDate = "2017-08-20T20:07:00-04:00"
related_articles = ["articles/actual-opera-buzz-the-swarm-in-review.md","articles/opera-and-scifi-the-puritan-intersection.md"]
related_companies = ["scene/companies/mahogany-opera-group.md"]
related_people = ["scene/people/frederic-wakewalker.md"]
short_description = "&quot;On one level, it feels very much like a musical cabaret-revue,&quot; says Wake-Walker, who directs Mozart vs Machine. &quot;There is a narrative, there is a story that is told, but not in a traditional sense.&quot; That loose narrative tells of a malfunctioning time-machine, resulting in a chance meeting between Raymond Scott, early pioneer of electronic music, and Wolfgang Amadeus Mozart."
slug = "mustsee-mashups-mozart-vs-machine"
title = "Must-see mash-ups: Mozart vs Machine"
+++

"It's sort of an information overload," says stage director [Frederic Wake-Walker](/scene/people/frederic-wake-walker/) of Mahogany Opera Group's touring production of [*Mozart vs Machine*](https://www.mahoganyoperagroup.co.uk/productions/mozart-vs-machine/). "It's almost like the whole piece is a theatricalised version of what we do when we're just flicking through Twitter and YouTube."

Described as an "electronic essay collage opera", the piece by composer Dominic Robertson was developed through Mahogany's [Various Stages](https://www.mahoganyoperagroup.co.uk/productions/various-stages) programme. It's a multimedia mash-up of Mozart and electronic music, and places two major musical figures in a "theatrical sci-fi-gameshow encounter".

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502986943659/2017-08-18---MozartVsMachine_Folkestone_091.jpg.jpg)
<figcaption>*Mozart vs Machine* dress rehearsal, Folkestone Quarterhouse, 3 February 2017. Photo: John Stevens/ Qu Junktions.</figcaption>
</figure>

"On one level, it feels very much like a musical cabaret-revue," says Wake-Walker, who directs *Mozart vs Machine*. "There is a narrative, there is a story that is told, but not in a traditional sense." That loose narrative tells of a malfunctioning time-machine, resulting in a chance meeting between Raymond Scott, early pioneer of electronic music, and Wolfgang Amadeus Mozart.

Robertson's work is a surreal combination of live and pre-recorded music, shadow puppetry, and video images. "It's really asking a question about authorship," adds Wake-Walker, who like Robertson, sees a stark difference between the idea of the artist in the 18th century - the "genius" of Mozart, for example - and in the present. With so much art being created and with creative tools so universally accessible, it's as though "we're all artists."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502986954023/2017-08-18---MozartVsMachine_Folkestone_235.jpg.jpg)
<figcaption>*Mozart vs Machine* dress rehearsal, Folkestone Quarterhouse, 3 February 2017. Photo: John Stevens/ Qu Junktions.</figcaption>
</figure>

For Wake-Walker, one message of *Mozart vs Machine* is the idea that the writing of something entirely new and original is actually a wasted act." Instead, there's creativity in what Robertson has done with his collage opera, taking pre-existing material and re-purposing it. "It irreparably rips up the traditional canon, and takes the most famous aria by Mozart, and chops it up, bar by bar."

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/zluay87Q6Kw" frameborder="0" allowfullscreen></iframe>
</figure>

The show's title seems to refer most closely to the conversation that Raymond Scott has with Herr Mozart. "Mozart is arguing that the humans are the ones who can create music; Raymond Scott is arguing that machines can do them one better," says Wake-Walker. 

To generate music, Scott experimented with sounds that were seemingly random; Mozart too was not without his external influences, including the clicking sounds made by billiard balls at play, which inspired some of his "human" music. "By the end of the conversation, they realize that they're actually saying the same thing."

"And then they make love, and give birth to John Cage." Naturally.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1502986978247/2017-08-18---MozartVsMachine_Folkestone_142.jpg.jpg)<figcaption>*Mozart vs Machine* dress rehearsal, Folkestone Quarterhouse, 3 February 2017. Photo: John Stevens/ Qu Junktions.</figcaption>
</figure>

[*Mozart vs Machine*](https://www.mahoganyoperagroup.co.uk/productions/mozart-vs-machine/dates-tickets/) tours from **September 17 to November 15**, stopping in Bristol, Aldeburgh, Birmingham, Exeter, Aberdeen, the Norwich Arts Centre and London. You can find full details and ticket information by [clicking here.](https://www.mahoganyoperagroup.co.uk/productions/mozart-vs-machine/)
