+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-08-03T04:11:00-04:00"
lastmod = "2017-01-02T20:35:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1481457239188/2016-12-11---Fog.jpg.jpg"
publishDate = "2016-08-07T13:44:00-04:00"
related_articles = ["articles/the-opera-posse-phenomenon.md","articles/artists-administration-reputations.md","articles/substance-abuse-in-the-opera-industry-yup-but-why.md","articles/operas-sexual-assault-secret.md","articles/some-uncomfortable-questions-about-the-levine-business.md"]
short_description = "Jokes about double-entendre music terms (&quot;fingering,&quot; &quot;tongue tension,&quot; &quot;G-string,&quot; etc.), invasion of personal space (teaching by demonstration), and (perhaps) innocent flirting; all of these commonplace pieces of sexual harassment are perhaps more dangerous when combined with a captive audience of sorts."
slug = "musicians-sexual-harassment-blurred-lines"
title = "Musicians, sexual harassment, &amp; blurred lines"
+++

It was slightly eerie to listen to [Lauren Pierce describe](http://www.insidethearts.com/audience/going-confidently-in-the-direction-of-her-dreams/) some uncomfortable moments during a contract subbing as a double bassist in an orchestra. She recalled a man, a fellow orchestra member, whose seat was behind Pierce's, who spent a few rehearsals moving from friendly with her, to suggestive, to crossing lines.

The situation culminated in Pierce being somewhat cornered by a water fountain during break, where the man complimented her pants, then touched her (very) lower back, and said, "I've been enjoying the view all night."

Pierce admits that she's not entirely sure if what happened to her falls under the definition of sexual harassment. "We tend to think of sexual harassment as someone pushing us against a wall and violently forcing themselves on us, but it rarely happens that way," Pierce said in an [interview with Doug Rosenthal](http://www.insidethearts.com/audience/going-confidently-in-the-direction-of-her-dreams/). "The lines are usually much blurrier, as they were with my situation."

Like any relationship built on an imbalance of power - teacher/student, boss/employee - the rehearsal room is full of captive audience members. In the orchestra setting of Pierce's story, both she and her creepy male colleague are permanently assigned seats, and they're working in an environment where disrupting the work is a big offence. So, without the opportunity to move to another place in the room, or to clearly and conspicuously tell him to stop saying creepy things, a so-called "non-confrontational person" like Pierce would add anxiety over feeling trapped to the stress of the harassment itself.

A Google search turns up few results about cases of sexual harassment in classical music and opera circles. Yet among those working in said circles, there's no shortage of rehearsal-room anecdotes about encounters with colleagues and superiors that have felt in the vicinity of sexual harassment. Jokes about double-entendre music terms ("fingering," "tongue tension," "G-string," etc.), invasion of personal space (teaching by demonstration), and (perhaps) innocent flirting; all of these commonplace pieces of sexual harassment are perhaps more dangerous when combined with a captive audience of sorts. 


It's the same situation in a lesson, group rehearsal, or staging rehearsal. If a fellow cast member gets a little handsy during staging, or a director starts to rack up too many sexual jokes, not many singers would risk calling him or her out in the moment. Likewise, in a private lesson with an important teacher, plenty of students would ignore/avoid any unwanted interactions for the sake of impressing. (\*Personal anecdote: I remember playing for a lesson, and when I leaned over to pick up my coffee cup from the floor, I heard the teacher say, "And while you're down there..." with a laugh. Oh, and another time I was asked what colour of underwear I was wearing in rehearsal.)

Young people, of course, have more to lose. Like in any competitive industry, no one wants to rock the boat with cries of "sexual harassment!" when they're still trying to get a full foot in the door of their career. So, no one will fend off a conductor's lingering cheek-kiss, or repeated "accidental" gropes during a scene, or friendship-with-ulterior-motives-TBA.

Or, it happens the other way: a legitimate relationship (serious or not) develops between colleagues at work, and it's all great until it's not. It's easy to imagine an emerging conductor's not wanting to work with an ex; within music circles, being one's ex (especially a non-amicable one) can close some doors.

It's true that these problems exist in any field; yet there's something unstable about the music-world combination of a competitive industry, a strong tradition of mentor/student relationships, and generally passionate people. If a work environment, musical or otherwise, is ever going to be free of sexual harassment (blurry boundaries included), it's going to come from a generation of women and men who are socialized to know that it's alright to object.

And perhaps there should be some slack with the strict relationships of conductor/orchestra player, teacher/student. Our own experience tells us that the heirarchy is good for training musicians, yet it's the responsibility of the teacher as well as the student to recognize that respect is earned. The stakes are raised when the artist is young and the gigs are scarce; these are factors that those in charge (teachers, conductors, artistic directors) should be able to recognize, and know that they're not to be used for getting away with bad behaviour.
