+++
author = ["authors/john-hohmann.md"]
date = "2018-06-09T19:07:00-04:00"
lastmod = "2018-06-09T19:45:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1528585355053/sqCH1384301_Original.jpg.jpg"
primary_image_credit = "Mirga Gražinyte-Tyla conducts the MET Orchestra, Carnegie Hall, 2018. Photo: Chris Lee."
publishDate = "2018-06-09T19:45:00-04:00"
related_articles = ["articles/michael-tilson-thomas-takes-on-ruggles-mozart-mahler.md"]
short_description = "Levine filed his suit a couple of months ago, on the day that the Met&#039;s new production of Così fan tutte, a specialty of his, opened without him. The timing of both suits was sadly ironic. The Met&#039;s move on May 18 must have affected at least some of the musicians in this band, that is still so much Levine&#039;s creation, as they prepared to open their Carnegie Hall series with Debussy&#039;s &quot;Prelude to the Afternoon of a Fawn.&quot;"
slug = "musicians-of-the-met-orchestra-days-of-their-lives"
title = "Musicians of the MET Orchestra: Days of Their Lives"

+++
Wednesday, May 18 was not the best day in the life of the orchestra of the Metropolitan Opera, otherwise knows as the MET Orchestra. It should have been at least a very good one, considering that it was the beginning of the annual series that former music director, [James Levine](/levines-ugly-exit-the-disposable-met/), was instrumental in creating - three on-stage appearances at Carnegie Hall.

But it was also the day that the Met, countering Levine's lawsuit that claimed breach of contract and character defamation, sued him back. The opera company cited evidence that Levine "used his reputation and position of power to prey upon and abuse artists."

Levine filed his suit a couple of months ago, on the day that the Met's new production of _Così fan tutte_, a specialty of his, opened without him. The timing of both suits was sadly ironic. The Met's move on May 18 must have affected at least some of the musicians in this band, that is still so much Levine's creation, as they prepared to open their Carnegie Hall series with Debussy's "Prelude to the Afternoon of a Fawn."

Mirga Gražinytė-Tyla, the increasingly prominent music director of the City of Birmingham Symphony Orchestra making her MET Orchestra and Carnegie Hall debut, conducted in a generous manner that the orchestra seemed to embrace. But despite its atmospheric sheen, the Debussy lacked the touches that many believe brought classical music to the brink of modernism. It sounded perfunctory.

At best a languid opener, it was followed by the appearance of mezzo-soprano, [Anita Rachvelishvili](/scene/people/anita-rachvelishvili/) who has impressed Met audiences with her interpretations of the title role in _Carmen_ and most recently, Azucena in _Il trovatore_. Some artists do not inhabit roles in concert or recital with the same commitment that they bring to staged operas. Rachvelishvili on this occasion appeared to be one of them. Mussorgsky's _Songs and Dances of Death_, in a stirring orchestration by Shostakovich, requires an almost surreal devotion to the text to communicate its fateful subject matter. While she sang with a dramatic luster and responded to the orchestra's dark and turbulent reading with technical precision, her sound was only beautiful when it should have been emotionally overwrought. Gražinytė-Tyla held both singer and orchestra in an otherwise spellbinding grasp, reinforcing her own increasingly impressive reputation on the podium.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1528585494608/CH1384283_Original.jpg.jpg)
<figcaption>Mezzo-soprano Anita Rachvelishvili, conductor Mirga Gražinytė-Tyla, and the MET Orchestra, Carnegie Hall, 2018. Photo: Chris Lee.</figcaption>
</figure>

Fate held sway in the second half of the concert with Tchaikovsky's tumultuous Fourth Symphony. A popular orchestral showpiece, it requires leadership that can harness its vacillating attitudes on fate ranging from inevitability to benign acceptance. To a point Gražinytė-Tyla provided this but the sprawling work often seemed just that, lacking focus and clear detail. She and the orchestra exhibited shimmering unanimity with an encore for strings, "Svajone" ("Dream") by the Lithuanian composer, Juozas Naujalis.

With no news of litigation, May 30 appeared to be a day for collaboration. Gianandrea Noseda was on the podium, extending his long relationship with the orchestra that has included new productions of _Roméo et Juliette_ and _Les pêcheurs de perles_. The program consisted of Mozart's Fifth Violin Concerto and Mahler's Fifth Symphony, united by the number "five" and the consummate assurance of Noseda, violinist James Ehnes and the MET Orchestra, musical colleagues all.

Ehnes, a remarkably lyrical violinist who is a frequent collaborator with Noseda, and the orchestra responded to each other like the best of friends. Indeed, a feeling of musical well being swept over the hall reminding the audience that music making can be genuinely nurturing, especially when circumstances surrounding it are something less.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1528585557759/CH1385494_Original.jpg.jpg)
<figcaption>Violinist James Ehnes plays with the MET Orchestra, Carnegie Hall, 2018. Photo: Chris Lee.</figcaption>
</figure>

How lovely it was that Mozart's first movement, calling for symbiotic interplay between the violinist and orchestra was realized with such dash and polish. Ehnes played a lilting songlike melody in the second movement Adagio with fluid insight. His "voice" was supported on a level at which this ensemble has few peers. Inspired by Turkish military music, the third movement, a Rondo, incorporates the clicking of violins slapped on their sides by bows giving the concerto is informal name, "Turkish" and an exotic sound.

Fresh and exciting as all of this was, the program would give way to Mahler's Fifth, but not before Ehnes gifted us with two encores; the third movement from Bach's third sonata and a quiet passage from his second. The first encore brought an abrupt hush to the cheers following the concerto. The audience hung on every exquisite note of both pieces.

Noseda may be a near perfect conductor of Mahler because of his ability to harness with such precision and balance, the disparate elements of this work. Opening with its funeral march, towering horns, (surprisingly off at moments) its "fever dream," as Mahler termed it, of a Scherzo, and the melting Adagietto that follows, the task is immense and Noseda was elegantly committed throughout.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1546220235/media/2018/12/CH1385511Original.jpg)<figcaption>Conductor Gianandrea Noseda and violinist James Ehnes with the MET Orchestra, Carnegie Hall, 2018. Photo: Chris Lee.</figcaption> </figure>

Or, it may be that Noseda's precision inhibits Mahler's innate bohemianism and his expressionistic manner of joining elements that, if his personal life had any impact on his compositions, weren't meant to fit neatly together. It is a matter of taste, of course, especially when a conductor like Noseda, with unquestionable intentions and proficiency, is at the helm. If the audience in Carnegie Hall was in any way divided on this issue, it didn't register in the rapturous applause when the symphony raced to a close that could be considered highly animated — or unruly, depending on how one views Mahler. Under any circumstances, it was a great day for the splendid MET Orchestra.