+++
author = ["authors/edward-atkinson.md"]
categories = "Editorial"
date = "2015-06-26T13:26:00-06:00"
lastmod = "2015-06-27T17:16:00-06:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1435423531876/shutterstock_101806765.jpg.jpg"
publishDate = "2015-06-27T14:33:00-06:00"
related_articles = ["articles/singers-heres-how-to-use-social-media.md","articles/singers-heres-what-you-need-to-know-about-your-website.md"]
related_companies = ["scene/companies/highlands-opera-studio.md","scene/companies/dean-artists-management.md"]
short_description = "The 6 skills/topics listed above are core to an effective marketing package. Yup, it takes time and work to acquire any of these items. But it will not cost you thousands of dollars, nor is it impossible…if you have the determination to use your search bar, put in a few hours a week, and chip away at the tasks over time."
slug = "musician-marketing-masterclass"
title = "Musician Marketing Masterclass"
+++

If you are a professional musician, you’re stuck on the B team until your marketing package includes:

- Gorgeous, recent headshots
- A high-quality demo recording
- A pipeline of feedback from (real-world working) casting and general directors
- A knock-out résumé and narrative biography
- A website that says, “Damn, I'm good at what I do.”
- A flexible understanding of the crazy, ever-changing business that is professional music.

You already know this! You’ve heard this advice from teachers and working professionals in the field, telling you where your materials need to be. But how the hell do you get there?

If you’ve got the dough, look into a career training program like [Opera America’s Career Blueprints](http://operaamerica.org/content/about/artists/CareerBlueprints.aspx) program. If you don’t have the dough, read on...

When I was 14, I accidentally started my first business.

One afternoon, my friend Richard asked me if I could create a new website for his friend’s audio-visual business. At the time, I knew nothing about website design or development. But I said yes anyways. We set a day to discuss the project with the client, 5 days away. For 5 days straight, I turned to Google (which was a young startup at the time!). I searched for hours and hours about writing contracts, negotiation tactics, and meeting etiquette. When I finally met Richard and the client over a steak dinner, I successfully negotiated a 6 month contract with a hefty profit margin.

But remember: I had no idea how to actually make a website!

I spent the first 3 months of the contract learning how to design and code websites, and the last 3 months actually making the website. The site launched to rave reviews, a host of referral contracts for me, and an 11-year run as the online face of their company.

This was a major life lesson: if you believe that when you put your mind to it, you can figure your way out of almost any jam, your limits will be few.

Back to music! The 6 skills/topics listed above are core to an effective marketing package. Yup, it takes time and work to acquire any of these items. But it will not cost you thousands of dollars, nor is it impossible...if you have the determination to use your search bar, put in a few hours a week, and chip away at the tasks over time.

So let’s get to work:

### Gorgeous, recent headshots

1. You’re not paid like Pavarotti yet, so you need ‘em cheap. Fear not! Here are three ways I have seen singers use, who later landed gigs with their cheap headshots:

2. Take it yourself, outside for good lighting, using an iPhone 5 or later model (borrow someone’s if you don’t have one) + a cheap tripod ([example](http://www.amazon.com/gp/product/B009GHYMB6/ref=as_li_tl?ie=UTF8&camp=1789&creative=9325&creativeASIN=B009GHYMB6&linkCode=as2&tag=mindsprocket-20&linkId=OIJNPSCSQLLFKFHH)). I recommend the newest iPhones for their incredibly advanced cameras. If you want to get slightly fancier, the ProCamera 8 and VSCO Cam apps are insanely powerful and give you manual control of the camera, like an HD DSLR.

3. Speak to a local art/photography department, and ask if there is a new student who needs subjects, and who will give you a cut rate.

4. Ask around if there are fellow singers who have photography as a hobby. Photography-singers tend to be much cheaper than a full-time photographer.

### A high-quality demo recording. 

You are screwed on this one. It’s going to cost you at the very least a few hundred of dollars: but that’s okay! Your voice is your art, your craft, and also your core product. If you have spare dollars, this is where you put them. A significant number of YAPs require them (possibly most). Every agent wants to hear one. You’re going to need it, without a doubt. Here are two of my favorite articles on the subject, which cover paying a studio or simply doing the recording yourself:


- [How To Make a Great Demo Recording](http://musicalexchange.carnegiehall.org/group/voice/forum/topics/how-to-make-a-great-demo-recording)
- [Recording Tips](http://www.thebusinessofsinging.com/sr_resources/topics/recordingtips.htm)

### A pipeline of feedback from (real-world working) casting and general directors. 

How do you garner feedback, in a world where judges, agents, and directors are sifting through hundreds of names a week? The answer is strategically, with a goal in mind, and with respect for the relationship. 

1. Be strategic. You just did a blind audition, and you were number 93? Fuhgeddaboudit. Feedback is simply an informed opinion. The opinion of a panel who has just sat through 200 singers is an opinion formed inside a stretched attention span. Insightful feedback will come from professionals who have heard you more than once (and are thus more informed). It is a good tip to look for people who have no problem speaking their mind (e.g. “That was crap”). The praises of someone willing to call a spade a spade can be more likely to be honest.

2. Be goal-oriented. “Well, how was my audition?” is not a very useful question to ask, and a terribly un-fun question to answer. Better questions to ask: “What can I do next time that would have helped set me apart from the others?” “What would you have liked to have seen more of?” “What can I do next time, that would make it really hard for you to not hire me?” Each of these questions is directed to getting an answer that is concrete, and driven towards a goal.

3. Cultivate mentor relationships with industry decision makers. The first step to a relationship of any type is taking a genuine interest in their life and work, instead of making it about you. Asking questions like “How did your summer youth orchestra program go?” goes a very long way. Be respectful of the busy schedules of a decision maker, but don’t be afraid to ask for their opinion. I have personally asked for feedback from probably a few dozen conductors and directors. Almost every one of them told me that they wished more singers like me had approached them with enthusiasm for learning and improvement. Show people that you are committed, humble, and hungry to learn, and they will be glad to help you.

In summary, go after insightful feedback with goal-oriented questions, and over time cultivate relationships with industry decision makers.

### A knock-out résumé and narrative biography

- [Opera America's Resume Tips and Examples](http://www.operaamerica.org/content/about/Artists/Downloads.aspx)
- [Bio tips and what to include](http://careers.faa.illinois.edu/music/bioMusic.pdf)

This is probably the part of your materials you could get right tonight.

### A website that says, “Damn, I'm good at what I do.” 

Website design and development can be eye-poppingly expensive, when highly customized, and can be quite cheap, when purchased out-of-the-box.

2. If you have marginal tech know-how, I suggest you use a shared server (e.g. [Bluehost](http://www.bluehost.com/track/crimson0emperor/)) to host your website. Customizing a WordPress template is the most common way to a basic website. (Related article: [How to Own Your Website Even If You Think You Can't](http://www.howtogeek.com/109946/how-to-own-your-own-website-even-if-you-think-you-cant-build-one-pt-1)). The easiest trick to get the most unique look out of a WordPress template is to use one which is geared towards photographers. These themes rely on huge, unique photographs to provide the unique look and feel of the website. Simply drop in your awesome HD headshots, and voila, now it looks like your website.

3. Only slightly more expensive are tailored, do-it-for-you services like [SquareSpace](http://www.squarespace.com/). If the idea of putting together a website is stress-inducing, SquareSpace is for you. After 15 years in the web development industry, I can confidently recommend SquareSpace as the first choicefor those without programming experience who are doing it themselves. It is extremely easy, extremely well supported, and overflowing with elegant, highly-customizable themes.

### A flexible understanding of the crazy, ever-changing business that is professional music.

If you think that anything will stay the same, you’re wrong. But you already know that too. The real trick is to develop that thinking into a way of life. Freelancers, entrepreneurs, and artists must all work to become mentally tough and mentally flexible. What a balancing act that is! 

The future of music is securely tied to the future of technology…and we all know how quickly both worlds have changed in the last 20 years. This rate of change will not be slowing down any time soon either. Artists need to adopt a mode of thinking that is friendly to new ideas, and curious about the future. 

I list flexible thinking as one of the skills of your marketing package for two reasons. One, your marketing package will change as technology changes (did you know that Taylor Swift released an iOS and Android app for one of her new singles, which lets you walkthrough and tour the set of her music video?). Two, this skill permeates everything in the life of an artist. Rigid thinking can make you go insane in this business, but flexible thinking can make you excel.

### Two parting thoughts

Firstly: you are stronger and more capable than you believe. Put your mind to it, and yes, you can acquire these skills and items almost entirely on your own. You don’t need to spend thousands to put together a truly knock-out package. You do need to put in the work, one step at a time, to get there. I will say, however, that one of the most common topics for bitching-over-beers that I hear from agents is how young singers neglect their marketed image.

Lastly, your marketing materials do not exist in a vacuum. They exist in an agent's browser which currently has 52 tabs open where she is spending 15 seconds on each demo recording. They exist in an enormous pile of mail, which is gone through only once a week. Compare your marketing materials to Anna Netrebko’s, your roommate, your teacher. And then branch out: compare your materials to pianists, salesmen, rock bands, and hip hop groups. Remember that your materials need to communicate your unique qualities in an unmistakable fashion.

Be big. Be bold. Be different.

Go forth and make waves!
