+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2016-02-08T22:07:00-05:00"
lastmod = "2017-11-30T21:05:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1512093939350/2017-11-30---Therapy.jpg.jpg"
primary_image_credit = "Photo: Rick Harris, via Flickr. (Link in footer.)"
publishDate = "2016-02-15T10:37:00-05:00"
related_articles = ["articles/the-heart-and-the-art.md","articles/things-more-important-than-opera.md","articles/true-stories-the-critic-who-loves-opera-even-more-now.md","articles/helpful-singers-opera-does-house-calls.md"]
short_description = "One the one hand, you could argue that the test of a true musician is similar to that saying, &quot;you know who your real friends are when your friendship costs them time and money.&quot; A real musician is one who wants to make and listen to music when there&#039;s no deadline, and no paycheque on the horizon. Right? I don&#039;t actually think that&#039;s right, but it&#039;s a nagging idea."
slug = "music-the-musicians-therapy-except-when-its-not"
title = "Music: the musician&#039;s therapy, except when it&#039;s not"
+++

Most musicians have a story or two to tell about a time they used music to deal with pain in their lives. A pianist feels sad, and he finds catharsis in Chopin and Rachmaninoff; a violinist pours her grief into Sibelius and Brahms, and the singer looks for tragic *bel canto* and *La bohème*. Of course there's catharsis to be found in music, and a release of physical tension comes with playing an instrument and singing. Musicians are lucky to have an option like "make music" in their toolbox when it comes to beating the blues; so are the listeners, since a huge portion of the art and music we value today comes from artists with tragedy in their lives.

Special as they are, musicians are of course, humans. Sometimes our lives are a bad time, and different people deal with it the way they can. If life gives a musician lemons, making music is supposed to be part of the whole "making lemonade" thing. 

So, what if you're a musician who just *doesn't want* to play her heart out? The idea of "putting it into your music" is a widespread solution among musical communities, and it really does have a huge success rate. But for something to happen in a musician's life that pulls her entirely away from music, that's pretty bad, right? When there's no comfort to be found in music, does that mean there's something wrong with the musician?

As I write this, I struggle with the dumbness of that thought, but I think it's a real one among artistic communities. If you're artsy, that art is supposed to be your solace in bad times, and it's supposed to be your therapy. I'm someone who first sat at the piano when she was 3, and who grew up surrounded by people who value music. By this point in my life, I'm supposed to have a no-brainer way of coping with bad stuff. So it's unnerving when the tried and true method has zero appeal.

Maybe that's the reason that so many musicians prefer listening to talk radio in their downtime, or why they struggle when they're asked what their favourite "non-classical" music is. If you're a working musician, you know what it means to love your job; you also know what it means to want to come home to something other than *more music*. Whether it's cranking the volume on your favourite album, or playing and singing yourself, either way it's hard to turn off the parts of your brain that make you great at it. I figure the layperson imagines a musician caressing his instrument, seeking emotional comfort with an inner monologue that goes, *I can control this, I love doing this so much, this instrument is my true best friend.* In reality, the monologue sounds more like, *Ugh, that was a bad attack, and my legato is crap.*

That's why we're such avid readers, big movie fans, podcast listeners, basically the stuff of millions of other non-musicians seeking a bit of distracting relief from their lives.

One the one hand, you could argue that the test of a true musician is similar to that saying, "you know who your real friends are when your friendship costs them time and money." A *real* musician is one who wants to make and listen to music when there's no deadline, and no paycheque on the horizon. Right? I don't actually think that's right, but it's a nagging idea.

Luckily, I still find comfort and catharsis in live performance. It's a different experience than listening to my own music collection, and it's definitely different than playing the piano. Live opera is, thankfully, something that consistently pulls me in, even if it's not top-notch. There's relief in the length of it, knowing I can count on a couple of hours (plus travel time) of having my attention drawn elsewhere. I've braved nasty weather and long commutes to get my fix of live opera precisely because I know it never fails. And of course, opera is never more powerful than when a listener is already feeling emotionally vulnerable. 

What do you think, readers? Do you *always* love your cello or violin or your vocal folds? Is the musician who turns away from music in her time of need a fairweather artist, or just human?

[Photo by Rick Harris, via Flickr.](https://www.flickr.com/photos/rickharris/3691522967)
