+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-09-19T10:15:00+01:00"
lastmod = "2016-09-19T13:39:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474284087699/2016-09-20---Church-Dome.jpg.jpg"
publishDate = "2016-09-19T13:00:00+01:00"
related_articles = ["articles/morbid-musings-art-death.md"]
short_description = "Perhaps this happens because music is one of those things that can truly offer the exhilarating joy and sense of belonging that many religious seek. It&#039;s perhaps not the same thing, but in my work with music, I have experienced moments of happiness, awe, and admiration so great my whole self vibrates."
slug = "music-religion-irony"
title = "Music, religion, &amp; irony"
+++

Hi everyone, Jenna here.

I was reading some articles about [Mohammad Nouman Dasu](http://www.theglobeandmail.com/news/toronto/mandatory-music-classes-strike-sour-note-with-muslim-parents/article31716832/), the father living in Toronto, who in a three-year battle, was trying his hardest to keep his children out of music class at their school. Dasu's reasoning was that the music that his three kids would practice at their public school would be *haram*, or forbidden in their Muslim faith. 

The Toronto District School Board claims it can't exempt a student from the curriculum, as part of the Education Act. As a fan of the subject myself, I was pleased to see the Toronto District School Board defend music's place in its curriculum, while offering instead "accommodations" for Dasu's children. 

"My kids cannot participate in music or drama, that's for sure," says Dasu. "Let them sit in a library to read, or in an office, or let them volunteer around the school during that time, that's all okay. We're flexible."

The TDSB seems flexible, too; they suggested things like hand-clapping instead of playing instruments, and listening to *a cappella* versions of "O Canada." (The use of instruments is a specific bit of [contentiousness](http://islamqa.info/en/5000) in Islam.) Dasu, who says he speaks for many other similarly concerned parents, insists that the children simply can't be in the same room as the music-making.

As it stands right now, for the hour that the class spends on music, Dasu or another family member come to pick up the kids and take them home. (If I thought I'd get a real answer, I'd ask, *To do what?*) 

The family moved recently, and Dasu is planning to transfer his kids to another public school (where he'll likely start the whole fight up again).

The funny/sad thing about all of this is the fact that no one is considering what could be good or bad for the kids. I suppose it's a futile chore, to present to Dasu and parents like him the evidence for the benefits of music education. It's moot, when the reasoning behind banning a child's experience with music and drama has its roots in religion. The question of how to raise kids has never been up to the kids.

(\*And on that note: although it may not seem a big deal for their parents, these three kids' regularly leaving class for a period of time can do a real number on their social lives at school. Taking them out of school interrupts the natural flow of their daily interactions with their peers, and no kid wants to be considered odd or weird for any reason.)

The religious community is divided about what kind of music is considered permissible, and it's not something unique to Islam. The extreme ends of the Abrahamic religions share this thing with denying oneself pleasure. Frowned upon are sex, dancing, drinking, books/songs/plays/movies "celebrating" any of the above, and beautiful things that don't need God to be currently enjoyed.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474284277011/Footloose2.gif)
</figure>

Historically, a concession will be made when the church discovers how one of these pleasure-inducing threats can actually be used to complement their own mission, like non-*a cappella* music that people enjoy, and stained-glass windows to make the long sermons seem more flashy.

It's the same thing with music. Among conservative churches, permissible songs don't glorify any of those frowned-upon things, since any musical sound that one makes should celebrate God. Voices are considered "purer" than musical instruments, since instruments were what played vulgar music at pubs, parties, and orgies, anywhere people were having an earthly good time.

And today, the simple fact is that some churches have relaxed the rules about making music, and some churches haven't.

Perhaps this happens because music is one of those things that can truly offer the exhilarating joy and sense of belonging that many religious seek. It's perhaps not the same thing, but in my work with music, I have experienced moments of happiness, awe, and admiration so great my whole self vibrates.

I remember once having a conversation with two Mormons who had come to my door several days in a row. I had either not been home, or had politely postponed a longer conversation with them by claiming to be busier than I actually was. When they caught me yet again, I was heading out for a cappuccino, and invited them to walk and talk. 

They shared with me why they were Mormon, citing the happiness and comfort they felt with the message of the church, and being a part of a community that worked toward a common end. I couldn't help but think how similar were our pursuits of joy and awe, despite the difference in our methods. And frankly, if that's what a person gets from their religion, that's a beautiful thing. 

It's hard to argue with an experience that seems divine, regardless of where it happens. For me, church didn't quite cut it compared to playing Brahms violin sonatas and Schumann *Lieder* and the piano dress of *Peter Grimes*. Those heavenly experiences come as equally with Verdi's *Requiem*, Bach's *B minor Mass*, and Handel's *Messiah*, for what it's worth.

The real, everyday "religious experience" that people pursue includes feeling a part of a community which works together to achieve (and be) something great. And yes, the joy that the religious seek comes with responsibility - discipline, even. It's the case with faith, and music, and anything else that takes a long time to understand: the joy is worth the work.

So, is there irony in the fact that music, all by itself, can bring joy and community, and there are religious people who oppose it? Or is it a sensical example of what can only be called an inferiority complex?

>Have I missed the point? Rebut below.
