+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-10-22T19:54:00-04:00"
lastmod = "2015-10-26T10:03:00-04:00"
preamble = "Most artists want to touch the lives of others with their work, and I spoke recently with a few Canada-based singers who have found a very tangible way to do some good with their talent. Tenor [Paul Williamson](/scene/people/paul-williamson/) and soprano [Allison Cecilia Arends](/scene/people/allison-arends/) travelled last summer to Kingston, Jamaica, where they held their inaugural Mini Mozarts Summer Camp with the St. Andrew Parish Foundation. Mezzo-soprano Kathleen Promane, the newest addition to Mini Mozarts Summer Camp joined Paul and Allison in Kingston this fall to sing in a benefit concert for the Foundation. \n\nMini Mozarts participants come from communities living in extreme poverty; in addition to daily meals, campers get a fun introduction to music, games, arts and crafts, and performances of their own. Paul, Allison, and Kathleen talk about the work they've been able to do in Kingston, and what it feels like to be able to give to a community in need. \"They do not take anything for granted, since they have very little.\""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445826553725/MiniMozarts.jpg.jpg"
publishDate = "2015-10-26T09:00:00-04:00"
related_articles = ["articles/hear-the-premiere-of-abraham-support-the-syrian-refugee-program.md","articles/dont-miss-shoestring-operas-hansel-gretel.md"]
related_people = ["scene/people/allison-arends.md","scene/people/paul-williamson.md"]
short_description = "Most artists want to touch the lives of others with their work, and I spoke recently with a few Canada-based singers who have found a very tangible way to do some good with their talent. Tenor Paul Williamson and soprano Allison Cecilia Arends travelled last summer to Kingston, Jamaica, where they held their inaugural Mini Mozarts Summer Camp with the St. Andrew Parish Foundation. "
slug = "music-matters-at-mini-mozarts-summer-music-camp"
title = "Music Matters at Mini Mozarts Summer Music Camp"
+++

## 1. What drove you to start this summer camp in Kingston, Jamaica?

**Paul Williamson and Allison Arends**: We were involved in singing a concert for the Saint Andrew Parish Foundation (SAPF), in December 2014 in Kingston, Jamaica. It has since become an annual benefit gala, with which all three of us are now involved, and major fundraiser. All proceeds go to help the many outreach projects that the Foundation oversees. These projects include social programming, family planning, education and employment training, a girls’ school, senor care, and an infant school for children aged 3-6. The infant school, called Saint Andrew Settlement, has not only an educational facility, but also a dental and health centre, and soup kitchen. 

They initially reached out to Paul, as they hoped to hold a high-class fundraising gala with musical entertainment, and it was at that time that Allison was also invited to take part. While we were in Jamaica, we made a trip to the infant school. We both fell in love with the children! It struck us how innocent, enthusiastic, and loving they all were, and how unjust it was that they have so many obstacles awaiting them, including poverty, and potential abuse, neglect, and drug abuse, to name a few. 

**Kathleen Promane**: This October I had the great privilege of joining Paul, Allison, and Lori Burnett as a featured artist in the St Andrew’s Parish Foundation now annual Benefit Gala Festum Sancti Andreae in Kingston, Jamaica. While in Kingston, Allison and Paul took me along to meet the children that had attended the camp they had started up in August.

It was immediately obvious to me that the foundation has been doing a fabulous job providing these children with a great education and wonderful caregivers.  Allison and Paul were so well received when they went in to see the kids. The children ran over to hug them and jumped up to sing songs they had learned in the music camp that summer. 

**Paul and Allison**: It was then that the Mini Mozarts Summer Music Camp was born. We believe that as citizens of the world, it is our responsibility to reach out to those who are unjustly met with many disadvantages, be it poor health, lower socio-economic status, or downright destitute poverty, as is the case with these children. It is our hope that we can introduce these children to a basic musical education, inspire them in their creativity, ensure that they are fed and supervised during a time they may otherwise be on the streets (summer vacation), and teach them that building a healthy community is done in the spirit of cooperation and compassion, not “survival of the fittest”. 

We both were so fortunate to receive the full support of this amazing Foundation, and to work with them in their incredibly cooperative and generous spirit. The rest is history!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445561544250/045AArends%20WEB.jpg.jpg)
<figcaption>Allison Cecilia Arends, soprano.</figcaption>
</figure>

## 2. What does an average day at camp look like?

**Paul and Allison**: The camp ran four days a week from around 8:30 AM, at which time they were served breakfast, to 1:00PM, at which time they were served lunch. We always began our day with vocal and physical warm-ups, and also various games that tested and developed their ability to listen and follow instructions. 

Next, we led them into the musical component of the day, which included teaching them around 10 songs in total over the course of the 2 weeks, one which we wrote ourselves: "I have learned my ABC’s, now I learn my Do-Re-Mi’s. Mini Mozarts Camp is fun for you and me and everyone. I love music, so should you. Mini Mozarts Camp, WOOHOO!" 

Next came our games time, which included musical chairs (a camp favourite!), freeze tag and musical tag, hot potato, Ring Around the Rosie, What Time is It Mr. Wolf, musical freeze, and Simon Says. 

Our next component, following the much-needed water break (we were doing all of this in outdoor facilities in sometimes 40 degree heat!), we treated the kids to a short time of video entertainment, which always had a musical theme. They viewed video clips from cartoons like *Bugs Bunny* (goodness knows, many of us received our early music education thanks to him!) and *Veggie Tales*, famous and fun opera scenes, Disney cartoons (*Pete’s Dragon* and *The Lion King*), and musicals (*Mary Poppins* and *The Sound of Music*). 

By now, the kids had calmed down enough to focus on story time. Some days we read and learned nursery rhymes, some days the older kids would break off to learn and prepare a play, written by a Jamaican children’s author. 

We frequently would sneak in little bits of music theory and history, including the musical scale, facts about opera, symphonies, orchestral instruments, and various composers (Handel, Bach, Mozart, Beethoven, and Wagner, in particular). They also got to listen to many musical clips and audiobooks, after which time they were engaged in some discussion about what they liked and disliked and why. We encouraged them to form opinions and taught them that these opinions were valuable. 

Next was craft time, which was perhaps a favourite amongst both the children and us, because they got to express their own individual creativity, through painting, designing, drawing, and decorating. The specific crafts included crafting simple musical instruments from various household items, such as drums, guitars, and megaphones. As well, they got to make Viking hats (yes, this coincided with the Wagner lesson), tie-dye t-shirts, and do potato stamping using massive amounts of paint and glitter. 

After the kids were fed lunch, they were released and we began planning and settting up for the next day. We would then make our way home (we were generously put up by the lovely Mrs. Facey, a major sponsor for the Foundation) in a dirty, sweaty, exhausted, but overwhelmingly fulfilled heap.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445559036985/Paul-Anthony-Williamson%2C-tenor2.jpg.jpg)
<figcaption>Paul Williamson, tenor.</figcaption></figure>

## 3. What changes or improvements are you making after this summer's inaugural camp?

**Paul and Allison**: There has even been some discussion about further developing this program to include a Christmas camp, schools tours, private musical instruction for the children (voice, piano, guitar, and drums), and of course more fundraising initiatives, without which none of this would be possible. While this was very much a “test year”, we were pleased to learn that all of our ideas went over very well, and at this stage all we would like to do is continue to expand and add various opportunities for the kids of the community. 

We know that the children do not have much in the way of attention spans, so we will continue to add tactile activities, especially for the little boys. We discussed in great detail with the school principle as well as the committee the idea of having an outing with the children. Field trips are not something these kids will ever get to experience, so we love the idea of a day away from the neighbourhood. One idea that came up, pending sponsorship, is taking the kids to the Bob Marley Museum for a day. 

Also, there is a high incidence of child [sexual] abuse in this neighbourhood, rape, and the birth rate is staggeringly high, which only includes around 20% of these girls being over the age of 18. The school and Foundation work closely with family/child/social services in Jamaica, and are working very hard to educate the young men and women about appropriate and lawful behavior, as well as family planning and contraceptives. We would love to involve these educational/preventative services in the camp, so that the children areincreasingly aware of their rights. 

It is also important that they are aware of the supportive role both we and the schoolteachers and staff are playing in their lives. Our camp was open to children ages 3-9. As the older children pass that age, we feel it is important not to abandon them, but to continue contact. We have discussed hosting another camp for older kids, or having some kind of a "junior leader" program, whereby they can be involved in the camp while taking on leadership responsibilities. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1445561493337/Kathleen-Promane-headshot-1.jpg.jpg)
<figcaption> Kathleen Promane, mezzo-soprano.</figcaption>
</figure>

## 4. What kind of feedback have you gotten from campers?

**Paul and Allison**: The feedback was overwhelming, also from the staff, the Foundation committee, and those who attended the final concert. The children live in a world where they have to fight for everything, so we had to make sure everything we gave them was evenly distributed. It was obvious from the beginning that these children were starved for attention, constantly wanting to hold our hands, sit in our laps, receive and give hugs, and just have the chance to speak and be heard.  

While we had to establish and exercise our authority as instructors, adults, and supervisors, they learned that we did not love them or think any less of them when they misbehaved. This was a very new thing for many of them. It was overwhelming how much their behaviour changed over the two weeks. That, their enthusiastic response to the activities, and their love and affection were all the feedback we needed to know we were getting through and impacting these children in big and important ways. 

After the first week, we had the weekend off. Upon returning again on Monday morning, the kids were all sitting on the steps of the school awaiting our arrival. Upon seeing the car turn the corner, they all screamed “YAAAAY!” and sprinted to the car to envelop us in a group hug. It was an incredible and emotional moment.

## 5. As singers, what have you learned from working with young kids, and working in impoverished communities?

**Paul and Allison**: We have learned that as musicians, we have a lot to offer children who suffer from destitute poverty. To give a little background on the neighbourhood we worked in, it is very much third world. Many people live on the streets, many people are missing limbs, and many people sell drugs or whatever they can to survive. The infrastructure is poor and the roads are largely unpaved or falling apart. The homes are makeshift, many without electricity or running water.

**Kathleen**: It was quite humbling driving into the neighbourhood where the children live. The poverty in Kingston is a desperate situation, far from the poverty you come across in Canada. I was told that the children in this neighbourhood usually turn to crime by the age of 9 because of their desperate circumstances.  When I walked through the school, the volunteers there were so kind and welcoming, as were all the Jamaicans I met while in Kingston, but the children were the ones that when I met them really pulled at my heartstrings. As a mother of two young children, I had to hold back tears. They were obviously so bright and eager to learn and in my opinion, right on par with what Ontario school children are expected of.  

**Paul and Allison**: It takes an incredible amount of dedication, patience, and most of all compassion to work with kids in this situation; it is sometimes backbreaking and frequently heartbreaking. But we have learned that love and compassion go a long way in making a difference. Music IS a universal language and we did our best to make their time with us as simultaneously fun and educational as possible. They absorbed things so quickly, and they do not take anything for granted, since they have very little. 

**Kathleen**: Being the mother that I am, I immediately began brainstorming some of the things we could teach the children through music and songs, thereby making it fun, like brushing their teeth, washing their hands and eating healthily.  These are all things that my 5 year old son is learning at school and takes pride in the practice of healthy habits. I am now excited that I may have the opportunity to work with these children next summer and have many ideas of how I might contribute. I am the newest addition to the St Andrew’s Parish Foundation project “Mini Mozart Camp” but am thrilled to be considered as a collaborator and participant.

**Paul and Allison**: We are committed to continuing our work with the children of Majesty Gardens (the community in which we were working). In addition to our camp and ongoing fundraisers in Jamaica, we are launching a major fundraising initiative in Canada. It is our hope to raise awareness of the growing need in Jamaica and raise major funds to continue our work, as well as support the various other projects the Foundation overseas.

>To make a donation to St. Andrew Parish Foundation, you can send a cheque or money transfer to 4 Hagley Park Road, Kingston 10, or get in touch with Paul Williamson at paulwilliamson.ca/contact for more information.
