+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-07-30T10:22:00-04:00"
lastmod = "2017-07-31T22:00:00-04:00"
postamble = "What are your tidbits of wisdom for the academically oriented? Let us know in the comments below!"
preamble = "August is here, readers, which means many of you may be mere weeks away from starting an academic year pursuing a music degree. Whether you're an incoming first-year student, or a seasoned pro at academia, there's an art to being a student; on top of showing up on time and turning in your theory assignments, post-secondary music education is about taking responsibility for what you learn. "
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1501515461322/2017-07-31---School.jpg.jpg"
publishDate = "2017-07-31T22:00:00-04:00"
related_articles = ["articles/paid-summer-programs-is-it-time-for-a-revolution.md", "articles/audition-season-or-the-annual-festival-of-shattered-dreams.md"]
short_description = "Remember that being able to call yourself a Curtis student or a Juilliard student or say you attend the Conservatoire is a statement about status, and no indicator of your musicianship. So, be fair to your chosen school and what it can offer; more importantly, be honest with yourself about your academic goals."
slug = "music-degrees-expectations-4-tips-for-new-students"
title = "Music degrees &amp; expectations: 4 tips for new students"

+++
## If you still feel like a big fish in a small pond, you're at the wrong school

At the post-secondary level, music schools are full of students who were hot shots of sorts in their hometowns. It's a natural part of formal music education to continue to raise the bar; still, not every student fully anticipates what it may feel like to go from collecting trophies at their local music festivals, to being nothing special at your weekly studio class.

Some students rise seamlessly to the occasion, and some have a frustrating time recognising that their work may no longer be met with lavish praise. There's no wrong way to make the transition from small pond to big, but there's one important question to ask yourself along the way: _am I still a big fish?_ Hopefully, the answer is no; if the answer is yes, you may not be getting your tuition money's worth in skill-stretching education.

>Listen to your instincts if they're telling you that academia simply isn't for you.

## It's not your school's job to "make" you a great musician

Few people pursue a music degree with the mindset that they won't have to do any work of their own. It's fairly common, though, to choose a school or teacher with the idea that they will hold the magic keys to your success. It's true that some schools offer more than others, and you'll likely click with some teachers and not others; but no matter how prestigious the institution, or how successful the studio graduates, your development is _still on you_.

The real difference between a decent school and a great school should come down simply to tools. But without the work you do yourself in the practice room, there's no tool a voice teacher can wield that will bestow you with solid technique.

>Your tuition money covers tons of these resources that are harder to come by after you leave school, so be an unashamed hoarder while you can.

Remember that being able to call yourself a Curtis student or a Juilliard student or say you attend the Conservatoire is a statement about status, and no indicator of your musicianship. So, be fair to your chosen school and what it can offer; more importantly, be honest with yourself about your academic goals.

## Academic resources are meant to be hoarded

Here's the thing: no matter where you go to school, it will be a place that makes practicing music the easiest it will ever be in your life.

You have library access - _that is huge_. Students, think about it: if you didn't have a music library at your disposal, what would be the process of getting your hands on that score you really need for next week?

You have practice spaces! Sure, they're small and depressing; but they're set up for making music. They have pianos and piano benches and music stands, and they're located in a place where you're allowed - and expected - to make some noise. Those things are seriously hard to come by without a commute and some rent money.

You get to hear tons of concerts for free! Go to as many as you can, even if you don't think you'll "learn" anything from them. It's about stretching your repertoire awareness, your attention span, and noticing the difference between a performance that's good, and one that's memorable.

Your tuition money covers tons of these resources that are harder to come by after you leave school, so be an unashamed hoarder while you can.

>Get specific about what's turning you off, and think about how those turn-offs would relate to your post-school work.

## Pay attention to your own motivation

Music school can be a funny thing. Some students flourish under the concentrated environment, and others struggle with the disconnect between the expectation and the reality of their experience. If you find yourself underchallenged, that's a great sign, but it's your responsibility to find ways of filling those gaps. If you ask nicely, you might be able to find a new class to audit, or talk your way into taking on a role study in conjunction with the school production.

If you find yourself lacking in motivation, though, don't be hard on yourself. It's an oversimplification to decide that you're not cut out for a career in music simply because you're not enjoying your undergrad degree; any working music grad will tell you how different the professional day-to-day looks in comparison with academic life.

Get specific about what's turning you off, and think about how those turn-offs would relate to your post-school work. If you're simply not willing to put in the necessary time for practice and homework, be aware that those things will always be part of a performer's job. You're on a path that leads towards your livelihood depending on your own work ethic; if you're struggling now, it's good to recognise it before you find yourself in a tough financial spot.

If you're less than happy with the academic environment - you don't jive with your teacher/classmates, your class load isn't totally inspiring - know that those things are temporary. What stays consistent between academia and professional life is the work that _you_ do, autonomously. It's valuable to learn how to slog through boring classes that you think are irrelevant, because there are equivalents in the career. It's also valuable to learn how to continue to do your own great work, even when your teachers (bosses) and classmates (colleagues) aren't a great fit.

Listen to your instincts if they're telling you that academia simply isn't for you; just don't blame yourself when your academic experience fails to be totally inspiring.