+++
author = ["authors/vivian-darkbloom.md"]
categories = "Review"
date = "2017-11-14T17:20:00-05:00"
lastmod = "2017-11-14T21:09:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510698213319/2017-11-13---Paul-Curievici%2C-Pauls-Putnins%2C-Owain-Browne%2C-The-Lighthouse%2C-Shadwell-Opera%2C-directed-by-Jack-Furness%2C-Photo-Nick-Rutter-2017.jpg.jpg"
primary_image_credit = "Paul Curievici, Pauls Putnins, Owain Browne, The Lighthouse, Shadwell Opera, directed by Jack Furness. Photo: Nick Rutter."
publishDate = "2017-11-14T21:09:00-05:00"
related_articles = ["articles/ghost-stories-true-stories-the-lighthouse.md","articles/in-review-erwartungtwice-through-the-heart.md","articles/dont-miss-the-rcms-unsettling-doublebill.md"]
related_companies = ["scene/companies/shadwell-opera.md"]
related_people = ["scene/people/paul-curievici.md","scene/people/owain-browne.md","scene/people/pauls-putnins.md"]
short_description = "The confusion in the space translated into some confusion about the plot. Unfortunately, it wasn’t very clear that the trio of sailors from the opening were sitting before a board of inquiry, which also made the ending quite difficult to follow when it came. The first part of the opera was murky and perhaps could have been more interesting in its staging."
slug = "murky-works-shadwell-opera-presents-the-lighthouse"
title = "Murky works: Shadwell Opera presents The Lighthouse"
+++

[Shadwell Opera](/scene/companies/shadwell-opera/) is a brave young company based in East London - they continue to present exciting and innovative music from the 20th and 21st centuries. I was intrigued to see their production of Peter Maxwell Davies' dark, macabre monster, [*The Lighthouse*](https://www.hackneyshowroom.com/the-lighthouse/). They chose the Hackney Showroom to present the opera, an unconventional space in East London nestled amongst artist studios. I loved the venue - it was the perfect space for such a strange and atmospheric work. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510698344121/2017-11-13---Pauls-Putnins%2C-The-Lighthouse%2C-Shadwell-Opera%2C-directed-by-Jack-Furness%2C-Photo-Nick-Rutter-2017.jpg.jpg)
<figcaption>Pauls Putnin in *The Lighthouse*, Shadwell Opera, directed by Jack Furness. Photo: Nick Rutter.</figcaption>
</figure>

There were some wonderful things about this production, and some things that really didn't work for me. From the beginning, I was struck by the fact that they'd made an awkward use of the performance space. The band took up a huge amount of the space, meaning the singers had a limited amount of room to work from. Of course, the majority of the opera does take place inside a lighthouse - that implies a confined performance space, something which they presented quite literally in the centre of the room. But the lighthouse area was very close to the audience, making it difficult to see all three performers. There was a bunch of very big scaffolding at the back which was hardly used - I wondered if maybe this space could have been better utilised?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510698363255/2017-11-13---Paul-Curievici%2C--Owain-Browne%2C-Pauls-Putnins%2C-The-Lighthouse%2C-Shadwell-Opera%2C-directed-by-Jack-Furness%2C-Photo-Nick-Rutter-2017.jpg.jpg)
<figcaption>Paul Curievici, Owain Browne, and Pauls Putnin in *The Lighthouse*, Shadwell Opera, directed by Jack Furness. Photo: Nick Rutter.</figcaption>
</figure>

The confusion in the space translated into some confusion about the plot. Unfortunately, it wasn’t very clear that the trio of sailors from the opening were sitting before a board of inquiry, which also made the ending quite difficult to follow when it came. The first part of the opera was murky and perhaps could have been more interesting in its staging. Once they were inside the lighthouse for the second part, the production became much more effective and compelling.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510698352828/2017-11-13---Finnegan-Downie-Dear%2C-The-Lighthouse%2C-Shadwell-Opera%2C-2017-Photo-Nick-Rutter.jpg.jpg)
<figcaption>Finnegan Downie Dear conducts *The Lighthouse*, Shadwell Opera, directed by Jack Furness. Photo: Nick Rutter.</figcaption>
</figure>

The musicians played very well under the direction of Finnegan Downie Dear. Maxwell Davies' score is demanding and full of very tricky corners and the players managed with drama and atmosphere, conveying the impetus of the work through their playing. Similarly, there were lots of wonderful moments from the trio of singers: [Paul Curievici](/scene/people/paul-curievici/), [Owain Browne](/scene/people/owain-browne/) and [Pauls Putnins](/scene/people/pauls-putnins/). The music was very difficult and they navigated the tricky corners (mostly) with confidence and drama. The text of the work is very dense and strange, and we did sometimes lose text. I don't often wish for surtitles with English opera, but it may have been nice in this instanace.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510698373879/2017-11-13---Paul-Curievici%2C--The-Lighthouse%2C-Shadwell-Opera%2C-directed-by-Jack-Furness%2C-Photo-Nick-Rutter-2017.jpg.jpg)
<figcaption>Paul Curievici in *The Lighthouse*, Shadwell Opera, directed by Jack Furness. Photo: Nick Rutter.</figcaption>
</figure>

The cast of singers were strong, bringing the esoteric score to life. Curievici was a convincingly tender and strange Sandy - he was strong on stage, pulling the audience into his world easily. Browne played a devilish and tortured character in Blazes, navigating the vocal demands of the role alongside deep emotional turmoil. We sometimes lost intensity from him inside the lighthouse, especially during the longer runs of singing from the other characters. Putnins was a puritanical and fierce Arthur, chilling the audience with his unwavering and foreboding faith. The second half of the work certainly had the drama and intensity I wanted, carrying the audience along into a world which became ever-more depraved as it went on.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510698387221/2017-11-13---Paul-Curievici%2C--Owain-Browne%2C-Pauls-Putnins%2C-The-Lighthouse%2C-Shadwell-Opera%2C-directed-by-Jack-Furness%2C-Photo-Nick-Rutter-2017-(2).jpg.jpg)
<figcaption>Paul Curievici, Owain Browne, and Pauls Putnin in *The Lighthouse*, Shadwell Opera, directed by Jack Furness. Photo: Nick Rutter.</figcaption>
</figure>

>Stay in the loop with Shadwell Opera by following them on [Twitter](https://twitter.com/shadwellopera), [Facebook](https://www.facebook.com/shadwellopera/), and [Instagram](https://www.instagram.com/shadwellopera/).
