+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-07-03T11:40:00-06:00"
lastmod = "2017-07-03T22:22:00-06:00"
preamble = "Toronto-based choreographer and director [Matjash Mrozewski](/scene/people/matjash-mrozewski/) is currently at [The Banff Centre](/scene/companies/the-banff-centre/) working alongside [Against the Grain Theatre](/scene/people/against-the-grain-theatre/)'s Joel Ivany as choreographer and movement director on Claude Vivier's \"opéra ritual du mort\", [*Kopernikus*](https://www.banffcentre.ca/events/kopernikus/20170706/1930). \n\nMrozewski has recently added opera to his award-winning résumé, which includes dance, choreography, and theatre direction on both sides of the Atlantic. We spoke with him about the common ground between professional dancers and singers, and the illuminating experience of working on both sides of the rehearsal room.\n\nFeature image: [Aleksandar Antonijevic](https://www.instagram.com/asquaredphoto/)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499103717386/2017-07-03---Matjash-Mrozewski.jpg.jpg"
publishDate = "2017-07-03T22:07:00-06:00"
related_articles = ["articles/concept-production-real-reason.md","articles/soundstreams-musik-ende.md","articles/bumping-elbows-at-cfos-long-christmas-dinner.md"]
related_companies = ["scene/companies/the-friends-of-gravity.md"]
related_people = ["scene/people/matjash-mrozewski.md"]
short_description = "&quot;What fascinated me when I started talking to singers was this idea that in some cases they won&#039;t be ready vocally for some roles for another 5 to 10 years. It seems like a no-brainer now, but I remember thinking that this required a huge amount of patience and view of the long game.&quot;"
slug = "mrozewski-delight-wonder"
title = "Matjash Mrozewski: &quot;Delight &amp; wonder are great things.&quot;"
+++

## What did you learn or realize about working as a performer and a director when you moved from dance to exclusively choreography/direction?

I want to give you some really profound insight here, but mostly all I can think is that on either side of the room I'm full of doubt and insecurity, and want someone to tell me that I'm doing an okay job. 

Glibness aside, when I returned to performing after a five year break, being back on the rehearsal room floor reminded me of the exhausting work of constantly assimilating direction, working on technique and expression, all the while negotiating the many egos in the room.  Back at the front of the rehearsal hall,  I try to remember that when my inner taskmaster threatens to bust into overdrive.
 
## Since you've started working in opera, what have you found are the unique challenges for a director?

I will preface my answer by saying that I haven’t yet directed an opera, but I *can't wait for my first opportunity*. As in theatre or dance, opera directors need to inspire and orchestrate the forces of their on- and off-stage collaborators to create a compelling production. One of the challenges here is sharing valuable rehearsal and stage time with the music director. As a choreographer and future opera director I'm interested in how far you can push singers physically in the service of stage picture and drama, while still allowing them to feel stable enough to sing beautifully and confidently.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499103997851/2017-07-03---AA_MatMrozewski_5372.jpg.jpg)
<figcaption>Mrozewski (front) in rehearsal for *I Wonder* (Canada's National Ballet School). Photo: [Aleksandar Antonijevic](https://www.instagram.com/asquaredphoto/).</figcaption>
</figure>
 
## What do you see as common ground between professional dancers and opera singers?

An incredible awareness of their instrument, though in the singers' case, to me, the focus seems be on a much narrower part of the body. The notion of time also plays a role in each field, but in different ways. Dancers grow up with a sense of their impending best-before date and sometimes they need to stop dancing just as they're reaching peak artistic maturity. 

What fascinated me when I started talking to singers was this idea that in some cases they won't be ready vocally for some roles for another 5 to 10 years. It seems like a no-brainer now, but I remember thinking that this required a huge amount of patience and view of the long game.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499104068974/2017-07-03---MM---Comedy-of-Errors.jpg.jpg)
<figcaption>Dalal Badr and Allegra Fulton in *The Comedy of Errors* (Canadian Stage - Shakespeare in High Park). Photo: Paul Lampert.</figcaption>
</figure>

## What do you want to see onstage when you attend a show as an audience member?

I find things have been shifting for me. I've always been seduced by style and glamour and I do think that beauty is a valid ingredient in the performing arts. But if there's no idea alive beneath the surface, however pleasing, I tend to get bored more easily. But I won't lie: poor design choices can alienate my engagement and interest. I also want to see that everyone onstage is in the same production. A director's job is to get all performers inhabiting the same world. And I love a good *coup de théatre* – delight and wonder are great things.
 
<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499104076931/_U5A0578.jpg.jpg)
<figcaption>Cecilia Wretemark and David Schwindling in *Gefahrliche Liebschaften* (Konzert und Theater St. Gallen). Photo: Anna-Tina Eberhard.</figcaption>
</figure>

## Do you have a favourite opera?

Not yet. I spent many, many years gorging on Handel. During my MFA application interview I was asked what I would direct tomorrow, given the chance. And my answer was *Semele*. But I listen to and enjoy so many other Handel operas. If I rent a car, it's a chance to blare Mozart's *Mitridate, re di Ponto*. And I find Rameau's music so sexy. I'm actually listening to *Zéphyre* as I type this.

>[Kopernikus](https://www.banffcentre.ca/events/kopernikus/20170706/1930) plays at The Banff Centre July 6 and 8. For more on Matjash Mrozewski, visit his [website](https://www.matjash.com/) and follow him on [Instagram.](https://www.instagram.com/matjashmrozewski/)
