+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-12-03T23:28:00-05:00"
lastmod = "2015-12-05T11:14:00-05:00"
preamble = "[Against the Grain Theatre](/scene/companies/against-the-grain-theatre/) has spent the last two summers at [The Banff Centre](/scene/companies/the-banff-centre/), workshopping Artistic Director Joel Ivany's \"transladaptations\" of operatic staples by Mozart and Da Ponte. In 2014, they put up *#UncleJohn* (based on *Don Giovanni*), featuring soprano [Miriam Khalil](/scene/people/miriam-khalil/) as Donna Elvira; Khalil has since reprised Elvira in *#UncleJohn* for two subsequent productions, in at Toronto's The Theatre Centre and at the Ottawa Chamber Music Festival. The following year at the Banff Centre, fellow Canadian soprano [Shantelle Przybylo](/scene/people/shantelle-przybylo/) took on the role of Felicity (also known as Fiordiligi) in AtG's *A Little Too Cozy*, based on *Così fan tutte*.\n\nIn 2016, both sopranos will sing their respective roles in Italian for the first time; in February, Przybylo joins the [Dutch Touring Opera](http://www.reisopera.nl/programma/cosi-fan-tutte/) production of *Così fan tutte* as Fiordiligi, and Khalil reprises Elvira in her more \"traditional\" form with [Opera Tampa](http://www.strazcenter.org/Events/Opera/Shows/1516_Opera/Don-Giovanni) in April. The two ladies talk about their unique trajectories with these characters, and what it's like to switch languages (and centuries)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1449255752872/2015-12-03%20-%20MiriamShantelle.jpg.jpg"
publishDate = "2015-12-05T11:14:00-05:00"
related_companies = ["scene/companies/against-the-grain-theatre.md","scene/companies/indie-opera-to.md","scene/companies/the-banff-centre.md"]
related_people = ["scene/people/miriam-khalil.md","scene/people/shantelle-przybylo.md"]
short_description = "In 2014, they put up #UncleJohn (based on Don Giovanni), featuring soprano Miriam Khalil as Donna Elvira; Khalil has since reprised Elvira in #UncleJohn for two subsequent productions, in at Toronto&#039;s The Theatre Centre and at the Ottawa Chamber Music Festival. The following year at the Banff Centre, fellow Canadian soprano Shantelle Przybylo took on the role of Felicity (also known as Fiordiligi) in AtG&#039;s A Little Too Cozy, based on Così fan tutte."
slug = "mozart-ladies-with-a-twist-miriam-khalil-shantelle-przybylo"
title = "Mozart ladies with a twist: Miriam Khalil &amp; Shantelle Przybylo"
+++

## Two unique character back-stories

**Miriam**: When I first learned Elvira (*Don Giovanni*), I was in a repertoire transition. I was transitioning into full lyric repertoire after having a baby. I wanted to try Elvira in a safe and supportive environment so that I could feel free to explore this character without the pressure of being precious and careful with it. The Banff Centre's Open Space Program was the ideal situation for that. The same show was done in two more productions with [Against the Grain Theatre](/scene/companies/against-the-grain-theatre/), one in Toronto and one in Ottawa, so three different productions of the same show in one year.

**Shantelle**: Felicity in *A Little Too Cozy* is still the strong-willed, confident character that is projected in the original *Così fan tutte.* Since Felicity is the older, more mature sister, she is also always trying to be a role model and care giver for her sister Dorabella. In both versions, "Come scoglio"("Like an anchor") is a clear example of Fiordiligi (Felicity) being not only defiant but also setting an example for her sister. 

Another contrast is the journey and discovery Fiordiligi (Felicity) encounters in "Per pietà". In Ivany's version, Felicity feels immense guilt towards her fiancé when she starts developing strong feelings for another man. Ultimately, she comes to the conclusion that her fiancé (whom she has never seen before) is too good for her. However, in Da Ponte's version, her guilt for falling in love with another man has led her to decide that it is wrong to be unfaithful to herself and to him, and that she must go to the battle field to find him. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1449252583661/A-Little-to-Cozy-2---resized.jpg.jpg)<figcaption> Pascale Spinney (Dora), Shantelle Przybylo (Felicity), Brent Calis (Elmo) and Aaron Sheppard (Fernando) in Against the Grain Theatre's *A Little Too Cozy*, The Banff Centre, 2015. Photo by Don Lee.</figcaption>
</figure>

**Miriam**: Singing the role in English before doing it in Italian, is definitely informative. My first time singing Elvira in Banff was a discovery of how to pace the role. The second production was in Toronto. That experience was great because I knew where the problem areas were and I knew I could get through it, so I focused on the character's journey and worked on vocal colour and character subtleties. I still hadn't reached my ideal though and knew there was work to be done (as always). It's amazing to see how a role can evolve when you've let it steep for a bit.

**Shantelle**: Overall, I believe it will not be so much a change in personality that I will have to create as it will be a change in deportment - moving from the 21st century to the late 18th century.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1449252666326/khalil%20uj.jpg.jpg)<figcaption>Miriam Khalil as Elvira in Against the Grain Theatre's *#UncleJohn*, The Banff Centre, 2014. Photo by Rita Taylor.</figcaption>
</figure>

## 2. In terms of vocal technique, how is it to transition from English into Italian?

**Miriam**: When we sing in a language that is not native, we translate word for word. Although we know and understand what we are saying, we are still translating it into a familiar language in our mind when singing it. However, when it is sung in a very familiar language, this step is gone and it automatically connects to thoughts and emotions. Colouring the words becomes instinctive rather than studied. This is so informative because we can then bring that colour into the Italian and more likely look for those moments rather than just relying on what is written, but rather emphasizing what is written.

**Shantelle**: Even though English is my native tongue, I always find that it is the most difficult language to sing and articulate. It is also one of the most challenging languages for audiences to understand clearly. In an effort to have clear diction, I often catch myself and other singers wanting to over-annunciate and pressurize consonants which then impedes greatly on the legato line.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1449252714633/A-Little-to-Cozy-6.jpg.jpg)<figcaption> Caitlin Wood (Despina), Pascale Spinney (Dora), and Shantelle Przybylo (Felicity) in Against the Grain Theatre's *A Little Too Cozy*, The Banff Centre, 2015. Photo by Don Lee.
</figure>

**Miriam**: Like most opera singers, I find English a more difficult language to sing in. The vowels contain diphthongs and consonants need to be crisp and clear and much more aspirated. Italian is known for its pure vowels, dry consonants and ease. However, Mozart is brilliant (as we all know) and even in modern English, style comes first. Doing it in Italian after having done it in English feels much easier. I feel particularly lucky to perform it in Italian after having worked it out in English, not in one production, but three. It's comfortably challenging now. I know the notes and have negotiated them into my voice and body. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1449252909696/UJToronto.jpg.jpg)
<figcaption>Sean Clark (Ottavio), Miriam Khalil (Elvira), Betty Allison (Anna), Neil Craighead (Leporello), Aaron Durand (Masetto), Sharleen Joynt (Zerlina), in Against the Grain Theatre's production of *#UncleJohn*, December 2014. Photo by Darryl Block.</figcaption>
</figure>

**Shantelle**: I had the privilege of coaching the role Felicity with a phenomenal coach, [Maika'i Nash](/scene/people/maikai-nash/), who had me approach the role in English as if I was always singing in the bel canto Italian style. He constantly was reminding me to sing to the end of each phrase and sing through the consonants with ease, thinking vowel to vowel and highlighting the important words of each phrase (as we would do in Italian or any other language). Having learnt the role in English with these concepts in mind, the transition into learning and singing the role in Italian has been a fluid one.

>For more, follow [Miriam Khalil](https://twitter.com/SongbirdKhalil) and [Shantelle Przybylo](https://twitter.com/przybylo) on Twitter, and find out more about Opera Tampa's [*Don Giovanni*](http://www.strazcenter.org/Events/Opera/Shows/1516_Opera/Don-Giovanni) and the Nederlandse Reisoper's [*Così fan tutte*](http://www.reisopera.nl/programma/cosi-fan-tutte/).
