+++
author = ["authors/michael-calderone.md"]
categories = "Review"
date = "2017-11-17T16:03:00-05:00"
lastmod = "2017-11-17T18:15:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510960259428/2017-11-17---square---HIRESCFOAsOneNovember15-4.jpg.jpg"
primary_image_credit = "Samantha Attaguile and Jonathan Wilson in As One, Chicago Fringe Opera, 2017. Photo: Victor LeJeune."
publishDate = "2017-11-17T16:50:00-05:00"
related_articles = ["articles/tenor-mezzo-transition.md","articles/as-one-they-both-took-risks-that-paid-off.md"]
related_companies = ["scene/companies/chicago-fringe-opera.md"]
related_people = ["scene/people/samantha-attaguile.md"]
short_description = "The libretto by Mark Campbell and Kimberly Reed is linear in structure and sheds light on Hannah&#039;s childhood, college years, and her search for identity. Hannah&#039;s recollections are personal but also relatable: we discover that she wore a stolen blouse beneath her jacket on her paper route and first found the word &quot;transsexual&quot; in a card catalog in the public library."
slug = "moving-stories-as-one-at-chicago-fringe-opera"
title = "Moving stories: As One at Chicago Fringe Opera"
+++

*As One*, a chamber opera for two voices and string quartet composed by Laura Kaminsky and with a libretto by Mark Campbell and Kimberly Reed, conveys the experiences of a transgender protagonist named Hannah, as she seeks to reconcile her internal identity with the outside world. First commissioned and developed by [American Opera Projects](/american-opera-projects-youre-seeing-the-opera-in-microcosm/) and performed at the Brooklyn Academy of Music in 2014, these performances by [Chicago Fringe Opera](/scene/companies/chicago-fringe-opera/) are *As One*'s Chicago premiere.

Kaminsky's conception of the piece is intriguing and its strongest attribute. Hannah Before is sung by a baritone, here the resonant Jonathan Wilson; Hannah After is sung by a mezzo-soprano, here the steely-voiced [Samantha Attaguile](/scene/people/samantha-attaguile/). These cisgendered singers take turns relaying Hannah's thoughts and experiences in this autobiographical, journal-like work. We benefit from the rich and often messy psychology of hearing both perspectives throughout the opera: early on Hannah After serves as a reassuring "It Gets Better" presence for Hannah Before, and later in the opera Hannah Before keeps Hannah After aware of her past.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510960369782/2017-11-17---HIRESCFOAsOneNovember15-17.jpg.jpg)<figcaption>Jonathan Wilson and Samantha Attaguile in *As One*, Chicago Fringe Opera, 2017. Photo: Victor LeJeune.</figcaption>
</figure>

The libretto by Mark Campbell and Kimberly Reed is linear in structure and sheds light on Hannah's childhood, college years, and her search for identity. Hannah's recollections are personal but also relatable: we discover that she wore a stolen blouse beneath her jacket on her paper route and first found the word "transsexual" in a card catalog in the public library. We also learn of her desire to hide who she is and be a strong, successful, "normal" boy. We later hear about her hormone therapy, the surprise and sheer joy she feels being called "Miss" by a stranger, and the awkwardness of flirting for the first time with a cute boy at a coffee shop. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510960397031/2017-11-17---HIRESCFOAsOneNovember15-9.jpg.jpg)<figcaption>Jonathan Wilson in *As One*, Chicago Fringe Opera, 2017. Photo: Victor LeJeune.</figcaption>
</figure>

Significantly, one of the vignettes recounts the violence Hannah encounters as a transgender person: Hannah After tells of being approached by a stranger as she heads to her car in a parking lot. The man blocks her way, repeatedly asks "What ARE you? What the fuck ARE you?" and attempts to strangle her. She kicks him, and is able to get into her car and escape, but her attacker is not far behind. Attaguile crudely snarled the words of her attacker to great dramatic effect.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510960425084/2017-11-17---HIRESCFOAsOneNovember15-11.jpg.jpg)<figcaption>Samantha Attaguile in *As One*, Chicago Fringe Opera, 2017. Photo: Victor LeJeune.</figcaption>
</figure>

I kept waiting for the string quartet to follow Hannah's lead, dig in, and play with a similar aggression and intensity, but they did not deliver this type of playing. The quartet, made up of instrumentalists from Zafa Collective and led by conductor Alexandra Enyart, otherwise performed throughout the evening with sensitivity towards the singers and a unified sound, but this scene needed more bite to better support the tense danger on stage.

Hannah is deeply relieved to be safe - this time. She knows that she might not be so lucky in the future. Throughout Hannah After's monologue, Hannah Before recites the names of transgender people from all over the world who have been the victims of murderous attacks. This juxtaposition of spoken and sung text, both expressing the kind of horrific violence transgender people face every day, was powerful. Hannah After internalizes the words of Hannah Before and she sings with resignation "There are others. I am not safe."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510960436290/2017-11-17---HIRESCFOAsOneNovember15-8.jpg.jpg)<figcaption>Jonathan Wilson and Samantha Attaguile in *As One*, Chicago Fringe Opera, 2017. Photo: Victor LeJeune.</figcaption>
</figure>

Kaminsky's lyrical score accompanies Hannah's vignettes with passages of pulsing minimalism, Copland-esque syncopations, and chant-like, melismatic vocal lines. At times, the music illustrates the action on stage or the meaning of the text and while that can be a bit too obvious, it does create some beautiful effects. When Hannah After describes having a grade school assignment returned because her cursive was too loopy (clearly, too feminine for a boy), she sings "generous loops…" on a long melisma, while tracing those same generous loops in the air. When she tells of washing down hormone replacement pills with a strong martini, we hear an irregular and drunken thudding in the cello, and disorienting glissandos in the violins. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510960487678/2017-11-17---HIRESCFOAsOneNovember15-6.jpg.jpg)<figcaption>Alexandra Enyart conducts *As One*, Chicago Fringe Opera, 2017. Photo: Victor LeJeune.</figcaption>
</figure>

In the final scene in the opera, Hannah take a solitary trip to Norway, hoping to see the Aurora Borealis. In solitude, she discovers that she has the power to control her own happiness, and returns home with stronger sense of closure and reconciliation than when she arrive in Norway. Chicago Fringe Opera should be commended for choosing to perform this Chicago premiere at the Center on Halstead, the midwest's largest LGBTQ community center. The 161-seat theater was a perfect fit for this intimate chamber opera, and should help give the company, work, and art form of opera itself a deserved wider audience.

>Chicago Fringe Opera's [*As One*](http://www.chicagofringeopera.com/?program=as-one) runs through November 19. For details and ticket information, follow our box office links below.
