+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-04-21T08:09:00-04:00"
lastmod = "2017-04-21T15:10:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1492782662561/2017-04-21---Skills.jpg.jpg"
publishDate = "2017-04-21T10:02:00-04:00"
related_articles = ["articles/giving-up-caring-too-little-and-other-taboos.md","articles/why-this-opera-singer-took-a-nonsinging-job-at-an-opera-company.md"]
short_description = "In my own experience, coaching singers is kind of like journalism. There&#039;s a foundation of knowledge that continues to grow, but with every new singer - and every new story - there&#039;s the possibility of having your mind changed."
slug = "moving-on-up-3-ways-my-old-career-prepared-me-for-my-new-one"
title = "Moving on &amp; up: 3 ways my old career prepared me for my new one"
+++

The other day, we shared an article called ["Giving up, caring too little, and other taboos"](/giving-up-caring-too-little-and-other-taboos/). It was about how pursuing a career as a performer can become too difficult, and how lots of people decide to bow out and turn to other professional paths. The "taboo" bit comes up, because for the people deciding whether or not to stay in the performer's volatile, nomadic, and unpredictable world, it can feel like the decision is really between success and failure.

Honestly, if you had asked me 10, even 5 years ago, if I would ever consider stopping what I was doing - coaching singers, playing opera rehearsals, being a go-to choice for an audition pianist - I would have scoffed. I was doing exactly what I was meant to do, what I was good at, and what I enjoyed most. Why would I quit?

Then, the job seemed to shift. There had always been some unsavoury parts - chasing after those who owe you money, working with horridly disorganized people, having little financial stability to show for all those hours of practice - but like a switch, those unsavoury things grew to overshadow the joy of the work. Maybe it was unwise, but I figured that if I worked hard, and strove for "better" gigs, working with "bigger" organizations, the money-chasing and disorganization would stop; and it was a hard pill to swallow to discover that the same crap could be found just as often at the "top" as it had been in my days of so-called grunt work.

I knew that the job didn't owe me anything, but I also knew that most of the time, I didn't have enough patience to make the good outweigh the bad. And so, I've found myself in the same place as many of you may be: I take the piano-centric work that I know fulfills me, and I spend a large proportion of my time doing something else (like creating and growing Schmopera.com).

One of the reasons that it's scary to think of shifting away from a performing career is the dreaded feeling that we're wholly unqualified to do anything else at all. It's true that music education can provide the building blocks for lots of strengths - fine motor skills, literacy, self-discipline, teamwork - but as you move up the ladder of musical training, it can get ultra-focused and specialised.

*Where do I put "can read alto clef" in my résumé?* you may ask. *Where else can I apply my understanding of the vocal passaggio?* Aside from being a contestant on a rather lucky game of *Jeopardy!*, these questions raise valid points.

Anecdotal as it may be, I wanted to share the skills that undoubtedly have transferred well from my days as a pianist and voice coach to my days as an arts writer.

## Returning emails & using a calendar

No, I'm not perfect at it. But it didn't take me long to realize that returning emails quickly is the best - nay, only - way to stay sane, get paid, and preserve your professional reputation. As a pianist, I had plenty of clients, all asking me to show up for lessons, rehearsals, and performances, and there no way was I going to trust my own memory for all of that. Return the damn email, put the time in your calendar *immediately*, done. (This was even before the days of being able to "snooze" an email - what a time to be alive.)

As a writer, I'm still essentially self-employed, putting out into the world the reputation of my business with my own actions. For every article I publish, I have about 20 that are in the works; some of them are time-sensitive, like when I'm promoting a show or publishing a review, some of them depend on my getting information and materials sent from artists and their agents, and some are good ideas I've come up with, that I don't want to forget about. 

Thankfully, my love of Google Calendar and my aversion to being behind on emails have both been well-groomed from my days as a freelance pianist. I have my ongoing to-do list, sorted by due date, and the people I write about don't get ignored. Everybody wins.

## Listening to singers

Singers get a bad rap. They get pegged as loud and flakey, and sometimes they earn themselves a prejudicial reputation for having substandard musical skills. Now, I won't say there aren't singers out there who don't warrant that bad rap (they're more common in the early years of a undergrad degree in music), but I will say that pianists who become vocal coaches are connective forces between the "worlds" of singers and instrumentalists.

I watched as singers, who started their musical studies much later than I had, learned the same skills at what seemed like breakneck speeds; plus, they had the guts and bravery to *sing in public*, something that few instrumentalists would ever dare to do. The best coaches are the pianists who, early on, respect and listen to singers. They listen while they're singing, but more importantly, they listen when they speak. Singers are raised to listen to the person at the piano, and it seems only fair that the pianist learns to meet a singer in the middle ground between their respective skill sets. You can decide they're loud, flakey, and stupid, or you can decide that their process is different, and have a much more productive time.

As a writer, I interview singers all the time. They're totally fascinating, and my readers seem to agree. Singers tell me all sort of weird things, like the shape of their favourite pillow, or how they always travel with their lucky spork, or whether or not their dogs like it when they practice. They're delightfully weird, and all of that weirdness comes from the same people who can do the incredible things they can do onstage. Stereotype all you want, but I'll listen to any weird spork story that comes out of the same mouth which makes me sink happily into my opera seat.

## Knowing what I don't know

In my own experience, coaching singers is kind of like journalism. There's a foundation of knowledge that continues to grow, but with every new singer - and every new story - there's the possibility of having your mind changed. 

I used to think I could hear the difference between a real rolled R and one of those uvular cheats, until I met a singer who was *really good* at uvular cheating. I used to think that opera companies had the same list of priorities as the singers they hire, until I spoke to people who run opera companies.

As a young coach, I often spent hours scrambling in preparation for the work I did with singers, entirely aware that there were things I could help them with, and things I had little hope of truly understanding. The middle ground comes in the things that singers and pianists can learn alongside each other. I think honest journalism comes from a similar balance, pairing what you know with what you don't, and resisting the urge to fill in the gaps of unanswered questions.

>Readers, be honest: what skills did you learn as a musician, that you apply elsewhere? Tell us your story in the comments below, or get in touch at [hello@schmopera.com.](mailto:hello@schmopera.com)
