+++
author = ["authors/jeremy-hirsch.md"]
categories = "Review"
date = "2017-12-13T19:10:00-05:00"
lastmod = "2017-12-18T08:26:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513602795677/sq---Dear-Edvard_0423_.jpg-for-schmopera.com.jpg.jpg"
primary_image_credit = "Dear Edvard, National Sawdust, 2017, Photo: Jill Steinberg."
publishDate = "2017-12-18T08:18:00-05:00"
related_articles = ["articles/tarrare-the-freak-i-just-want-to-be-full.md","articles/why-our-artistic-roots-matter.md"]
short_description = "The piece hones in on Munch (Tim McDevitt) who, having admitted himself to a sanitarium, is treated by an impressionable, young nurse (Pearl Sun). Enamored of her celebrity client, she takes charge of his unconventional treatment. In lieu of shock therapy, this fictional version of Munch undergoes a series of role-playing reenactments in order to relive the traumatic events that formed his personality; a conceit no more plausible than say, time travel."
slug = "more-than-the-scream-dear-edvard"
title = "More than The Scream: Dear Edvard"
+++

Edvard Munch painted "The Scream". But what else is he known for? That famous painting has confined him to one-hit-wonder status in the American popular imagination. But, the art world regards Munch as an iconoclast known both for innovations in painting and printmaking and for his confrontational, candid subject matter. Munch bucked persistent conservative trends of late 19th-century art, inadvertently birthing the German expressionist movement. His oeuvre is vast. "The Scream" is a minor masterpiece. How and when will his legacy with the American public catch up to the breadth of his artistic accomplishments?
 
Dramatic representation of an artist's life can buoy a treading reputation. Consider Salieri in Miloš Forman's film adaptation of *Amadeus*. The inconsequential composer has become an icon of jealous villainy. Or better yet, George Seurat in Stephen Sondheim's *Sunday in the Park with George*. Sondheim's score and Mandy Patinkin's voice have guaranteed Seurat's staying power with a non-museum set. Or Jim Carrey's Andy Kaufman in another Miloš Forman gem, *Man on the Moon*. With a recent, electrifying documentary about the film's creation, Kaufmann is having new life for the post-comedy-boom, it's-my-parents'-Netflix-account generation.

So what about Edvard Munch? His life is well suited to dramatic treatment; he suffered through a tragic childhood and adolescence, scandalized the traditional art world, had tumultuous relationships with compelling women, lapsed into an alcohol-fueled breakdown that landed him in the psych ward, and was a bona fide, obsessive genius. The major motion picture will have to wait. However, he is the subject of a new music-theater piece called *Dear Edvard*, (composer Steven Schoenberg; lyricist/poet Richard Michelson; director Kevin Newbury) that was recently presented in concert as part of National Sawdust's annual "Winterreise Nights Festival", a series curated with [Schubert's masterwork song cycle](/a-generous-winterreise-at-wigmore-hall/) in mind.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513602936914/Dear-Edvard_0172_.jpg.jpg)
<figcaption>*Dear Edvard*, National Sawdust, 2017, Photo: Jill Steinberg.</figcaption>
</figure>
 
The piece hones in on Munch (Tim McDevitt) who, having admitted himself to a sanitarium, is treated by an impressionable, young nurse (Pearl Sun). Enamored of her celebrity client, she takes charge of his unconventional treatment. In lieu of shock therapy, this fictional version of Munch undergoes a series of role-playing reenactments in order to relive the traumatic events that formed his personality; a conceit no more plausible than say, time travel.
 
The narrative focuses on two major threads of Munch's life: first, on his romantic involvement with four different women during the first half of his days. Second, on the familial tragedies that plagued his early years including his mother and older sister's premature deaths, and his younger sister's descent into madness. These events are interwoven with reflections by Munch and his nurse as they work their way through his treatment. The piece is framed by an elderly version of the nurse, who tells the story retrospectively. The drama divides into 26 brief scenes, each matched with a painting by the artist.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513602947008/2017-12-18---Dear-Edvard_0284_.jpg.jpg)
<figcaption>*Dear Edvard*, National Sawdust, 2017, Photo: Jill Steinberg.</figcaption>
</figure>

Two relationships in particular work dramatically, one in the romantic section and one in the family section. When Munch rebuffs his volatile fiancée Tulla Larsen (the third of four lovers) in favor of his artistic pursuits, a fight ensues that results in a fumbled gun shot that blasts off the artist's finger (take that, Van Gogh). The piano rumbles with fierce bass tremolo and smashing dissonances. Mr. McDevitt and Ms. Sun's voices, not up for the operatic grandeur of the musical explosion, nonetheless delivered fiercely barbed retorts worthy of the overblown feud.

Munch often revisits the death of his 15 year-old older sister Sophie in his art. Evidently the loss profoundly affected him. Schoenberg and Michelson allot the most patience and care in their treatment of Sophie and Edvard's relationship. Ms. Sun, who throughout the evening convincingly shape-shifts into the disparate array of women, uses her keenest transformational tactics to play the teenage Sophie. She slims down and brightens her vocal timbre to give it the innocent sound of a perpetual smile. Through a subtle facial transformation, her cheeks plump as she adopts a toothy, wholesome grin that rids her face of aging.

A duet ensues between Sophie and young Munch that risks but does not succumb to sappiness. In the duet, Munch has fallen ill, coughing intermittently. His sister comforts him. Over the course of the duet, the cough shifts from Munch to Sophie. The more he recovers, the sicker she becomes. The fatal contagion brings the young girl to her demise. Her death teaches Munch that intimacy begets anguish, a lesson that defines his inability to hold a healthy romantic relationship in his adult life.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513602961881/Dear-Edvard_0203_.jpg.jpg)
<figcaption>*Dear Edvard*, National Sawdust, 2017, Photo: Jill Steinberg.</figcaption>
</figure>
  
Schoenberg's music is tonal and uses dissonance sparingly for effect. His pleasantly familiar music-theater style employs devices like lilting waltzes, oom-pah piano accompaniment, lingering suspended chords, evocative major sevenths, persistent quarter-note ostinatos, half-note chords supporting recitative-like chatter, propulsive pop-ballads, liquidly repeating arpeggios, and, in the younger sister's mad scene, flurried, Sondheim-esque patter. Transitions were deft – a general mark of quality. The pianos figurations and harmonies dictated mood. In rare moments the piano entered the foreground to comment tastefully.
 
Music director/pianist Paul Masse had a sonorous yet transparent touch. He spun an unobtrusively buoyant web that carried the text well. Hardly a syllable was dropped.
 
The actors' voices suited the style. Both were light, speaking easily, tending away from the dark timbre and full vibrato of acoustic operatic singing that can obscure intelligibility. Both Mr. McDevitt and Ms. Sun delivered detailed musical and theatrical interpretations. The mercifully brief drama never sagged in their hands – impressive considering the lack of costumes, sets, props, and other helpful stage accoutrements.
 
The show did not crack the surface of Munch's particular genius. Considerable words are spent explaining his family's general religious associations, but Munch's relationship to faith or the church was hard to grasp. A rumination on the tired topic of whether an artist's creativity suffers if his mental illness is treated yielded no particular insight. Likewise with a speech exploring the manufacturing and exploitation of personality for fame. Neither painting nor printmaking, central to Munch's life, were deeply considered, a shame because Munch's innovative art making process is the most rewarding surprise upon discovering the depths of this yet unsung (excuse the pun) master.
 
If you are in New York City before February 4th, visit the MET Breuer and see the artist's work in person. That, I highly recommend.
