+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-05-21T12:29:00+01:00"
lastmod = "2016-05-22T10:47:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463831841537/2016-05-21---Westmister-Abbey.jpg.jpg"
publishDate = "2016-05-21T13:06:00+01:00"
related_articles = ["articles/who-cares-what-bring-on-the-why.md","articles/my-wtf-lightbulb-moment.md","articles/the-business-of-passion.md","articles/on-the-ego.md","articles/4-ways-that-opera-really-is-life.md","articles/music-religion-irony.md"]
short_description = "Does it mean that all art is rooted in the morbid? A desperate attempt to sweep the dust of life under a beautifully crafted rug? A shout into the constant turnover of individual humans sharing their time on Earth, asking &quot;does anyone care that I&#039;m here?&quot;"
slug = "morbid-musings-art-death"
title = "Morbid musings: art &amp; death"
+++

How about some morbidity to kick off the weekend, readers?

Like many of you, to be sure, we enjoy the odd deep think. Passing by a particularly beautiful church, or some seemingly random sculpture that's been put up in the middle of the city, or even watching a jogger run by all red-faced and sweaty - these things have a common root cause. Humans are aware that we all die.

The jogger is hoping to prolong his life, and enjoy health for as long as he can. Maybe he's even trying to see if he can run insane distances with enough practice. That random art on the street adds a moment of curiosity and admiration to passers-by, and the artist who created it has the chance to quietly demonstrate honed skills. Churches are another thing altogether; there's a more acute sense of looking *up*. Up, in the sense of deities and forces and imagined second worlds, away from the one we're currently in; "up" can also mean forward, in that creating a wholly impressive building, with stunning, time-consuming stained-glass windows and arches that impress architects and aesthetes alike, will leave behind something, some *thing* that will outlive all of us.

Music achieves the same. Composers like Bach, Mozart, Beethoven, Mahler, and Wagner have all achieved a form of real immortality with their music. It's almost better than actual immortality, since the humans of today remember the best they had to offer; maybe Bach had horrible body odour, and Mozart may have been just the most annoying thing to hang out with, and Wagner was no doubt an insufferable egomaniac. These things go forgotten, but their work, in all its apparent perfection and emotional infusion, stays alive.

Art isn't just the product of people who want to leave personal legacies. No doubt not every human who creates something artistic cares whether or not he or she leaves something meaningful behind. There are likely more people making art for the fun of it than for the available spots in the history books of the human species.

Yet even the small and immediate catalysts for making something meaningful come out of an awareness of one's own mortality. We know our lives are short and finite, and so we want to make the most of it. We want to stretch our own physical limits, and so we have sports (and singing, really). We want to solve mysteries, and so we have philosophy. We *really* want there to be a point to all of this earthly stuff, and so we have religion.

But making the most of life also means we want to enjoy ourselves. We seek love, and that comes with elation and rejection. We seek sex, and that comes with ecstasy and frustration. We like to "win" at life, so we wonder whether or not we're "good enough" at being human; that comes with competitiveness, insecurity, and pride. Do we have a nice enough apartment? Can we cook the best meal to bring to a potluck? Do we own enough land? Did we get enough girls or boys to lust after us?

This short list of experiences - elation, rejection, ecstasy, frustration, competition, insecurity, pride - which of these hasn't had a piece of art made in the name of it? Love songs, breakup songs, songs about wanting and not getting, songs about feeling horrible and wonderful about oneself, they all exist. Even if they're not the subject of the art itself, they're often the reason the art is created. "I am sad because he left me, and I'm going to distract myself with this guitar," or "If I become a wicked rapper, all the girls will want to sleep with me," or "I want God to know that I'm grateful for what I've been given, and so I'm going to write a song about that." 

It can be exposing, almost laughable to distill our artistic motivation into these basic thoughts. No doubt, there are people with better reasons than the ones above, and likely people with worse ("If I run many, many kilometres, I will finally be hot enough for *him* to want me.")

Art is like this huge, universal support group for the entire human race. On the smallest scale, we all know that problems can seem less painful when we talk about it. Better yet, when we talk about it with someone who understands the problem. (That's a huge part of why artists have so many artist friends.) The thing about knowing you're going to die, that's something that almost everyone in the world also knows, save for babies and the tragically (?) unaware. By building huge, impressive churches, writing great music, painting beautiful people, it's like we're all sitting in a massive circle, raising our hands and telling our stories to the rest of the group.

Does it mean that all art is rooted in the morbid? A desperate attempt to sweep the dust of life under a beautifully crafted rug? A shout into the constant turnover of individual humans sharing their time on Earth, asking "does anyone care that I'm here?"
