+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2019-03-04T10:20:54+00:00"
disclaimer = ""
image_gallery = []
postamble = "American Baroque Opera Company's presentation of _Montezuma_ happens March 15-17, 2019, at Arts Mission Oak Cliff in Dallas, TX. For details and ticket information, [click here](https://www.eventbrite.com/e/montezuma-by-vivaldi-tickets-48635837098)."
preamble = "This post is sponsored by American Baroque Opera Co."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1551487349/media/2019/03/sqMontezuma.jpg"
primary_image_credit = ""
related_articles = ["articles/5-people-who-would-make-great-opera-roles.md", "articles/forgiving-racism-onstage.md"]
related_companies = ["scene/companies/american-baroque-opera-co.md"]
related_people = ["scene/people/ryan-kuster.md"]
short_description = "If we look too closely with our 21st-century lens, Montezuma could be seen as problematic. Why champion the Spanish, when their colonialism was so vicious?"
slug = "vivaldis-aztec-exoticism-montezuma"
title = "Vivaldi's Aztec exoticism: Montezuma"
youtube_url = ""

+++
Dallas-based American Baroque Opera Company is mid-way through its 2018-19 season, entitled "Myths and Legends." Indeed, with pieces like Purcell's _Dido and Aeneas_, and Scarlatti's _Venus & Adonis_, ABOC has the myths covered. Yet their production of [Antonio Vivaldi's _Montezuma_](https://www.eventbrite.com/e/montezuma-by-vivaldi-tickets-48635837098), presented March 15-17, 2019, stands out among their line-up as the only work based in the legends of real-life history.

Listening to his score, there's nothing to suggest that _Montezuma_ is one of the very first operas set in North America. Composed in 1733, the opera looks far to the West for its exotic appeal, telling the story of the last days of Moctezuma II, the 15th- and 16th-century Aztec Emperor who died in 1520 during the Spanish Conquistador expedition led by Hernán Cortés.

> This recently-revived opera is a trove for those who love history.

Vivaldi's musical style is inescapable; his operas make demands on its singers that separate those who can sing his music - furious coloratura, fast repeated notes, and impossibly large leaps - and those who cannot. Bass-baritone [Ryan Kuster](/scene/people/ryan-kuster/) is making his ABOC debut in the title role of _Montezuma_, set to wow audiences with his laser-like tone and the dizzying agility he has up his sleeve.

When we think of "exotic" operas - _Carmen_, _Madama Butterfly_, _The Pearl Fishers_ - we often think of a score that reflects the musical aesthetic of somewhere very far away. But Vivaldi's _Montezuma_ - in some versions, titled _Motezuma_ - sounds like something entirely Italian in origin, as though it could tell a story of a Roman Emperor or deity from Greek Mythology.

> As music critic Mark Swed puts it, _Montezuma_ is the "Baroque equivalent of many a summer movie."

If we're feeling generous, we could speculate that Vivaldi purposefully opted to give _Montezuma_ the same musical aesthetic as he did his operas based on Italian epic poetry or Greek mythology; perhaps he was making the statement that a ruler is a ruler, no matter how far away his kingdom, and so the music Vivaldi wrote for the Aztec Moctezuma II is bound to share a style with his music for the Greek Griselda, or the Ottoman Bajazet.

What's more likely is that Vivaldi had little access to the aesthetic of Aztec music, and was content to let his own compositional style shine through all his heroes and heroines, including Moctezuma II.

> The whole thing wraps up with a definitely fictional happy ending - plus a little old-world Eurocentrism thrown in for good measure.

After all, _Montezuma_ is not really an opera that recounts history; it may revolve around historical figures, but Vivaldi's opera is full of fantasy. The Aztec Emperor grapples with the Spanish invaders (true), his daughter finds unlikely love among the Conquistadors (debatable), and the whole thing wraps up with a definitely fictional happy ending - plus a little old-world Eurocentrism thrown in for good measure. As music critic Mark Swed puts it, _Montezuma_ is the "Baroque equivalent of many a summer movie."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1551717295/media/2019/03/RyanKuster.jpg){{% /md %}}

<figcaption>Bass-baritone Ryan Kuster, singing the title role in American Baroque Opera Company's production of Montezuma.</figcaption>

</figure>

There's actually more history around the opera than in it. _Montezuma_ saw few performances after its 1733 premiere, and the score was thought to be lost, until musicologist Steffan Voss rediscovered it in 2002. For its time, _Montezuma_ comes with some surprises: there's no chorus, and, perhaps exposing a thinly veiled opinion on the wild and exotic world of the Mexican Aztecs, the foreign leader Moctezuma II is sung not by a castrato (the voice type often reserved for important European men), but by a delightfully savage baritone voice.

> It may revolve around historical figures, but Vivaldi's opera is full of fantasy.

If we look too closely with our 21st-century lens, _Montezuma_ could be seen as problematic. Why champion the Spanish, when their colonialism was so vicious? And why set a story in the New World if it's nothing more than an exotic packaging for familiar operatic tropes?

Of course, these are unfair questions to ask of _Montezuma_, and of Vivaldi, who composed with his own style and for his own audiences. This recently-revived opera is a trove for those who love history, and _Montezuma_ reveals what 18th-century audiences were eager to see and hear: digestible tastes of a far-off culture, a few casualties, and a happy ending. And of course, vocal prowess that borders on the divine.