+++
author = ["authors/andrew-schneider.md"]
categories = "Review"
date = "2019-03-29T18:18:39+00:00"
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1553883852/media/2019/03/sqMontezuma.jpg"
primary_image_credit = "A scene from Montezuma, American Baroque Opera Co., 2019. Photo courtesy of ABOC."
related_articles = ["articles/montezuma.md"]
related_companies = ["scene/companies/american-baroque-opera-co.md"]
related_people = ["scene/people/ryan-kuster.md"]
short_description = "While Handel provides so many details about characterization in his arias which speak for themselves, especially in timbre, Vivaldi, precisely because of his compositional fluency, requires a constant level of onstage interpretation to allow his stylized and always virtuosic pieces to provide a stimulating background."
slug = "montezuma-long-lost-baroque-blueprints"
title = "Montezuma: long-lost baroque blueprints"
youtube_url = ""

+++
In [American Baroque Opera Company](/scene/companies/american-baroque-opera-co/)'s production of Antonio Vivaldi's opera _Montezuma_, not only did a long-lost era come back for a few hours with numerous colors, but also a method for presenting Vivaldi as a composer capable of creating dramatically effective situations.

Given the fact that this opera was only recently discovered, and in fragmentary form requiring the interpolation of other arias and recomposition of several passages, presenting such a piece in a way that feels unified in conception will always be a challenge. ABOC was entirely up to the task in several aspects, particularly in highlighting how important the staging of Baroque opera is to complement the extremely stylized and outlandish plots of several of these works, even though Vivaldi's music is very much among the most exuberant and inspired among his operatic contemporaries on the Italian peninsula. While Handel provides so many details about characterization in his arias which speak for themselves, especially in timbre, Vivaldi, precisely because of his compositional fluency, requires a constant level of onstage interpretation to allow his stylized and always virtuosic pieces to provide a stimulating background.

>There was always a dramatic "why" behind every da capo aria's B section, an elusive quality in a work where such things tend to look nondescript on paper.

Throughout the performance, the orchestra assumed far greater importance than is often given credit in Baroque opera. Under the direction of Eric Smith, they provided an atmosphere in direct counterpoint to the consistently spontaneous onstage action, giving the singers a very effective fulcrum on which to balance their dramatic delivery. Moreover, from the beginning, an extroverted aura of _sfida_ (defiance), so beloved in Vivaldi's instrumental music, was here presented as organic and complementary to the singers' virtuosity, giving a secure foundation for the singers' judicious unwritten additions and spontaneous declamation. Moreover, there was always a dramatic "why" behind every da capo aria's B section, an elusive quality in a work where such things tend to look nondescript on paper, tending to blend together.

With a backdrop resembling some sort of stereotypical Mesoamerican calendar, and costumes including elaborate headdresses for the principals, and with several costumes made in Iztapalapa, an eastern neighborhood of Mexico City, the stage was indeed designed with liveliness in mind. Given the stage's close quarters, which themselves created the appearance of narrow corridors and a resultant aura of conspiracy, the inevitable culture clash brought about by the interposition of the Spaniards' elaborate ruffs was even more satisfactorily shocking than expected from the very beginning.

As the Emperor Montezuma, bass-baritone [Ryan Kuster](/scene/people/ryan-kuster/) was suitably conflicted in all manner of ways. From the beginning, his performance cast a distinctly melancholy tone on the whole production, highly appropriate given the number of minor-key arias that begin this opera. Indeed, the great deal of emotional maturity Montezuma is required to sustain renders this role difficult to bring to life. Indeed, Kuster showed his conflict throughout by manifesting various degrees of existential discomfort with his headdress, particularly towards the end when his submission to the Spanish is all but inevitable. At that point, his final aria, showcasing his loss of control over everything, could definitely be viewed in pronounced relief.

Hannah Ceniseros imbued the role of Mitrena with great dignity and histrionic range. Such a part, very typical of the sort that Vivaldi wrote for his regular contralto, Anna Girò, with huge contrasts in register and a climactic mad scene (in the presence of a gargantuan high priest dressed with a skull), can be readily described as multi-faceted. Ceniseros was very much up to the task of making this role consistently individual, even with its tendencies towards the tragic, yet stylized, side of the spectrum. Any role that displays as much focus on maternal love as Mitrena does certainly deserves no less.

>Indeed, Kuster showed his conflict throughout by manifesting various degrees of existential discomfort with his headdress.

Her daughter, Teutile (soprano Jendi Tarde), was herself very decidedly a dramatic case study. Anyone playing this role has to settle on the right balance of emotional independence versus familial loyalty, a dilemma bound to make any Aztec princess a little bit off-kilter. Indeed, despite her last aria being set during her own ritual sacrifice, Vivaldi makes it as extremely and disturbingly tranquil as possible and Tarde's restraint in her vocal line was quite highlighted by her facial deliberation in processing her emotional reaction to her most dire situation. (This could also be said about her previous aria, "Un guardo, o Dio," where she has just heard the fatal oracle condemning her to be sacrificed, which Vivaldi sets with an air of almost delusional innocuousness.) Especially enjoyable was the amount of tension she clearly displayed with her Spanish significant other, Ramiro (Janna Elesia Cruz), in her first aria, which displayed a great deal of unsettled, pent-up energy in its frequent, almost Handelian though not as overt, alternation of tempos.

Countertenor Nicholas Garza as Fernando had quite a vocal adventure through the several arias he was tasked with singing. The first one in particular was very difficult to navigate under the best of circumstances, with vertiginous leaps, and the overall tessitura was quite different from what might otherwise be expected (the newly composed recitatives lying quite high in comparison). Any such challenges notwithstanding, Garza was a great actor in portraying the conquistador's subtle deception, in being studiously controlled in his movements (in a very Baroque manner), to the extent that his protestations that "he had not violated the rules of chivalry" could be seen to be quite hollow indeed.

>Many less well-known operatic works from this period have the feel of blueprints.

As his brother Ramiro, Janna Elesia Critz sang in a very refined manner; indeed, her first aria reminded me greatly of the French style. Indeed, this in itself was very interesting given that her makeup gave her a decidedly grim, even gruff, countenance whenever she appeared, even during her more pensive moments. Countertenor Keymon Murrah, arrayed with a flamboyant eagle warrior headdress, greatly impressed in the role of Mexican general Asprano, which calls for numerous bravura scales very high in the soprano range; one of his arias had trumpeter Casey Goldman assuming a very extroverted star role alongside him. The word "unreal" was justifiably invoked many times after this performance to describe his expressive and effulgent vocal acrobatics.

To say all the above succinctly, my experience has certainly demonstrated that many less well-known operatic works from this period have the feel of blueprints which require an active deal of effort to realize and reinvigorate convincingly. American Baroque Opera Company has once again demonstrated not only that _Montezuma_ is deserving of greater attention, but also that it is crucial that these sorts of operas be viewed not merely from the musical point of view or as mere amusement, but as theatrical experiences wherein the musical score is merely one layer of the composite image of the totality of what occurs on any particular evening.