+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2019-02-23T18:15:45+00:00"
disclaimer = ""
image_gallery = []
postamble = "_The Monstrous Child_ is onstage at the Linbury Theatre through 3 March. For details and tickets, [click here](https://www.roh.org.uk/productions/the-monstrous-child-by-timothy-sheader)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1550945700/media/2019/02/sqPR8A6410rMartaFontanalsSimmonsasHelROH2019.jpg"
primary_image_credit = "Marta Fontanals-Simmons as Hel in The Monstrous Child, ROH, 2019. Photo: Stephen Cummiskey."
related_articles = ["articles/tarrare-the-freak-i-just-want-to-be-full.md", "articles/monstrous-child.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/marta-fontanals-simmons.md", "scene/people/gavin-higgins.md"]
short_description = "It was very much a young person's opera and was therefore theatrical in a way that is rarely seen in large scale opera productions. Though it is meant for a younger crowd, it wasn't overly simplified or polite. It was gritty, honest, and unapologetic."
slug = "inventive-and-playful-monstrous-child"
title = "Inventive and playful: The Monstrous Child"
youtube_url = ""

+++
This was an evening of firsts; the world premiere of a new opera and a chance for [The Royal Opera](/scene/companies/royal-opera-house/) to show off its newest venue, the intimate 400-seat, recently refurbished Linbury Theatre, part of the three year-long reconstruction of Covent Garden, a reconstruction project that is costing the Royal Opera no less the £50 million. All of this in an attempt to breath life into a tired, fussy space, and to hopefully begin to shake off the "elitist" label they've been carrying around for years. And what better way to showcase this sleek new venue, than to produce an exciting world premiere.

> She is speaking directly to every young girl who has ever felt unlovable.

[_The Monstrous Child_](https://www.roh.org.uk/productions/the-monstrous-child-by-timothy-sheader) is young composer Gavin Higgins' operatic debut having already gained acclaim with his orchestral commissions for the likes of the BBC Symphony Orchestra, The London Philharmonic Orchestra, and the Royal Scottish National Orchestra. The libretto was written by Francesca Simon and adapted from her young adult novel of the same name that tells the story of the Norse legend of Hel, a teenage girl born of the trickster Loki and the giantess Angrboda who is half human, half corpse. Fearing the prophecy that Loki's monstrous children will destroy the Heavens and the earth, Odin banishes Hel to the underworld where she reigns over the dead and pines for the god Baldr, whom she has fallen devastatingly in love with, as she awaits the end of the world.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550945807/media/2019/02/IMG_0654rMartaFontanalsSimmonsasHelROH2019.jpg){{% /md %}}

<figcaption>Marta Fontanals-Simmons as Hel in The Monstrous Child, ROH, 2019. Photo: Stephen Cummiskey.</figcaption>

</figure>

The Norse legends are stories that we are all familiar with in one way or another. Wagner is possibly the most famous example having created his behemoth _Ring_ cycle from these stories, but more recently, Marvel Studios has made multi-millions with its popular Thor franchise. Something about these tales has been captivating audiences imaginations for years. They certainly provide opportunity for plenty of cinematic drama, but I was particularly struck by the heart in this rendition. It is told from Hel's perspective and in many ways, she is your average, every-day teenager; she is tormented by her older brothers, her parents don't understand her, and she has an all-consuming crush. The picture of loneliness and isolation, Hel sings of never being loved or touched by anyone until she was touched by Baldr; her father was absent, and her mother couldn't bare the shame of her. She is speaking directly to every young girl who has ever felt unlovable.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550945893/media/2019/02/IMG_0583rTheMonstrousChildproductionimageROH2019.jpg){{% /md %}}

<figcaption>A scene from The Monstrous Child, ROH, 2019. Photo: Stephen Cummiskey.</figcaption>

</figure>

It was very much a young person's opera and was therefore theatrical in a way that is rarely seen in large scale opera productions. Though it is meant for a younger crowd, it wasn't overly simplified or polite. It was gritty, honest, and unapologetic. With its arts-and-crafts aesthetic, imaginative puppetry, and sense of humour, it was a very engaging and approachable piece. There was a real sense of ensemble in the production. Each singer played multiple roles and, in most cases, was required to assist the two puppeteers in the manoeuvring of the puppetry. Designer Paul Wills has created a strange and unpredictable world inspired by the textures and colours of the Norse landscape. My favourite piece of set design was the earthy mountain of mouldering rot that Hel had become entombed in after centuries in the underworld. Oozing, and obscene it was the perfect metaphor for her imprisonment and feelings of self-loathing.

> In fact, Higgins included a few cheeky Wagner quotes in a nod to the beloved cycle.

Mezzo-soprano [Marta Fontanals-Simmons](/scene/people/marta-fontanals-simmons/) who makes her Royal Opera debut in the role of Hel is likeable, self-aware, strong willed, and a relatable character for young girls. As the narrator and central character of this piece, Fontanals-Simmons welcomed us into her world, inviting us to hear her story. She has a beautiful voice; dark and smooth when need be but was unafraid to embrace the uglier sounds Higgins' score propelled her towards. She is a sensitive and accomplished actor, challenged by the confines of the staging (She did not have the use of her legs which were trapped inside of the mountain of rot), she used her face and her entrancing voice as her expressive tools.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550945958/media/2019/02/PR8A5672rLauraCaldowandLucySchauferROH2019.jpg){{% /md %}}

<figcaption>Laura Caldow and Lucy Schaufer in The Monstrous Child, ROH, 2019. Photo: Stephen Cummiskey.</figcaption>

</figure>

I was impressed by composer Gavin Higgins' deft and confident approach to the vocal writing, particularly as this was his first opera commission. The vocal lines worked with, and for the singers. The text setting flowed seamlessly, and the orchestral writing stepped out of the way to give Simon's libretto prominence, allowing its dark humour to shine through. Scored for chamber orchestra, the piece was sometimes yearning, sometimes pensive, and sometimes playfully childlike. There was a considerable amount of colour and scope particularly for such a small ensemble which was aided by some surprising instrumentation choices such as the tubular bells which make a brief, but memorable appearance towards the end of the piece, electric organ, celeste, and recorder. In Reminiscent of Wagner, each of these instruments appearance announce a character's motif, inviting the listener into this sound world. In fact, Higgins included a few cheeky Wagner quotes in a nod to the beloved cycle.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550946119/media/2019/02/PR8A5927rDanShelveyasBaldrROH2019.jpg){{% /md %}}

<figcaption>Dan Shelvey as Baldr in The Monstrous Child, ROH, 2019. Photo: Stephen Cummiskey.</figcaption>

</figure>

It was a clever and calculated move to programme [_The Monstrous Child_](https://www.roh.org.uk/productions/the-monstrous-child-by-timothy-sheader) in the same season the _Ring_ cycle is being staged; it provides two alternative narratives to two very similar stories. And I think the choice to open the new Linbury theatre with an offbeat, youthful piece, is a movement in the right direction for this performance space. It sends an important message about how forward-thinking this company wants to be at a time when they are constantly having to walk the line between tradition and innovation; something I believe that at the moment, they are doing quite successfully. If this is how the Royal Opera means to go on, producing inventive and playful commissions in its newest, swankiest theatre, then I'm all in.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550946159/media/2019/02/SC1_9545rTheMonstrousChildproductionimageROH2019.jpg){{% /md %}}

<figcaption>Production image of The Monstrous Child, ROH, 2019. Photo: Stephen Cummiskey.</figcaption>

</figure>