+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2017-10-19T20:03:00-04:00"
lastmod = "2017-10-26T23:19:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508859269872/2017-10-24---Rich.jpg.jpg"
publishDate = "2017-10-26T23:19:00-04:00"
related_articles = ["articles/the-opera-party-monologue.md","articles/the-opera-posse-phenomenon.md"]
short_description = "There&#039;s a funny catch, though, because when you&#039;re sitting in those pricey sections of the opera house, your neighbours are likely of a certain demographic; basically, they&#039;re sitting in those seats because they&#039;re good, and they can afford them. The important thing to note here is not that there are wealthy people who go to the opera, but that there&#039;s likely a stark difference between their tax bracket, and that of someone who writes about opera for a living."
slug = "money-manners-observations"
title = "Money &amp; manners: one critic&#039;s observations from her really great opera seats"
+++

Readers, a bit of anecdotal observation for you:

Often when I go to the opera, I'm there as a member of the press. That means that I've been generously comped a ticket (or two) by the company, and often those tickets are for seats that are arguably great. I can only assume that companies are willing to offer seats with excellent visibility and optimal sound balance because they want press folks to have the best experience possible at their show - and maximise the chances that they'll write an awesome review.

If I'm being frank, great seats are also expensive seats. And when we're talking about the world's major opera houses, I've had the chance to sit in sections that cost well over $100 (£100, even). Those seats do not go unappreciated, I guarantee.

There's a funny catch, though, because when you're sitting in those pricey sections of the opera house, your neighbours are likely of a certain demographic; basically, they're sitting in those seats because they're good, and they can afford them. The important thing to note here is not that there are wealthy people who go to the opera, but that there's likely a stark difference between their tax bracket, and that of someone who writes about opera for a living.

In the same way that the musicians hired to perform (or socialise) at [swanky cocktail parties](/the-opera-party-monologue/) at luxurious homes can feel a bit like an alien or an animal at a zoo, it can be a fascinating experience for a freelance writer to share space for an evening with folks who are *much* more financially comfortable. In hindsight, maybe I shouldn't be surprised at what I've noticed after many of these nights among the wealthy:

For people who have spent a lot on their evening out, pricey ticket-holders have surprisingly bad opera-going manners.

I guess there's this idea that the "riff-raff" up in the nosebleed section are the ones who don't go to the opera very often, or aren't in a position to appreciate it - and by extension, they'd be the ones to commit a faux-pas like blatant opening of plastic-wrapped candies or loudly-whispered conversations during the show that bother their neighbours.

But, no. If it's happening in the nosebleeds, it's also happening at orchestra level, among the people who seem more than comfortable in their opera-going garb, and settling into their great seats. It's among these folks that you hear more unnecessary and animal-like behaviour, guaranteed to interrupt your enjoyment of the opera. They show up late, and don't GAF about it. They're going to make their way to their middle-of-the-row seats slowly and calmly, and they're going to sit down once their coats and scarves are off and they're good and ready. If they're not late, and instead sitting comfortably in their seats well before the curtain rises, they're somewhat ironically the type who won't stand up from their aisle seat to let you scoot by. They do that lame lifting of their toes, shifting their knees about 4 degrees to the left, to show that they know you're there, but they're not about to share the burden of making space for two people to exist in a single row of seating.

They're the kind of people who have utterly unnecessary conversations amongst themselves, and not even whispered to show that they're aware that it's in bad form. They're the people who think that slow rooting around in their purses and belaboured opening of blister-pack gum wrappers makes the whole thing less offensive. They mosey around on Instagram after the lights go down and the overture begins. They're the people who clear their throat at regular intervals because they're bored.

What's up with this? Am I giving too much credit to the well-off opera veterans among the crowd? It seems old-fashioned to imagine they sense some sort of entitlement or propriety to what's happening onstage, even if they're indeed patrons and donors to the company. Perhaps compared to the nosebleed crowd, a night at the opera isn't as special for these orchestra-level folks, and so they're less aware of their manners. Maybe it's just not about the show at all, and instead it's about being seen, mingling with the right people, and being well-dressed while they're at it.

Or maybe it's even more simple than that: maybe money doesn't make manners, and the opera house is one of the great bringers-together of what we all have in common. Is that a poetic enough way to say it?
